/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.util;

import java.util.Collection;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.TraitListProperty;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.GearComponent;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;

public interface GearComponentInstance<A extends GearComponent<?>> {
    @Nullable
    public A get();

    public Identifier getId();

    public ItemStack getItem();

    public <T, V extends GearPropertyValue<T>> T getProperty(PartType var1, PropertyKey<T, V> var2);

    default public <T, V extends GearPropertyValue<T>> T getProperty(PartType partType, GearProperty<T, V> property) {
        return this.getProperty(partType, PropertyKey.of(property, (GearType)GearTypes.ALL.get()));
    }

    default public <T, V extends GearPropertyValue<T>> T getProperty(Supplier<PartType> partType, PropertyKey<T, V> key) {
        return this.getProperty(partType.get(), key);
    }

    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PartType var1, PropertyKey<T, V> var2);

    default public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(Supplier<PartType> partType, PropertyKey<T, V> key) {
        return this.getPropertyModifiers(partType.get(), key);
    }

    default public Collection<TraitInstance> getTraits(PartGearKey key) {
        TraitListProperty property = GearProperties.TRAITS.get();
        Collection<TraitListPropertyValue> mods = this.getPropertyModifiers(key.partType(), PropertyKey.of(property, key.gearType()));
        return (Collection)property.compute(mods);
    }

    default public Component getDisplayName(PartType type) {
        return this.getDisplayName(type, ItemStack.EMPTY);
    }

    public Component getDisplayName(PartType var1, ItemStack var2);

    public int getNameColor(PartType var1, GearType var2);
}

