/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.setup.SgTags;

public class FluffyBlock
extends Block {
    private final DyeColor dyeColor;

    public FluffyBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.dyeColor = color;
    }

    public DyeColor getDyeColor() {
        return this.dyeColor;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, double fallDistance) {
        int stackedBlocks;
        if (fallDistance < 2.0 || level.isClientSide()) {
            return;
        }
        for (stackedBlocks = 0; stackedBlocks < 10 && level.getBlockState(pos).is(SgTags.Blocks.FLUFFY_BLOCKS); ++stackedBlocks) {
            pos = pos.below();
        }
        double newDistance = fallDistance - Math.min((double)(8 * stackedBlocks), fallDistance);
        entity.fallDistance = 0.0;
        entity.causeFallDamage(newDistance, 1.0f, level.damageSources().fall());
    }

    public void updateEntityMovementAfterFallOn(BlockGetter level, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(level, entity);
        } else {
            FluffyBlock.bounceEntity(entity);
        }
    }

    private static void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.getDeltaMovement();
        if (vector3d.y < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vector3d.x, -vector3d.y * 0.5 * d0, vector3d.z);
        }
    }

    private static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack mainHand;
        if (event.getState().is(SgTags.Blocks.FLUFFY_BLOCKS) && !(mainHand = event.getEntity().getItemInHand(InteractionHand.MAIN_HAND)).isEmpty() && mainHand.getItem() instanceof ShearsItem) {
            float efficiency = (float)event.getEntity().getAttributeValue(Attributes.MINING_EFFICIENCY);
            float speed = event.getNewSpeed() * 4.0f + efficiency;
            event.setNewSpeed(speed);
        }
    }

    static {
        NeoForge.EVENT_BUS.addListener(FluffyBlock::onGetBreakSpeed);
    }
}

