/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.silentchaos512.gear.block.INamedContainerExtraData;

public abstract class ModContainerBlock<T extends BlockEntity>
extends BaseEntityBlock {
    private final BlockEntityType.BlockEntitySupplier<T> tileFactory;

    public ModContainerBlock(BlockEntityType.BlockEntitySupplier<T> tileFactory, BlockBehaviour.Properties properties) {
        super(properties);
        this.tileFactory = tileFactory;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return this.tileFactory.create(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity tile;
        if (!worldIn.isClientSide() && (tile = worldIn.getBlockEntity(pos)) instanceof INamedContainerExtraData) {
            INamedContainerExtraData te = (INamedContainerExtraData)tile;
            if (player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)te, te::encodeExtraData);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

