/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import org.jetbrains.annotations.NotNull;

public abstract class SgContainerBlockEntity
extends BaseContainerBlockEntity {
    protected final NonNullList<ItemStack> items;

    protected SgContainerBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.items = this.createInternalItemList();
    }

    protected SgContainerBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, Supplier<NonNullList<ItemStack>> itemListFactory) {
        super(pType, pPos, pBlockState);
        this.items = itemListFactory.get();
    }

    public abstract NonNullList<ItemStack> createInternalItemList();

    public abstract boolean canPlaceItem(int var1, ItemStack var2);

    public boolean canExtractItem(int slot) {
        return true;
    }

    public ResourceHandler<@NotNull ItemResource> getItemHandler() {
        return new ItemStacksResourceHandler(this.items);
    }

    @Deprecated
    protected NonNullList<ItemStack> getItems() {
        NonNullList result = NonNullList.withSize((int)this.items.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.items.size(); ++i) {
            result.set(i, (Object)((ItemStack)this.items.get(i)));
        }
        return result;
    }

    @Deprecated
    protected void setItems(NonNullList<ItemStack> pItems) {
        for (int i = 0; i < this.items.size() && i < pItems.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)pItems.get(i)));
        }
    }

    public void clearContent() {
        this.items.clear();
    }

    public ItemStack getItem(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.items.get(pSlot);
        boolean itemsIdentical = !pStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)pStack);
        this.items.set(pSlot, (Object)pStack);
        if (pStack.getCount() > this.getMaxStackSize()) {
            pStack.setCount(this.getMaxStackSize());
        }
        if (pSlot < this.getContainerSize() - 1 && !itemsIdentical) {
            this.setChanged();
        }
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        if (pSlot >= 0 && pSlot < this.items.size() && !((ItemStack)this.items.get(pSlot)).isEmpty() && pAmount > 0) {
            ItemStack stackInSlot = (ItemStack)this.items.get(pSlot);
            this.items.set(pSlot, (Object)stackInSlot.copyWithCount(stackInSlot.getCount() - pAmount));
            return stackInSlot.copyWithCount(pAmount);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        if (pSlot >= 0 && pSlot < this.items.size()) {
            ItemStack stack = (ItemStack)this.items.get(pSlot);
            this.items.set(pSlot, (Object)ItemStack.EMPTY);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public int getContainerSize() {
        return this.items.size();
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        ContainerHelper.loadAllItems((ValueInput)input, this.items);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        ContainerHelper.saveAllItems((ValueOutput)output, this.items);
    }
}

