/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.alloymaker;

import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.block.ModContainerBlock;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerBlockEntity;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerInfo;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.util.TextUtil;

public class AlloyMakerBlock<R extends AlloyRecipe>
extends ModContainerBlock<AlloyMakerBlockEntity<R>> {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)27.0, (double)15.0);
    private final AlloyMakerInfo<R> info;
    private final MapCodec<AlloyMakerBlock<R>> codec;

    public AlloyMakerBlock(AlloyMakerInfo<R> info, BlockBehaviour.Properties properties) {
        super((pos, state) -> new AlloyMakerBlockEntity(info, pos, state), properties);
        this.info = info;
        this.codec = AlloyMakerBlock.simpleCodec(p -> new AlloyMakerBlock(info, (BlockBehaviour.Properties)p));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public Collection<IMaterialCategory> getCategories() {
        return this.info.getCategories();
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (worldIn.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.interactWith(worldIn, pos, player);
        return InteractionResult.CONSUME;
    }

    protected void interactWith(Level worldIn, BlockPos pos, Player player) {
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof AlloyMakerBlockEntity) {
            AlloyMakerBlockEntity compoundMaker = (AlloyMakerBlockEntity)tileEntity;
            if (player instanceof ServerPlayer) {
                player.openMenu((MenuProvider)compoundMaker, compoundMaker::encodeExtraData);
            }
        }
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        Set<Component> catNameSet = this.info.getCategories().stream().map(IMaterialCategory::getDisplayName).collect(Collectors.toSet());
        MutableComponent catStr = TextUtil.separatedList(catNameSet);
        if (catStr != null) {
            tooltip.add((Component)TextUtil.translate("block", "alloy_maker.desc", catStr));
        } else {
            tooltip.add((Component)TextUtil.translate("block", "super_mixer.desc"));
        }
        return tooltip;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : AlloyMakerBlock.createTickerHelper(blockEntityType, this.info.getBlockEntityType(), this.info.getServerBlockEntityTicker());
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return this.codec;
    }
}

