/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.fml.ModList;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.INamedContainerExtraData;
import net.silentchaos512.gear.block.SgContainerBlockEntity;
import net.silentchaos512.gear.block.charger.ChargerContainerMenu;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.modifier.ChargedMaterialModifier;
import net.silentchaos512.gear.gear.material.modifier.StarchargedMaterialModifier;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class ChargerBlockEntity<T extends ChargedMaterialModifier>
extends SgContainerBlockEntity
implements INamedContainerExtraData {
    static final int INVENTORY_SIZE = 3;
    private static final int UPDATE_FREQUENCY = TimeUtils.ticksFromSeconds((float)15.0f);
    private final ChargedMaterialModifier.Type<T> modifierType;
    private int progress = 0;
    private int workTime = 100;
    private int charge = 0;
    private int structureLevel;
    private int updateTimer = 0;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> ChargerBlockEntity.this.progress;
                case 1 -> ChargerBlockEntity.this.workTime;
                case 2 -> ChargerBlockEntity.this.structureLevel;
                case 3 -> ChargerBlockEntity.this.charge & 0xFFFF;
                case 4 -> ChargerBlockEntity.this.charge >> 16 & 0xFFFF;
                case 5 -> ChargerBlockEntity.this.getMaxCharge() & 0xFFFF;
                case 6 -> ChargerBlockEntity.this.getMaxCharge() >> 16 & 0xFFFF;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    ChargerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    ChargerBlockEntity.this.workTime = value;
                    break;
                }
                case 2: {
                    ChargerBlockEntity.this.structureLevel = value;
                }
            }
        }

        public int getCount() {
            return 7;
        }
    };

    public ChargerBlockEntity(BlockEntityType<?> type, ChargedMaterialModifier.Type<T> modifierType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.modifierType = modifierType;
    }

    public static ChargerBlockEntity<StarchargedMaterialModifier> createStarlightCharger(BlockPos pos, BlockState state) {
        return new ChargerBlockEntity<StarchargedMaterialModifier>((BlockEntityType)SgBlockEntities.STARLIGHT_CHARGER.get(), (ChargedMaterialModifier.Type)MaterialModifiers.STARCHARGED.get(), pos, state);
    }

    protected int getMaxCharge() {
        return (Integer)Config.Common.starlightChargerMaxCharge.get();
    }

    @Override
    public void encodeExtraData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.fields.getCount());
    }

    protected int getWorkTime(ItemStack input) {
        MaterialInstance material = MaterialInstance.from(input);
        if (material != null) {
            float rarity = ((Float)material.getProperty((PartType)PartTypes.MAIN.get(), GearProperties.RARITY.get())).floatValue();
            float clampedRarity = Mth.clamp((float)rarity, (float)5.0f, (float)500.0f);
            return (int)(5.0f * clampedRarity);
        }
        List data = (List)input.get(SgDataComponents.MATERIAL_LIST);
        if (data != null) {
            for (MaterialInstance materialInstance : data) {
                StarchargedMaterialModifier materialChargeMod = (StarchargedMaterialModifier)materialInstance.getModifier((IMaterialModifierType)MaterialModifiers.STARCHARGED.get());
                if (materialChargeMod != null) continue;
                float rarity = ((Float)materialInstance.getProperty((PartType)PartTypes.MAIN.get(), GearProperties.RARITY.get())).floatValue();
                float clampedRarity = Mth.clamp((float)rarity, (float)5.0f, (float)500.0f);
                return (int)(5.0f * clampedRarity);
            }
        }
        return -1;
    }

    protected int getDrainRate(ItemStack input, int level) {
        return 150 + 50 * level * level;
    }

    protected int getChargingAgentTier(ItemStack catalyst) {
        return ChargerBlockEntity.getStarlightChargerCatalystTier(catalyst);
    }

    public static int getStarlightChargerCatalystTier(ItemStack catalyst) {
        for (int i = SgTags.Items.STARLIGHT_CHARGER_TIERS.size() - 1; i >= 0; --i) {
            if (!catalyst.is(SgTags.Items.STARLIGHT_CHARGER_TIERS.get(i))) continue;
            return i + 1;
        }
        return 0;
    }

    protected int getMaterialChargeLevel(ItemStack stack) {
        return this.modifierType.checkLevel(stack);
    }

    public static boolean canCharge(ItemStack stack) {
        if (ChargerBlockEntity.canChargePartItem(stack)) {
            return true;
        }
        MaterialInstance material = MaterialInstance.from(stack);
        if (material == null) {
            return false;
        }
        for (IMaterialModifier modifier : material.getModifiers()) {
            if (!(modifier instanceof ChargedMaterialModifier)) continue;
            return false;
        }
        return true;
    }

    private static boolean canChargePartItem(ItemStack stack) {
        boolean isCompoundMaterial = stack.getItem() instanceof CompoundMaterialItem;
        if (isCompoundMaterial || !ChargerBlockEntity.isChargingPartsAllowed()) {
            return false;
        }
        List data = (List)stack.get(SgDataComponents.MATERIAL_LIST);
        if (data != null) {
            for (MaterialInstance materialInstance : data) {
                StarchargedMaterialModifier materialChargeMod = (StarchargedMaterialModifier)materialInstance.getModifier((IMaterialModifierType)MaterialModifiers.STARCHARGED.get());
                if (materialChargeMod != null) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isChargingPartsAllowed() {
        return Config.Common.isLoaded() && (Boolean)Config.Common.starlightChargerCanChargeParts.get() != false || ModList.get().isLoaded("sgearmetalworks");
    }

    protected void chargeMaterial(ItemStack output, int level) {
        if (this.chargePartItem(output, level)) {
            return;
        }
        T mod = this.modifierType.create(level);
        this.modifierType.addModifier(mod, output);
    }

    protected boolean chargePartItem(ItemStack output, int level) {
        T mod = this.modifierType.create(level);
        boolean isCompoundMaterial = output.getItem() instanceof CompoundMaterialItem;
        ArrayList<MaterialInstance> data = (ArrayList<MaterialInstance>)output.get(SgDataComponents.MATERIAL_LIST);
        if (data != null && !isCompoundMaterial) {
            data = new ArrayList<MaterialInstance>(data);
            for (int i = 0; i < data.size(); ++i) {
                MaterialInstance materialInstance = (MaterialInstance)data.get(i);
                StarchargedMaterialModifier materialChargeMod = (StarchargedMaterialModifier)materialInstance.getModifier((IMaterialModifierType)MaterialModifiers.STARCHARGED.get());
                if (materialChargeMod != null) continue;
                data.remove(i);
                ItemStack materialStack = materialInstance.getItem();
                this.modifierType.addModifier(mod, materialStack);
                data.add(MaterialInstance.of(materialInstance.get(), materialStack));
                break;
            }
            output.set(SgDataComponents.MATERIAL_LIST, data);
            return true;
        }
        return false;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ChargerBlockEntity<?> blockEntity) {
        blockEntity.gatherEnergy();
        if (++blockEntity.updateTimer > UPDATE_FREQUENCY) {
            if (blockEntity.checkStructureLevel()) {
                SilentGear.LOGGER.info("{}} at {}: structure level updated to {}", (Object)NameUtils.fromBlock((BlockState)blockEntity.getBlockState()), (Object)blockEntity.worldPosition, (Object)blockEntity.structureLevel);
            }
            blockEntity.updateTimer = 0;
        }
        ItemStack input = blockEntity.getItem(0);
        ItemStack catalyst = blockEntity.getItem(1);
        if (input.isEmpty() || catalyst.isEmpty()) {
            return;
        }
        int currentLevel = blockEntity.getMaterialChargeLevel(input);
        if (currentLevel < blockEntity.structureLevel) {
            blockEntity.handleCharging(input, catalyst);
        } else if (blockEntity.progress > 0) {
            blockEntity.progress = 0;
            blockEntity.workTime = 100;
        }
    }

    protected void gatherEnergy() {
        assert (this.level != null);
        if (this.canGatherEnergy()) {
            int newCharge = this.charge + (Integer)Config.Common.starlightChargerChargeRate.get();
            this.charge = newCharge < 0 || newCharge > this.getMaxCharge() ? this.getMaxCharge() : newCharge;
        }
    }

    protected boolean canGatherEnergy() {
        return this.charge < this.getMaxCharge() && this.checkTimeOfDay() && this.checkViewOfSky(this.worldPosition.above());
    }

    protected boolean checkTimeOfDay() {
        WorkTime workTime = Config.Common.isLoaded() ? (WorkTime)((Object)Config.Common.starlightChargerWorkTime.get()) : WorkTime.NIGHTTIME;
        return this.level != null && workTime.isWorkTime(this.level);
    }

    protected boolean checkViewOfSky(BlockPos pos) {
        boolean requiresSky = Config.Common.isLoaded() ? (Boolean)Config.Common.starlightChargerRequiresViewOfSky.get() : true;
        return !requiresSky || this.level != null && this.level.canSeeSkyFromBelowWater(pos);
    }

    private void handleCharging(ItemStack input, ItemStack catalyst) {
        assert (this.level != null);
        int chargeLevel = this.getChargingAgentTier(catalyst);
        int drainRate = this.getDrainRate(input, chargeLevel);
        if (ChargerBlockEntity.canCharge(input) && chargeLevel > this.getMaterialChargeLevel(input) && chargeLevel <= this.structureLevel && this.charge >= drainRate) {
            ItemStack output = input.copy();
            output.setCount(1);
            this.chargeMaterial(output, chargeLevel);
            if (this.wouldFitInOutputSlot(output, chargeLevel)) {
                ++this.progress;
                this.charge -= drainRate;
                this.workTime = this.getWorkTime(input);
                if (this.progress >= this.workTime) {
                    if (this.getItem(2).isEmpty()) {
                        this.setItem(2, output);
                    } else {
                        this.getItem(2).grow(1);
                    }
                    this.progress = 0;
                    this.removeItem(0, 1);
                    this.removeItem(1, 1);
                }
            }
        }
    }

    private boolean wouldFitInOutputSlot(ItemStack input, int chargeTier) {
        ItemStack output = this.getItem(2);
        if (output.isEmpty()) {
            return true;
        }
        return output.getCount() < output.getMaxStackSize() && ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)output);
    }

    protected boolean checkStructureLevel() {
        int oldValue = this.structureLevel;
        this.structureLevel = MathUtils.min((int)this.getPillarLevel(this.worldPosition.relative(Direction.NORTH, 3).relative(Direction.WEST, 3)), (int)this.getPillarLevel(this.worldPosition.relative(Direction.NORTH, 3).relative(Direction.EAST, 3)), (int)this.getPillarLevel(this.worldPosition.relative(Direction.SOUTH, 3).relative(Direction.WEST, 3)), (int)this.getPillarLevel(this.worldPosition.relative(Direction.SOUTH, 3).relative(Direction.EAST, 3)));
        return this.structureLevel != oldValue;
    }

    protected int getPillarLevel(BlockPos pos) {
        assert (this.level != null);
        BlockState state = this.level.getBlockState(pos.above(2));
        if (state.getBlock() == SgBlocks.CRIMSON_STEEL_BLOCK.get()) {
            return 1;
        }
        if (state.getBlock() == SgBlocks.AZURE_ELECTRUM_BLOCK.get()) {
            return 2;
        }
        if (state.getBlock() == SgBlocks.TYRIAN_STEEL_BLOCK.get()) {
            return 3;
        }
        return 0;
    }

    protected Component getDefaultName() {
        return TextUtil.translate("container", "material_charger");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return ChargerContainerMenu.createStarlightCharger(id, player, (Container)this, this.fields);
    }

    @Override
    public NonNullList<ItemStack> createInternalItemList() {
        return NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        return switch (slot) {
            case 0 -> ChargerBlockEntity.canCharge(stack);
            case 1 -> stack.is(SgTags.Items.STARLIGHT_CHARGER_CATALYSTS);
            default -> false;
        };
    }

    @Override
    public boolean canExtractItem(int slot) {
        return slot == 2;
    }

    public void setChanged() {
        this.progress = 0;
        super.setChanged();
    }

    @Override
    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.progress = input.getInt("Progress").orElse(0);
        this.workTime = input.getInt("WorkTime").orElse(0);
        this.charge = input.getInt("Charge").orElse(0);
        this.structureLevel = input.getInt("StructureLevel").orElse(0);
    }

    @Override
    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putInt("Progress", this.progress);
        output.putInt("WorkTime", this.workTime);
        output.putInt("Charge", this.charge);
        output.putInt("StructureLevel", this.structureLevel);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tags = super.getUpdateTag(provider);
        tags.putInt("Progress", this.progress);
        tags.putInt("WorkTime", this.workTime);
        tags.putInt("Charge", this.charge);
        tags.putInt("StructureLevel", this.structureLevel);
        return tags;
    }

    public static enum WorkTime {
        DAYTIME(Level::isBrightOutside),
        NIGHTTIME(Level::isDarkOutside),
        ANYTIME(level -> true);

        private final Function<Level, Boolean> canWork;

        private WorkTime(Function<Level, Boolean> canWork) {
            this.canWork = canWork;
        }

        public boolean isWorkTime(Level level) {
            return this.canWork.apply(level);
        }
    }
}

