/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.charger;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.charger.ChargerContainerMenu;
import net.silentchaos512.gear.util.TextUtil;

public class ChargerContainerScreen
extends AbstractContainerScreen<ChargerContainerMenu> {
    public static final Identifier TEXTURE = SilentGear.getId("textures/gui/charger.png");

    public ChargerContainerScreen(ChargerContainerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (this.isHovering(153, 17, 13, 51, x, y)) {
            ImmutableList text = ImmutableList.of((Object)TextUtil.translate("container", "material_charger.charge", String.format("%,d", ((ChargerContainerMenu)this.menu).getCharge()), String.format("%,d", ((ChargerContainerMenu)this.menu).getMaxCharge())), (Object)TextUtil.translate("container", "material_charger.charge.hint"));
            graphics.setTooltipForNextFrame(this.font, (List)text, Optional.empty(), x, y);
        } else if (this.isHovering(8, 70, 100, 8, x, y)) {
            MutableComponent text = TextUtil.translate("container", "material_charger.structure_level.hint");
            graphics.setTooltipForNextFrame(this.font, List.of(text), Optional.empty(), x, y);
        }
        super.renderTooltip(graphics, x, y);
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
        MutableComponent text = TextUtil.translate("container", "material_charger");
        graphics.drawString(this.font, text.getString(), 8, 6, 0x404040, false);
        int structureLevel = ((ChargerContainerMenu)this.menu).fields.get(2);
        MutableComponent structureText = TextUtil.translate("container", "material_charger.structure_level", structureLevel);
        graphics.drawString(this.font, structureText.getString(), 8, 70, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        if (this.minecraft == null) {
            return;
        }
        int posX = (this.width - this.imageWidth) / 2;
        int posY = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, posX, posY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, posX + 79, posY + 35, 176.0f, 14.0f, ((ChargerContainerMenu)this.menu).getProgressArrowScale() + 1, 16, 256, 256);
        int chargeMeterHeight = ((ChargerContainerMenu)this.menu).getChargeMeterHeight();
        if (chargeMeterHeight > 0) {
            graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, posX + 154, posY + 68 - chargeMeterHeight, 176.0f, 31.0f, 12, chargeMeterHeight, 256, 256);
        }
    }
}

