/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.press;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.SgContainerBlockEntity;
import net.silentchaos512.gear.block.press.MetalPressBlock;
import net.silentchaos512.gear.block.press.MetalPressContainer;
import net.silentchaos512.gear.crafting.recipe.press.PressingRecipe;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.TimeUtils;

public class MetalPressBlockEntity
extends SgContainerBlockEntity {
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final RecipeManager.CachedCheck<SingleRecipeInput, PressingRecipe> quickCheck;
    private int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            if (index == 0) {
                return MetalPressBlockEntity.this.progress;
            }
            return 0;
        }

        public void set(int index, int value) {
            if (index == 0) {
                MetalPressBlockEntity.this.progress = value;
            }
        }

        public int getCount() {
            return 1;
        }
    };

    public MetalPressBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.METAL_PRESS.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)SgRecipes.PRESSING_TYPE.get()));
    }

    @Nullable
    public PressingRecipe getRecipe(ItemStack stack) {
        if (this.level == null || stack.isEmpty()) {
            return null;
        }
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RecipeHolder holder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), serverLevel).orElse(null);
        if (holder != null) {
            return (PressingRecipe)holder.value();
        }
        return null;
    }

    private ItemStack getWorkOutput(@Nullable PressingRecipe recipe, RegistryAccess registryAccess) {
        if (recipe != null) {
            return recipe.assemble(new SingleRecipeInput(this.getItem(0)), (HolderLookup.Provider)registryAccess);
        }
        return ItemStack.EMPTY;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MetalPressBlockEntity blockEntity) {
        PressingRecipe recipe = blockEntity.getRecipe(blockEntity.getItem(0));
        if (recipe != null) {
            blockEntity.doWork(recipe, level.registryAccess());
        } else {
            blockEntity.stopWork();
        }
    }

    private void doWork(PressingRecipe recipe, RegistryAccess registryAccess) {
        assert (this.level != null);
        ItemStack current = this.getItem(1);
        ItemStack output = this.getWorkOutput(recipe, registryAccess);
        if (!current.isEmpty()) {
            int newCount = current.getCount() + output.getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)output) || newCount > output.getMaxStackSize()) {
                this.stopWork();
                return;
            }
        }
        if (this.progress < WORK_TIME) {
            ++this.progress;
        }
        if (this.progress >= WORK_TIME && !this.level.isClientSide()) {
            this.finishWork(recipe, registryAccess, current);
        }
        this.sendUpdate((BlockState)this.getBlockState().setValue((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void stopWork() {
        this.progress = 0;
        this.sendUpdate((BlockState)this.getBlockState().setValue((Property)MetalPressBlock.LIT, (Comparable)Boolean.valueOf(false)));
    }

    private void finishWork(PressingRecipe recipe, RegistryAccess registryAccess, ItemStack current) {
        ItemStack output = this.getWorkOutput(recipe, registryAccess);
        if (!current.isEmpty()) {
            current.grow(output.getCount());
        } else {
            this.setItem(1, output);
        }
        this.progress = 0;
        this.removeItem(0, 1);
    }

    private void sendUpdate(BlockState newState) {
        if (this.level == null) {
            return;
        }
        BlockState oldState = this.level.getBlockState(this.worldPosition);
        if (oldState != newState) {
            this.level.setBlock(this.worldPosition, newState, 3);
            this.level.sendBlockUpdated(this.worldPosition, oldState, newState, 3);
        }
    }

    public void setChanged() {
        this.progress = 0;
        super.setChanged();
    }

    protected Component getDefaultName() {
        return TextUtil.translate("container", "metal_press");
    }

    @Override
    public NonNullList<ItemStack> createInternalItemList() {
        return NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && this.getRecipe(stack) != null;
    }

    @Override
    public boolean canExtractItem(int slot) {
        return slot == 1;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return new MetalPressContainer(id, player, (Container)this, this.fields);
    }
}

