/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.salvager;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.SgContainerBlockEntity;
import net.silentchaos512.gear.block.salvager.SalvagerContainer;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgBlockEntities;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.util.MathUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class SalvagerBlockEntity
extends SgContainerBlockEntity {
    static final int BASE_WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private static final int INPUT_SLOT = 0;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = IntStream.rangeClosed(1, 18).toArray();
    private static final int[] SLOTS_ALL = IntStream.rangeClosed(0, 18).toArray();
    public static final int INVENTORY_SIZE = SLOTS_INPUT.length + SLOTS_OUTPUT.length;
    private final RecipeManager.CachedCheck<SingleRecipeInput, SalvagingRecipe> quickCheck;
    int progress = 0;
    private final ContainerData fields = new ContainerData(){

        public int get(int index) {
            return SalvagerBlockEntity.this.progress;
        }

        public void set(int index, int value) {
            SalvagerBlockEntity.this.progress = value;
        }

        public int getCount() {
            return 1;
        }
    };

    public SalvagerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SgBlockEntities.SALVAGER.get(), pos, state);
        this.quickCheck = RecipeManager.createCheck((RecipeType)((RecipeType)SgRecipes.SALVAGING_TYPE.get()));
    }

    @Override
    public NonNullList<ItemStack> createInternalItemList() {
        return NonNullList.withSize((int)INVENTORY_SIZE, (Object)ItemStack.EMPTY);
    }

    @Nullable
    private SalvagingRecipe getRecipe(ItemStack input) {
        Level level;
        if (this.level == null || input.isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RecipeHolder holder = this.quickCheck.getRecipeFor((RecipeInput)new SingleRecipeInput(this.getInputItem()), serverLevel).orElse(null);
        if (holder != null) {
            return (SalvagingRecipe)holder.value();
        }
        return null;
    }

    public ItemStack getInputItem() {
        return (ItemStack)this.items.get(0);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SalvagerBlockEntity blockEntity) {
        ItemStack input = blockEntity.getItem(0);
        SalvagingRecipe recipe = blockEntity.getRecipe(input);
        if (recipe != null) {
            if (blockEntity.progress < BASE_WORK_TIME) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= BASE_WORK_TIME && !blockEntity.isOutputFull()) {
                for (ItemStack stack : blockEntity.getSalvagedPartsWithChance(recipe, input)) {
                    int slot = blockEntity.getFreeOutputSlot();
                    if (slot > 0) {
                        blockEntity.setItem(slot, stack);
                        continue;
                    }
                    SilentGear.LOGGER.warn("Item lost in salvager: {}", (Object)stack);
                }
                blockEntity.progress = 0;
                input.shrink(1);
                if (input.isEmpty()) {
                    blockEntity.setItem(0, ItemStack.EMPTY);
                }
            }
        } else {
            blockEntity.progress = 0;
        }
    }

    private Collection<ItemStack> getSalvagedPartsWithChance(SalvagingRecipe recipe, ItemStack stack) {
        double lossRate = SalvagerBlockEntity.getLossRate(stack);
        SilentGear.LOGGER.debug("Loss rate for '{}': {}", (Object)stack, (Object)lossRate);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ItemStack part : recipe.getPossibleResults((Container)this)) {
            ItemStack copy = part.copy();
            int count = copy.getCount();
            PartInstance partData = PartInstance.from(part);
            double partLossRate = partData != null && partData.isValid() ? partData.get().getSalvageLossRate(partData, stack, lossRate) : lossRate;
            for (int i = 0; i < count; ++i) {
                if (!MathUtils.tryPercentage((Random)SilentGear.RANDOM, (double)partLossRate)) continue;
                copy.shrink(1);
            }
            if (copy.isEmpty()) continue;
            builder.add((Object)copy);
        }
        return builder.build();
    }

    private static double getLossRate(ItemStack stack) {
        int maxDamage = stack.getMaxDamage();
        double min = (Double)Config.Common.salvagerMinLossRate.get();
        if (maxDamage == 0) {
            return min;
        }
        double ratio = (double)stack.getDamageValue() / (double)maxDamage;
        return min + ratio * ((Double)Config.Common.salvagerMaxLossRate.get() - min);
    }

    private int getFreeOutputSlot() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.getItem(slot).isEmpty()) continue;
            return slot;
        }
        return -1;
    }

    private boolean isOutputFull() {
        for (int slot : SLOTS_OUTPUT) {
            if (!this.getItem(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tags = super.getUpdateTag(provider);
        tags.putInt("Progress", this.progress);
        return tags;
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack stack) {
        if (stack.isEmpty() || SalvagerBlockEntity.isOutputSlot(slot)) {
            return false;
        }
        ItemStack current = this.getItem(slot);
        if (!current.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)current)) {
            return false;
        }
        return SalvagerBlockEntity.isInputSlot(slot);
    }

    @Override
    public boolean canExtractItem(int slot) {
        return slot != 0;
    }

    private static boolean isInputSlot(int index) {
        for (int k : SLOTS_INPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    private static boolean isOutputSlot(int index) {
        for (int k : SLOTS_OUTPUT) {
            if (index != k) continue;
            return true;
        }
        return false;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.silentgear.salvager");
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new SalvagerContainer(id, playerInventory, (Container)this, this.fields);
    }

    public void setChanged() {
        this.progress = 0;
        super.setChanged();
    }
}

