/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import javax.annotation.Nonnull;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.silentchaos512.gear.network.payload.client.KeyPressOnItemPayload;

@EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
public class KeyTracker {
    public static final KeyMapping DISPLAY_PROPERTIES = KeyTracker.createKeyBinding("displayItemProperties", 341, KeyMapping.Category.INVENTORY);
    public static final KeyMapping DISPLAY_TRAITS = KeyTracker.createKeyBinding("displayTraitDescriptions", 340, KeyMapping.Category.INVENTORY);
    public static final KeyMapping DISPLAY_CONSTRUCTION = KeyTracker.createKeyBinding("displayItemConstruction", 342, KeyMapping.Category.INVENTORY);
    public static final KeyMapping OPEN_ITEM = KeyTracker.createKeyBinding("openItem", 88, KeyMapping.Category.INVENTORY);
    public static final KeyMapping CYCLE_BACK = KeyTracker.createKeyBinding("cycle.back", 90, KeyMapping.Category.INVENTORY);
    public static final KeyMapping CYCLE_NEXT = KeyTracker.createKeyBinding("cycle.next", 67, KeyMapping.Category.INVENTORY);
    private static int materialCycleCount = 0;

    @Nonnull
    private static KeyMapping createKeyBinding(String description, int key, KeyMapping.Category category) {
        return new KeyMapping("key.silentgear." + description, (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, key, category);
    }

    public static int getMaterialCycleIndex(int total) {
        int i = materialCycleCount % total;
        return i < 0 ? i + total : i;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        ItemStack hovered;
        if (event.getAction() == 0 && event.getKey() == DISPLAY_PROPERTIES.getKey().getValue()) {
            materialCycleCount = 0;
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_NEXT.getKey().getValue()) {
            if (KeyTracker.isDisplayPropertiesDown()) {
                ++materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).isEmpty()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new KeyPressOnItemPayload(KeyPressOnItemPayload.KeyPressType.CYCLE_NEXT, KeyTracker.getHoveredSlot()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (event.getAction() == 1 && event.getKey() == CYCLE_BACK.getKey().getValue()) {
            if (KeyTracker.isDisplayPropertiesDown()) {
                --materialCycleCount;
            }
            if (!(hovered = KeyTracker.getHoveredItem()).isEmpty()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new KeyPressOnItemPayload(KeyPressOnItemPayload.KeyPressType.CYCLE_BACK, KeyTracker.getHoveredSlot()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (event.getAction() == 1 && event.getKey() == OPEN_ITEM.getKey().getValue() && !(hovered = KeyTracker.getHoveredItem()).isEmpty()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new KeyPressOnItemPayload(KeyPressOnItemPayload.KeyPressType.OPEN_ITEM, KeyTracker.getHoveredSlot()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static ItemStack getHoveredItem() {
        AbstractContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.getItem();
        }
        return ItemStack.EMPTY;
    }

    private static int getHoveredSlot() {
        AbstractContainerScreen containerScreen;
        Slot slot;
        Screen currentScreen = Minecraft.getInstance().screen;
        if (currentScreen instanceof AbstractContainerScreen && (slot = (containerScreen = (AbstractContainerScreen)currentScreen).getSlotUnderMouse()) != null) {
            return slot.getContainerSlot();
        }
        return -1;
    }

    public static boolean isDisplayPropertiesDown() {
        int code = DISPLAY_PROPERTIES.getKey().getValue();
        if (code == 341 || code == 345) {
            return KeyTracker.isControlDown();
        }
        return KeyTracker.isKeyDown(code);
    }

    public static boolean isDisplayConstructionDown() {
        int code = DISPLAY_CONSTRUCTION.getKey().getValue();
        if (code == 342 || code == 346) {
            return KeyTracker.isAltDown();
        }
        return KeyTracker.isKeyDown(code);
    }

    public static boolean isDisplayTraitDescriptionsDown() {
        int code = DISPLAY_TRAITS.getKey().getValue();
        if (code == 340 || code == 344) {
            return KeyTracker.isShiftDown();
        }
        return DISPLAY_TRAITS.isDown();
    }

    public static boolean isShiftDown() {
        Window window = Minecraft.getInstance().getWindow();
        return InputConstants.isKeyDown((Window)window, (int)340) || InputConstants.isKeyDown((Window)window, (int)344);
    }

    public static boolean isControlDown() {
        Window window = Minecraft.getInstance().getWindow();
        return InputConstants.isKeyDown((Window)window, (int)341) || InputConstants.isKeyDown((Window)window, (int)345);
    }

    public static boolean isAltDown() {
        Window window = Minecraft.getInstance().getWindow();
        return InputConstants.isKeyDown((Window)window, (int)342) || InputConstants.isKeyDown((Window)window, (int)346);
    }

    public static boolean isKeyDown(int keycode) {
        if (keycode < 0) {
            return false;
        }
        Window window = Minecraft.getInstance().getWindow();
        return InputConstants.isKeyDown((Window)window, (int)keycode);
    }

    @EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
    static final class Registration {
        Registration() {
        }

        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(CYCLE_BACK);
            event.register(CYCLE_NEXT);
            event.register(DISPLAY_PROPERTIES);
            event.register(DISPLAY_TRAITS);
            event.register(DISPLAY_CONSTRUCTION);
            event.register(OPEN_ITEM);
        }
    }
}

