/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.color.item;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import org.jetbrains.annotations.Nullable;

public record MaterialColor() implements ItemTintSource
{
    public static final MaterialColor INSTANCE = new MaterialColor();
    public static final MapCodec<MaterialColor> CODEC = MapCodec.unit(() -> INSTANCE);

    public int calculate(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity) {
        if (stack.has(SgDataComponents.MATERIAL_SINGLE)) {
            MaterialInstance material = (MaterialInstance)stack.get(SgDataComponents.MATERIAL_SINGLE);
            assert (material != null);
            return material.getColor((GearType)GearTypes.ALL.get(), (PartType)PartTypes.MAIN.get()) | 0xFF000000;
        }
        if (stack.has(SgDataComponents.MATERIAL_LIST)) {
            List materials = (List)stack.get(SgDataComponents.MATERIAL_LIST);
            assert (materials != null);
            return ColorUtils.getBlendedColorForCompoundMaterial(materials);
        }
        return -1;
    }

    public MapCodec<? extends ItemTintSource> type() {
        return CODEC;
    }
}

