/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.block.stoneanvil.StoneAnvilBlock;
import net.silentchaos512.gear.block.stoneanvil.StoneAnvilBlockEntity;
import net.silentchaos512.gear.client.renderer.blockentity.state.StoneAnvilRenderState;
import org.joml.Quaternionfc;

public class StoneAnvilRenderer
implements BlockEntityRenderer<StoneAnvilBlockEntity, StoneAnvilRenderState> {
    private final ItemModelResolver itemModelResolver;

    public StoneAnvilRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public StoneAnvilRenderState createRenderState() {
        return new StoneAnvilRenderState();
    }

    public void extractRenderState(StoneAnvilBlockEntity blockEntity, StoneAnvilRenderState renderState, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.facing = (Direction)blockEntity.getBlockState().getValue(StoneAnvilBlock.FACING);
        int seed = (int)blockEntity.getBlockPos().asLong();
        ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
        this.itemModelResolver.updateForTopItem(itemStackRenderState, blockEntity.getItem(), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, seed);
        renderState.item = itemStackRenderState;
    }

    public void submit(StoneAnvilRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        Direction direction = renderState.facing;
        ItemStackRenderState itemStackRenderState = renderState.item;
        if (!itemStackRenderState.isEmpty()) {
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.9375f, 0.5f);
            Direction direction1 = Direction.from2DDataValue((int)(direction.get2DDataValue() % 4));
            float f = -direction1.toYRot();
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f));
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            poseStack.scale(0.5f, 0.5f, 0.5f);
            itemStackRenderState.submit(poseStack, nodeCollector, renderState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

