/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ArrowRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.client.renderer.entity.state.GearArrowRenderState;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;

public class GearArrowRenderer
extends ArrowRenderer<GearArrowEntity, GearArrowRenderState> {
    public static final Identifier GEAR_ARROW_LOCATION = SilentGear.getId("textures/entity/arrow.png");

    public GearArrowRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public GearArrowRenderState createRenderState() {
        return new GearArrowRenderState();
    }

    public void extractRenderState(GearArrowEntity entity, GearArrowRenderState reusedState, float partialTick) {
        super.extractRenderState((AbstractArrow)entity, (ArrowRenderState)reusedState, partialTick);
        reusedState.rodColor = entity.getRodColor();
        reusedState.tipColor = entity.getTipColor();
        reusedState.fletchingColor = entity.getFletchingColor();
    }

    protected Identifier getTextureLocation(GearArrowRenderState renderState) {
        return GEAR_ARROW_LOCATION;
    }

    public void vertex(PoseStack.Pose pose, VertexConsumer consumer, float x, float y, float z, float u, float v, int normalX, int normalY, int normalZ, int packedLight, int color) {
        consumer.addVertex(pose, x, y, z).setColor(color).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, (float)normalX, (float)normalZ, (float)normalY);
    }
}

