/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.tooltips;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyGroups;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.GearTooltipFlag;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

@EventBusSubscriber
public class GearItemTooltips {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        if (!(item instanceof GearItem)) {
            return;
        }
        GearItem item2 = (GearItem)item;
        GearTooltipFlag flag = event.getFlags() instanceof GearTooltipFlag ? (GearTooltipFlag)event.getFlags() : GearTooltipFlag.withModifierKeys(event.getFlags().isAdvanced(), true, true);
        ArrayList<Component> newLines = new ArrayList<Component>();
        if (GearHelper.isBroken(stack)) {
            newLines.add((Component)TextUtil.withColor(GearItemTooltips.misc("broken", new Object[0]), Color.FIREBRICK));
        }
        if (GearData.isExampleGear(stack)) {
            newLines.add((Component)TextUtil.withColor(GearItemTooltips.misc("exampleOutput1", new Object[0]), Color.YELLOW));
            newLines.add((Component)TextUtil.withColor(GearItemTooltips.misc("exampleOutput2", new Object[0]), Color.YELLOW));
        }
        PartList constructionParts = GearData.getConstruction(stack).parts();
        List<PartInstance> sortedConstructionParts = constructionParts.toSortedList();
        if (constructionParts.getMains().isEmpty()) {
            newLines.add((Component)TextUtil.withColor(GearItemTooltips.misc("invalidParts", new Object[0]), Color.FIREBRICK));
        }
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            for (PartInstance part : sortedConstructionParts) {
                part.addInformation(stack, newLines, flag);
            }
        }
        if (!((Boolean)Config.Client.vanillaStyleTooltips.get()).booleanValue()) {
            GearItemTooltips.addPropertiesInfo(stack, newLines, flag, item2);
        }
        if (KeyTracker.isDisplayConstructionDown() && flag.showConstruction()) {
            newLines.add((Component)TextUtil.withColor(GearItemTooltips.misc("tooltip.construction", new Object[0]), Color.GOLD));
            GearItemTooltips.tooltipListParts(stack, newLines, sortedConstructionParts, flag);
        } else if (flag.showConstruction()) {
            newLines.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.construction", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_CONSTRUCTION), ChatFormatting.GRAY))));
        }
        event.getToolTip().addAll(Math.min(1, event.getToolTip().size()), newLines);
    }

    private static MutableComponent misc(String key, Object ... formatArgs) {
        return Component.translatable((String)("misc.silentgear." + key), (Object[])formatArgs);
    }

    public static void addPropertiesInfo(ItemStack stack, List<Component> tooltip, GearTooltipFlag flag, GearItem item) {
        if (KeyTracker.isDisplayPropertiesDown() && flag.showProperties()) {
            tooltip.add((Component)TextUtil.withColor(GearItemTooltips.misc("tooltip.properties", new Object[0]), Color.GOLD));
            TextListBuilder builder = new TextListBuilder();
            GearPropertiesData gearProperties = GearData.getProperties(stack);
            for (GearProperty<?, ?> property : GearItemTooltips.getDisplayProperties(stack, flag)) {
                Object value = gearProperties.get(property);
                if (value == null || property.isHiddenUnchecked((GearPropertyValue<?>)value, flag)) continue;
                property.buildTooltipUnchecked(builder, (GearPropertyValue<?>)value, stack, flag);
            }
            tooltip.addAll(builder.build());
        } else if (flag.showProperties()) {
            tooltip.add((Component)TextUtil.withColor(TextUtil.misc("tooltip.properties", new Object[0]), Color.GOLD).append((Component)Component.literal((String)" ").append((Component)TextUtil.withColor(TextUtil.keyBinding(KeyTracker.DISPLAY_PROPERTIES), ChatFormatting.GRAY))));
        }
    }

    private static Iterable<GearProperty<?, ?>> getDisplayProperties(ItemStack stack, GearTooltipFlag flag) {
        if (flag.isAdvanced() && SilentGear.isDevBuild()) {
            return SgRegistries.GEAR_PROPERTY;
        }
        return GearPropertyGroups.getSortedRelevantProperties(GearHelper.getType(stack).relevantPropertyGroups());
    }

    public static void tooltipListParts(ItemStack gear, List<Component> tooltip, Collection<PartInstance> parts, GearTooltipFlag flag) {
        TextListBuilder builder = new TextListBuilder();
        for (PartInstance part : parts) {
            if (!part.isValid() || !part.get().isVisible()) continue;
            int partNameColor = Color.blend((int)part.getColor(gear), (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
            MutableComponent partNameText = TextUtil.withColor(part.getDisplayName().copy(), partNameColor);
            builder.add((Component)(flag.isAdvanced() ? partNameText.append((Component)TextUtil.misc("spaceBrackets", part.getType().getDisplayName()).withStyle(ChatFormatting.DARK_GRAY)) : partNameText));
            if (!(part.get() instanceof CoreGearPart)) continue;
            builder.indent();
            for (MaterialInstance material : CompoundPartItem.getMaterials(part.getItem())) {
                int nameColor = material.getNameColor(part.getType(), (GearType)GearTypes.ALL.get());
                builder.add((Component)TextUtil.withColor(material.getDisplayNameWithModifiers(part.getType(), ItemStack.EMPTY), nameColor));
            }
            builder.unindent();
        }
        tooltip.addAll(builder.build());
    }
}

