/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.GearData;

public final class PartsCommand {
    private static final SuggestionProvider<CommandSourceStack> partIdSuggestions = (ctx, builder) -> SharedSuggestionProvider.suggestResource(SgRegistries.PART.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> partInGearSuggestions = (ctx, builder) -> {
        PartList parts = GearData.getConstruction(PartsCommand.getGear((CommandContext<CommandSourceStack>)ctx)).parts();
        return SharedSuggestionProvider.suggestResource(parts.stream().map(PartInstance::getId), (SuggestionsBuilder)builder);
    };
    private static final Pattern FORMAT_CODES = Pattern.compile("\u00a7[0-9a-z]");

    private PartsCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.literal((String)"sgear_parts");
        builder.then(Commands.literal((String)"list").executes(PartsCommand::runList));
        builder.then(Commands.literal((String)"dump").executes(PartsCommand::runDump));
        dispatcher.register(builder);
    }

    private static int runList(CommandContext<CommandSourceStack> context) {
        String listStr = SgRegistries.PART.keySet().stream().map(Identifier::toString).collect(Collectors.joining(", "));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)listStr), true);
        for (PartType type : SgRegistries.PART_TYPE) {
            int count = SgRegistries.PART.getPartsOfType(type).size();
            String str = String.format("%s: %d", SgRegistries.PART_TYPE.getKey((Object)type), count);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)str), true);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runDump(CommandContext<CommandSourceStack> context) {
        String dirPath = "output/silentgear";
        String fileName = "part_export.tsv";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Could not create directory: " + output.getParent())));
            return 0;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            StringBuilder builder = new StringBuilder("Name\tID\tType\t");
            SgRegistries.GEAR_PROPERTY.forEach(prop -> builder.append(prop.getDisplayName().getString()).append("\t"));
            writer.write(builder.toString());
            for (GearPart part : SgRegistries.PART) {
                writer.write(PartsCommand.partToTsvLine(part) + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Wrote to " + output.getAbsolutePath())), true);
        }
        return 1;
    }

    private static String partToTsvLine(GearPart part) {
        StringBuilder builder = new StringBuilder();
        PartInstance partData = PartInstance.of(part);
        PartsCommand.appendTsv(builder, part.getDisplayName(partData, part.getType()).getString());
        PartsCommand.appendTsv(builder, SgRegistries.PART.getKey(part).toString());
        PartsCommand.appendTsv(builder, SgRegistries.PART_TYPE.getKey((Object)part.getType()));
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            Collection mods = part.getPropertyModifiers(PartInstance.of(part), part.getType(), PropertyKey.of(property, (GearType)GearTypes.ALL.get()));
            Component formattedText = GearPropertyMap.formatTextUnchecked(mods, property, false);
            PartsCommand.appendTsv(builder, FORMAT_CODES.matcher(formattedText.getString()).replaceAll(""));
        }
        return builder.toString();
    }

    private static void appendTsv(StringBuilder builder, Object value) {
        builder.append(value).append("\t");
    }

    private static ItemStack getGear(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (((CommandSourceStack)ctx.getSource()).getEntity() instanceof ServerPlayer) {
            ItemStack gear = ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getMainHandItem();
            if (gear.getItem() instanceof GearItem) {
                return gear;
            }
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure(PartsCommand.text("sourceMustBePlayer", new Object[0]));
        }
        return ItemStack.EMPTY;
    }

    private static Component text(String key, Object ... args) {
        return Component.translatable((String)("command.silentgear.parts." + key), (Object[])args);
    }
}

