/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;

public final class SetDamageCommand {
    private SetDamageCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"set_damage").requires((Predicate)Commands.hasPermission((PermissionCheck)Commands.LEVEL_GAMEMASTERS))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SetDamageCommand.run((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"))))).then(Commands.literal((String)"max").executes(context -> SetDamageCommand.run((CommandContext<CommandSourceStack>)context, -1))));
    }

    private static int run(CommandContext<CommandSourceStack> context, int amount) throws CommandSyntaxException {
        ServerPlayer playerMP = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ItemStack stack = playerMP.getMainHandItem();
        if (stack.isDamageableItem()) {
            int correctedAmount = amount < 0 ? SetDamageCommand.getMaxDamage(stack) : amount;
            int clamped = Mth.clamp((int)correctedAmount, (int)0, (int)SetDamageCommand.getMaxDamage(stack));
            stack.setDamageValue(clamped);
            if (stack.getItem() instanceof GearItem) {
                GearData.recalculateGearData(stack, (Player)playerMP);
            }
            return 1;
        }
        MutableComponent msg = TextUtil.translate("command", "set_damage.notDamageable", stack.getHoverName());
        ((CommandSourceStack)context.getSource()).sendFailure((Component)msg);
        return 0;
    }

    private static int getMaxDamage(ItemStack stack) {
        if (GearHelper.isGear(stack)) {
            return stack.getMaxDamage() - 1;
        }
        return stack.getMaxDamage();
    }
}

