/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.curios;

import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TraitHelper;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.CuriosSlotTypes;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.common.DropRule;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioGearItemCapability {
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new GearCurio((ItemStack)stack, multimap -> {}), new ItemLike[]{GearItemSets.BRACELET.gearItem(), GearItemSets.RING.gearItem(), GearItemSets.NECKLACE.gearItem()});
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new GearCurio((ItemStack)stack, builder -> {}, (ItemStack)stack){
            final /* synthetic */ ItemStack val$stack;
            {
                this.val$stack = itemStack;
                super(stack, extraAttributes);
            }

            @Override
            public void curioTick(SlotContext context) {
                if (context.entity().level().isClientSide() || !CurioGearItemCapability.canGlideWith(this.val$stack)) {
                    return;
                }
                int ticksFlying = context.entity().getFallFlyingTicks();
                if ((ticksFlying + 1) % 20 == 0) {
                    this.val$stack.hurtAndBreak(1, context.entity(), EquipmentSlot.BODY);
                }
            }
        }, new ItemLike[]{GearItemSets.ELYTRA.gearItem()});
    }

    private static boolean canGlideWith(ItemStack stack) {
        return stack.has(DataComponents.GLIDER) && stack.has(DataComponents.EQUIPPABLE) && !stack.nextDamageWillBreak();
    }

    public static class GearCurio
    implements ICurio {
        private final ItemStack stack;
        private final Consumer<ItemAttributeModifiers.Builder> extraAttributes;

        private GearCurio() {
            this(ItemStack.EMPTY, multimap -> {});
        }

        private GearCurio(ItemStack stack, Consumer<ItemAttributeModifiers.Builder> extraAttributes) {
            this.stack = stack;
            this.extraAttributes = extraAttributes;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            Level level = slotContext.entity().level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                GearHelper.inventoryTick(this.stack, serverLevel, (Entity)slotContext.entity(), true);
            }
        }

        public CurioAttributeModifiers getDefaultCurioAttributeModifiers() {
            Map slots = CuriosSlotTypes.getItemSlotTypes((ItemStack)this.getStack(), (boolean)true);
            CurioAttributeModifiers.Builder builder = CurioAttributeModifiers.builder();
            for (String slot : slots.keySet()) {
                TraitHelper.addAttributeModifiersFromTraits(this.stack, (attribute, modifier) -> builder.addModifier(attribute, modifier, new String[]{slot}));
            }
            return builder.build();
        }

        public boolean makesPiglinsNeutral(SlotContext slotContext) {
            return TraitHelper.hasTrait(this.stack, Const.Traits.BRILLIANT);
        }

        public int getFortuneLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
            return 0;
        }

        public int getLootingLevel(SlotContext slotContext, @Nullable LootContext lootContext) {
            return 0;
        }

        @NotNull
        public DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit) {
            return DropRule.ALWAYS_KEEP;
        }

        public boolean canEquipFromUse(SlotContext slotContext) {
            return true;
        }

        @Nonnull
        public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
            return new ICurio.SoundInfo((SoundEvent)SoundEvents.ARMOR_EQUIP_GOLD.value(), 1.0f, 1.0f);
        }
    }
}

