/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerInfo;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.IngredientUtils;
import net.silentchaos512.gear.util.TextUtil;

public class AlloyMakingRecipeCategory
implements IRecipeCategory<AlloyRecipe> {
    public static final Identifier TEXTURE = SilentGear.getId("textures/gui/alloy_maker.png");
    private static final int GUI_START_X = 15;
    private static final int GUI_START_Y = 29;
    private static final int GUI_WIDTH = 132;
    private static final int GUI_HEIGHT = 27;
    private final AlloyMakerInfo<?> info;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final Component localizedName;

    public AlloyMakingRecipeCategory(AlloyMakerInfo<?> info, String categoryName, IGuiHelper guiHelper) {
        this.info = info;
        this.background = guiHelper.createDrawable(TEXTURE, 15, 29, 132, 27);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(info.getBlock()));
        this.arrow = guiHelper.drawableBuilder(TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "group.alloy_making." + categoryName);
    }

    public int getWidth() {
        return 132;
    }

    public int getHeight() {
        return 27;
    }

    public IRecipeType<AlloyRecipe> getRecipeType() {
        if (this.info == Const.FABRIC_ALLOY_MAKER_INFO) {
            return SGearJeiPlugin.ALLOY_MAKING_FABRIC_TYPE;
        }
        if (this.info == Const.GEM_ALLOY_MAKER_INFO) {
            return SGearJeiPlugin.ALLOY_MAKING_GEM_TYPE;
        }
        if (this.info == Const.METAL_ALLOY_MAKER_INFO) {
            return SGearJeiPlugin.ALLOY_MAKING_METAL_TYPE;
        }
        if (this.info == Const.SUPER_MIXER_INFO) {
            return SGearJeiPlugin.ALLOY_MAKING_SUPER_TYPE;
        }
        throw new IllegalStateException("Unknown JEI recipe type: " + String.valueOf(this.info.getRecipeType()));
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AlloyRecipe recipe, IFocusGroup focuses) {
        List ingredients = recipe.placementInfo().ingredients();
        for (int i = 0; i < this.info.getInputSlotCount() && i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            List<ItemStack> items = IngredientUtils.getValidItems(ingredient);
            builder.addSlot(RecipeIngredientRole.INPUT, 18 * i + 17 - 15, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, AlloyMakingRecipeCategory.shiftIngredients(items, 3 * i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 111, 6).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(recipe.getResultForRecipeDisplay()));
    }

    private static List<ItemStack> shiftIngredients(List<ItemStack> list, int amount) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>(list);
        if (ret.isEmpty()) {
            return ret;
        }
        for (int i = 0; i < amount; ++i) {
            ItemStack stack = (ItemStack)ret.get(ret.size() - 1);
            ret.remove(ret.size() - 1);
            ret.add(0, stack);
        }
        return ret;
    }

    public void draw(AlloyRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 78, 5);
    }
}

