/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.util.GearComponent;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.compat.jei.SGearJeiPlugin;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.util.IngredientUtils;
import net.silentchaos512.gear.util.TextUtil;

public class MaterialGraderRecipeCategory
implements IRecipeCategory<GraderRecipe> {
    private static final int GUI_START_X = 24;
    private static final int GUI_START_Y = 33;
    private static final int GUI_WIDTH = 19;
    private static final int GUI_HEIGHT = 39;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public MaterialGraderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GraderScreen.TEXTURE, 24, 33, 19, 39);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(SgBlocks.MATERIAL_GRADER));
        this.localizedName = TextUtil.translate("jei", "group.grading");
    }

    public int getWidth() {
        return 19;
    }

    public int getHeight() {
        return 39;
    }

    public IRecipeType<GraderRecipe> getRecipeType() {
        return SGearJeiPlugin.GRADING_TYPE;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GraderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, MaterialGraderRecipeCategory.getMaterials());
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 22).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, MaterialGraderRecipeCategory.getCatalysts());
    }

    @Nonnull
    public static List<ItemStack> getMaterials() {
        return SgRegistries.MATERIAL.getValues(true).stream().map(GearComponent::getIngredient).flatMap(ing -> IngredientUtils.getValidItems(ing).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(stack -> stack.is(SgTags.Items.GRADER_CATALYSTS)).collect(Collectors.toList());
    }

    public void draw(GraderRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
    }

    public static class GraderRecipe {
    }
}

