/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IIngredientAliasRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.alloymaker.screen.AlloyForgeScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RecrystallizerScreen;
import net.silentchaos512.gear.block.alloymaker.screen.RefabricatorScreen;
import net.silentchaos512.gear.block.alloymaker.screen.SuperMixerScreen;
import net.silentchaos512.gear.block.grader.GraderScreen;
import net.silentchaos512.gear.block.salvager.SalvagerScreen;
import net.silentchaos512.gear.client.ClientRecipeHelper;
import net.silentchaos512.gear.compat.jei.AlloyMakingRecipeCategory;
import net.silentchaos512.gear.compat.jei.GearCraftingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.MaterialGraderRecipeCategory;
import net.silentchaos512.gear.compat.jei.SalvagingRecipeCategoryJei;
import net.silentchaos512.gear.compat.jei.ToolActionRecipeCategory;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.ToolActionRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.FabricAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.GemAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.MetalAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.SuperAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.IngredientUtils;
import net.silentchaos512.lib.crafting.recipe.CraftingRecipeExtension;
import net.silentchaos512.lib.util.NameUtils;

@JeiPlugin
public class SGearJeiPlugin
implements IModPlugin {
    private static final Identifier PLUGIN_UID = SilentGear.getId("plugin/main");
    public static final IRecipeType<AlloyRecipe> ALLOY_MAKING_FABRIC_TYPE = IRecipeType.create((String)"silentgear", (String)"alloy_making/fabric", AlloyRecipe.class);
    public static final IRecipeType<AlloyRecipe> ALLOY_MAKING_GEM_TYPE = IRecipeType.create((String)"silentgear", (String)"alloy_making/gem", AlloyRecipe.class);
    public static final IRecipeType<AlloyRecipe> ALLOY_MAKING_METAL_TYPE = IRecipeType.create((String)"silentgear", (String)"alloy_making/metal", AlloyRecipe.class);
    public static final IRecipeType<AlloyRecipe> ALLOY_MAKING_SUPER_TYPE = IRecipeType.create((String)"silentgear", (String)"alloy_making/super", AlloyRecipe.class);
    static final IRecipeType<CraftingRecipeExtension> GEAR_CRAFTING_TYPE = IRecipeType.create((String)"silentgear", (String)"gear_crafting", CraftingRecipeExtension.class);
    static final IRecipeType<MaterialGraderRecipeCategory.GraderRecipe> GRADING_TYPE = IRecipeType.create((String)"silentgear", (String)"grading", MaterialGraderRecipeCategory.GraderRecipe.class);
    static final IRecipeType<SalvagingRecipe> SALVAGING_TYPE = IRecipeType.create((String)"silentgear", (String)"salvaging", SalvagingRecipe.class);
    static final IRecipeType<ToolActionRecipe> TOOL_ACTION_TYPE = IRecipeType.create((String)"silentgear", (String)"tool_action", ToolActionRecipe.class);

    public Identifier getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        IGuiHelper guiHelper = reg.getJeiHelpers().getGuiHelper();
        reg.addRecipeCategories(new IRecipeCategory[]{new GearCraftingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.FABRIC_ALLOY_MAKER_INFO, "fabric", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.GEM_ALLOY_MAKER_INFO, "gem", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.METAL_ALLOY_MAKER_INFO, "metal", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new AlloyMakingRecipeCategory(Const.SUPER_MIXER_INFO, "super", guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new MaterialGraderRecipeCategory(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new SalvagingRecipeCategoryJei(guiHelper)});
        reg.addRecipeCategories(new IRecipeCategory[]{new ToolActionRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        for (RepairKitItem repairKitItem : SgItems.getItems(RepairKitItem.class)) {
            String itemName = NameUtils.fromItem((ItemLike)repairKitItem).getPath();
            reg.addRecipes((IRecipeType)RecipeTypes.CRAFTING, Collections.singletonList(new RecipeHolder(ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SilentGear.getId(itemName)), (Recipe)new ShapelessRecipe("", CraftingBookCategory.MISC, new ItemStack((ItemLike)repairKitItem), List.of(Ingredient.of((ItemLike)repairKitItem), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get())), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get())), new Ingredient((ICustomIngredient)PartMaterialIngredient.of((PartType)PartTypes.MAIN.get())))))));
        }
        reg.addRecipes(GEAR_CRAFTING_TYPE, SGearJeiPlugin.getRecipes(RecipeType.CRAFTING, CraftingRecipeExtension.class));
        reg.addRecipes(TOOL_ACTION_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.TOOL_ACTION_TYPE.get(), ToolActionRecipe.class));
        reg.addRecipes(ALLOY_MAKING_FABRIC_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.ALLOY_MAKING_FABRIC_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_GEM_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.ALLOY_MAKING_GEM_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_METAL_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.ALLOY_MAKING_METAL_TYPE.get(), AlloyRecipe.class));
        reg.addRecipes(ALLOY_MAKING_SUPER_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.ALLOY_MAKING_SUPER_TYPE.get(), AlloyRecipe.class));
        for (int i = 2; i <= 4; ++i) {
            reg.addRecipes(ALLOY_MAKING_FABRIC_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.FABRIC_ALLOY_MAKER_INFO, i, FabricAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_GEM_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.GEM_ALLOY_MAKER_INFO, i, GemAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_METAL_TYPE, Collections.singletonList(AlloyRecipe.makeExample(Const.METAL_ALLOY_MAKER_INFO, i, MetalAlloyRecipe::new)));
            reg.addRecipes(ALLOY_MAKING_SUPER_TYPE, List.of(AlloyRecipe.makeExample(Const.SUPER_MIXER_INFO, i, SuperAlloyRecipe::new)));
        }
        reg.addRecipes(GRADING_TYPE, Collections.singletonList(new MaterialGraderRecipeCategory.GraderRecipe()));
        reg.addRecipes(SALVAGING_TYPE, SGearJeiPlugin.getRecipes((RecipeType)SgRecipes.SALVAGING_TYPE.get(), SalvagingRecipe.class));
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.RED_CARD_UPGRADE);
        SGearJeiPlugin.addInfoPage(reg, CraftingItems.SPOON_UPGRADE);
        for (Item item2 : SgItems.getItems(item -> item instanceof GearTool)) {
            SGearJeiPlugin.addInfoPage(reg, (ItemLike)item2);
        }
    }

    private static <R extends Recipe<?>> List<R> getRecipes(RecipeType<?> recipeType, Class<R> recipeClass) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (RecipeHolder<?> recipe : ClientRecipeHelper.getRecipes(recipeType)) {
            listBuilder.add((Object)((Recipe)recipeClass.cast(recipe.value())));
        }
        return listBuilder.build();
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addCraftingStation(GEAR_CRAFTING_TYPE, new ItemLike[]{Blocks.CRAFTING_TABLE});
        reg.addCraftingStation(ALLOY_MAKING_FABRIC_TYPE, new ItemLike[]{SgBlocks.REFABRICATOR});
        reg.addCraftingStation(ALLOY_MAKING_GEM_TYPE, new ItemLike[]{SgBlocks.RECRYSTALLIZER});
        reg.addCraftingStation(ALLOY_MAKING_METAL_TYPE, new ItemLike[]{SgBlocks.ALLOY_FORGE});
        reg.addCraftingStation(ALLOY_MAKING_SUPER_TYPE, new ItemLike[]{SgBlocks.SUPER_MIXER});
        reg.addCraftingStation(GRADING_TYPE, new ItemLike[]{SgBlocks.MATERIAL_GRADER});
        reg.addCraftingStation(SALVAGING_TYPE, new ItemLike[]{SgBlocks.SALVAGER});
        reg.addCraftingStation(TOOL_ACTION_TYPE, new ItemLike[]{SgBlocks.STONE_ANVIL});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration reg) {
        reg.addRecipeClickArea(RefabricatorScreen.class, 90, 30, 28, 23, new IRecipeType[]{ALLOY_MAKING_FABRIC_TYPE});
        reg.addRecipeClickArea(RecrystallizerScreen.class, 90, 30, 28, 23, new IRecipeType[]{ALLOY_MAKING_GEM_TYPE});
        reg.addRecipeClickArea(AlloyForgeScreen.class, 90, 30, 28, 23, new IRecipeType[]{ALLOY_MAKING_METAL_TYPE});
        reg.addRecipeClickArea(SuperMixerScreen.class, 90, 30, 28, 23, new IRecipeType[]{ALLOY_MAKING_SUPER_TYPE});
        reg.addRecipeClickArea(GraderScreen.class, 48, 30, 28, 23, new IRecipeType[]{GRADING_TYPE});
        reg.addRecipeClickArea(SalvagerScreen.class, 30, 30, 28, 23, new IRecipeType[]{SALVAGING_TYPE});
    }

    public void registerItemSubtypes(ISubtypeRegistration reg) {
        ISubtypeInterpreter customMaterials = (ingredient, context) -> CustomMaterialItem.getMaterial(ingredient);
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_GEM.get(), customMaterials);
        reg.registerSubtypeInterpreter((Item)SgItems.CUSTOM_INGOT.get(), customMaterials);
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        ItemStack stack = new ItemStack(item);
        reg.addIngredientInfo((Object)stack, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, String name, Collection<ItemLike> items) {
        String key = SGearJeiPlugin.getDescKey(SilentGear.getId(name));
        List stacks = items.stream().map(ItemStack::new).collect(Collectors.toList());
        reg.addIngredientInfo(stacks, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static void addInfoPage(IRecipeRegistration reg, ItemLike item, Stream<ItemStack> variants) {
        String key = SGearJeiPlugin.getDescKey(NameUtils.fromItem((ItemLike)item));
        reg.addIngredientInfo(variants.collect(Collectors.toList()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)key)});
    }

    private static String getDescKey(Identifier name) {
        return "jei." + name.getNamespace() + "." + name.getPath() + ".desc";
    }

    public void registerIngredientAliases(IIngredientAliasRegistration registration) {
        for (Material material : SgRegistries.MATERIAL.getValues(true)) {
            List<ItemStack> itemStacks = IngredientUtils.getItemList(material.getIngredient());
            ArrayList<String> aliases = new ArrayList<String>(List.of("materials"));
            for (IMaterialCategory category : material.getCategories(MaterialInstance.of(material))) {
                aliases.add("materials/" + category.getName());
            }
            registration.addAliases((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks, aliases);
        }
    }
}

