/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.setup.SgIngredientTypes;

public final class GearTypeIngredient
implements ICustomIngredient {
    public static final MapCodec<GearTypeIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GearType.CODEC.fieldOf("gear_type").forGetter(GearTypeIngredient::getGearType)).apply((Applicative)instance, GearTypeIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GearTypeIngredient> STREAM_CODEC = StreamCodec.composite(GearType.STREAM_CODEC, ingredient -> ingredient.type, GearTypeIngredient::new);
    private final GearType type;

    public GearTypeIngredient(GearType type) {
        this.type = type;
    }

    public static GearTypeIngredient of(GearType type) {
        return new GearTypeIngredient(type);
    }

    public IngredientType<?> getType() {
        return (IngredientType)SgIngredientTypes.GEAR_TYPE.get();
    }

    private GearType getGearType() {
        return this.type;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        return stack.getItem() instanceof GearItem && ((GearItem)stack.getItem()).getGearType().matches(this.type);
    }

    public Stream<Holder<Item>> items() {
        return BuiltInRegistries.ITEM.stream().filter(item -> {
            GearItem gearItem;
            return item instanceof GearItem && (gearItem = (GearItem)item).getGearType().equals(this.type);
        }).map(Holder::direct);
    }

    public boolean isSimple() {
        return false;
    }
}

