/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.silentchaos512.gear.setup.SgIngredientTypes;

public class OptionalTagIngredient
implements ICustomIngredient {
    public static final MapCodec<OptionalTagIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.xmap(str -> {
        String trim = str.replace("#", "");
        Identifier location = Identifier.parse((String)trim);
        return TagKey.create((ResourceKey)Registries.ITEM, (Identifier)location);
    }, tag -> "#" + String.valueOf(tag.location())).fieldOf("tag").forGetter(ing -> ing.tag)).apply((Applicative)instance, tag -> new OptionalTagIngredient((HolderGetter<Item>)VanillaRegistries.createLookup().lookupOrThrow(Registries.ITEM), (TagKey<Item>)tag)));
    public static final StreamCodec<RegistryFriendlyByteBuf, OptionalTagIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)TagKey.streamCodec((ResourceKey)Registries.ITEM), ing -> ing.tag, tag -> new OptionalTagIngredient((HolderGetter<Item>)VanillaRegistries.createLookup().lookupOrThrow(Registries.ITEM), (TagKey<Item>)tag));
    private final TagKey<Item> tag;
    private final HolderSet<Item> values;

    public OptionalTagIngredient(HolderGetter<Item> items, TagKey<Item> tag) {
        this.tag = tag;
        HolderSet.Named tagContents = items.getOrThrow(this.tag);
        HolderSet valuesToSet = HolderSet.empty();
        try {
            if (tagContents.size() > 0) {
                valuesToSet = tagContents;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.values = valuesToSet;
    }

    public static Ingredient create(HolderGetter<Item> items, TagKey<Item> tag) {
        return new OptionalTagIngredient(items, tag).toVanilla();
    }

    public boolean test(ItemStack stack) {
        return stack.is(this.tag);
    }

    public Stream<Holder<Item>> items() {
        return this.values.stream();
    }

    public boolean isSimple() {
        return true;
    }

    public IngredientType<?> getType() {
        return (IngredientType)SgIngredientTypes.OPTIONAL_TAG.get();
    }
}

