/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.ingredient;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.display.DisplayContentsFactory;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.crafting.ingredient.IGearIngredient;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgIngredientTypes;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.util.CodecUtils;
import net.silentchaos512.gear.util.IngredientUtils;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.Color;

public final class PartMaterialIngredient
implements ICustomIngredient,
IGearIngredient {
    public static final MapCodec<PartMaterialIngredient> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PartType.CODEC.fieldOf("part_type").forGetter(PartMaterialIngredient::getPartType), (App)GearType.CODEC.optionalFieldOf("gear_type").forGetter(ing -> Optional.of(ing.gearType)), (App)MaterialGrade.CODEC.optionalFieldOf("min_grade", (Object)MaterialGrade.NONE).forGetter(ing -> ing.minGrade), (App)MaterialGrade.CODEC.optionalFieldOf("max_grade", (Object)MaterialGrade.NONE).forGetter(ing -> ing.maxGrade), (App)DataResource.MATERIAL_CODEC.optionalFieldOf("material").forGetter(ing -> Optional.ofNullable(ing.material)), (App)MaterialCategories.CODEC.listOf().optionalFieldOf("categories", Collections.emptyList()).forGetter(ing -> ImmutableList.copyOf(ing.categories)), (App)MaterialCategories.CODEC.listOf().optionalFieldOf("not_categories", Collections.emptyList()).forGetter(ing -> ImmutableList.copyOf(ing.notCategories))).apply((Applicative)instance, (pt, gt, minGrade, maxGrade, material, categories, notCategories) -> new PartMaterialIngredient((PartType)pt, gt.orElse((GearType)GearTypes.NONE.get()), (MaterialGrade)((Object)((Object)minGrade)), (MaterialGrade)((Object)((Object)maxGrade)), material.orElse(null), (Collection<IMaterialCategory>)categories, (Collection<IMaterialCategory>)notCategories)));
    public static final StreamCodec<RegistryFriendlyByteBuf, PartMaterialIngredient> STREAM_CODEC = StreamCodec.of((buf, ing) -> {
        PartType.STREAM_CODEC.encode(buf, (Object)ing.partType);
        GearType.STREAM_CODEC.encode(buf, (Object)ing.gearType);
        MaterialGrade.STREAM_CODEC.encode(buf, (Object)ing.minGrade);
        MaterialGrade.STREAM_CODEC.encode(buf, (Object)ing.maxGrade);
        buf.writeBoolean(ing.material != null);
        if (ing.material != null) {
            DataResource.MATERIAL_STREAM_CODEC.encode(buf, ing.material);
        }
        CodecUtils.encodeList(buf, ing.categories, MaterialCategories.STREAM_CODEC);
        CodecUtils.encodeList(buf, ing.notCategories, MaterialCategories.STREAM_CODEC);
    }, buf -> {
        PartType partType = (PartType)PartType.STREAM_CODEC.decode(buf);
        GearType gearType = (GearType)GearType.STREAM_CODEC.decode(buf);
        MaterialGrade minGrade = (MaterialGrade)((Object)((Object)MaterialGrade.STREAM_CODEC.decode(buf)));
        MaterialGrade maxGrade = (MaterialGrade)((Object)((Object)MaterialGrade.STREAM_CODEC.decode(buf)));
        DataResource material = buf.readBoolean() ? (DataResource)DataResource.MATERIAL_STREAM_CODEC.decode(buf) : null;
        List<IMaterialCategory> categories = CodecUtils.decodeList(buf, MaterialCategories.STREAM_CODEC);
        List<IMaterialCategory> notCategories = CodecUtils.decodeList(buf, MaterialCategories.STREAM_CODEC);
        return new PartMaterialIngredient(partType, gearType, minGrade, maxGrade, material, categories, notCategories);
    });
    private final PartType partType;
    private final GearType gearType;
    private final MaterialGrade minGrade;
    private final MaterialGrade maxGrade;
    @Nullable
    private final DataResource<Material> material;
    private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();
    private final Set<IMaterialCategory> notCategories = new LinkedHashSet<IMaterialCategory>();

    public PartMaterialIngredient(PartType partType, GearType gearType, MaterialGrade minGrade, MaterialGrade maxGrade, @Nullable DataResource<Material> material, Collection<IMaterialCategory> categories, Collection<IMaterialCategory> notCategories) {
        this.partType = partType;
        this.gearType = gearType;
        this.minGrade = minGrade;
        this.maxGrade = maxGrade;
        this.material = material;
        this.categories.addAll(categories);
        this.notCategories.addAll(notCategories);
    }

    private PartMaterialIngredient(PartType partType, GearType gearType) {
        this(partType, gearType, MaterialGrade.NONE, MaterialGrade.NONE, null, Collections.emptySet(), Collections.emptySet());
    }

    public static PartMaterialIngredient of(PartType partType) {
        return PartMaterialIngredient.of(partType, (GearType)GearTypes.TOOL.get());
    }

    public static PartMaterialIngredient of(PartType partType, IMaterialCategory ... categories) {
        return PartMaterialIngredient.of(partType, (GearType)GearTypes.TOOL.get(), categories);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType) {
        return new PartMaterialIngredient(partType, gearType);
    }

    public static PartMaterialIngredient of(PartType partType, GearType gearType, IMaterialCategory ... categories) {
        PartMaterialIngredient ret = new PartMaterialIngredient(partType, gearType);
        ret.categories.addAll(Arrays.asList(categories));
        return ret;
    }

    public PartMaterialIngredient not(IMaterialCategory ... notCategories) {
        this.notCategories.addAll(Arrays.asList(notCategories));
        return this;
    }

    public static Builder builder(PartType partType) {
        return PartMaterialIngredient.builder(partType, (GearType)GearTypes.TOOL.get());
    }

    public static Builder builder(PartType partType, GearType gearType) {
        return new Builder(partType, gearType);
    }

    public IngredientType<?> getType() {
        return (IngredientType)SgIngredientTypes.MATERIAL.get();
    }

    @Override
    public PartType getPartType() {
        return this.partType;
    }

    @Override
    public GearType getGearType() {
        return this.gearType;
    }

    @Override
    public Optional<Component> getJeiHint() {
        MutableComponent text;
        MutableComponent cats;
        if (!this.categories.isEmpty()) {
            cats = TextUtil.separatedList(this.categories.stream().map(IMaterialCategory::getDisplayName).collect(Collectors.toList()));
            text = TextUtil.withColor(cats, Color.INDIANRED);
        } else {
            MutableComponent any = TextUtil.translate("material.group", "any");
            text = TextUtil.withColor(any, Color.LIGHTGREEN);
        }
        if (!this.notCategories.isEmpty()) {
            cats = TextUtil.separatedList(this.notCategories.stream().map(IMaterialCategory::getDisplayName).collect(Collectors.toList()));
            text.append((Component)TextUtil.withColor(Component.translatable((String)"jei.silentgear.material_category.not_separator"), Color.DARKGRAY)).append((Component)TextUtil.withColor(cats, Color.DARKGRAY));
        }
        PartGearKey key = PartGearKey.of(this.gearType, this.partType);
        text.append((Component)TextUtil.misc("spaceBrackets", key.getDisplayName()).withStyle(ChatFormatting.GRAY));
        return Optional.of(TextUtil.translate("jei", "materialType", text));
    }

    public Set<IMaterialCategory> getCategories() {
        return Collections.unmodifiableSet(this.categories);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return false;
        }
        MaterialInstance mat = MaterialInstance.from(stack);
        if (mat == null) {
            return false;
        }
        return !(!mat.get().isCraftingAllowed(mat, this.partType, this.gearType) || !this.categories.isEmpty() && !mat.hasAnyCategory(this.categories) || !this.notCategories.isEmpty() && mat.hasAnyCategory(this.notCategories) || this.material != null && !this.material.getId().equals((Object)mat.getId()) || !this.gradesMatch(MaterialGrade.fromStack(stack)));
    }

    private boolean gradesMatch(MaterialGrade grade) {
        return grade.ordinal() >= this.minGrade.ordinal() && (this.maxGrade == MaterialGrade.NONE || grade.ordinal() <= this.maxGrade.ordinal());
    }

    public Stream<Holder<Item>> items() {
        return Stream.of(Items.APPLE.builtInRegistryHolder());
    }

    public SlotDisplay display() {
        return new PartMaterialSlotDisplay(this);
    }

    public boolean isSimple() {
        return false;
    }

    public static class Builder {
        private final PartType partType;
        private final GearType gearType;
        private MaterialGrade minGrade = MaterialGrade.NONE;
        private MaterialGrade maxGrade = MaterialGrade.NONE;
        private DataResource<Material> material;
        private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();
        private final Set<IMaterialCategory> notCategories = new LinkedHashSet<IMaterialCategory>();

        public Builder(PartType partType, GearType gearType) {
            this.partType = partType;
            this.gearType = gearType;
        }

        public Builder withCategories(IMaterialCategory ... categories) {
            this.categories.addAll(Arrays.asList(categories));
            return this;
        }

        public Builder withoutCategories(IMaterialCategory ... notCategories) {
            this.notCategories.addAll(Arrays.asList(notCategories));
            return this;
        }

        public Builder withGrade(@Nullable MaterialGrade min, @Nullable MaterialGrade max) {
            if (min != null) {
                this.minGrade = min;
            }
            if (max != null) {
                this.maxGrade = max;
            }
            return this;
        }

        public Builder withMaterial(DataResource<Material> material) {
            this.material = material;
            return this;
        }

        public PartMaterialIngredient build() {
            return new PartMaterialIngredient(this.partType, this.gearType, this.minGrade, this.maxGrade, this.material, this.categories, this.notCategories);
        }
    }

    public static class PartMaterialSlotDisplay
    implements SlotDisplay {
        public static final MapCodec<PartMaterialSlotDisplay> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PartType.CODEC.fieldOf("part_type").forGetter(d -> d.partType), (App)GearType.CODEC.optionalFieldOf("gear_type").forGetter(d -> Optional.of(d.gearType)), (App)MaterialGrade.CODEC.optionalFieldOf("min_grade", (Object)MaterialGrade.NONE).forGetter(d -> d.minGrade), (App)MaterialGrade.CODEC.optionalFieldOf("max_grade", (Object)MaterialGrade.NONE).forGetter(d -> d.maxGrade), (App)DataResource.MATERIAL_CODEC.optionalFieldOf("material").forGetter(d -> Optional.ofNullable(d.material)), (App)MaterialCategories.CODEC.listOf().optionalFieldOf("categories", Collections.emptyList()).forGetter(d -> ImmutableList.copyOf(d.categories)), (App)MaterialCategories.CODEC.listOf().optionalFieldOf("not_categories", Collections.emptyList()).forGetter(d -> ImmutableList.copyOf(d.notCategories))).apply((Applicative)instance, (pt, gt, minGrade, maxGrade, material, categories, notCategories) -> new PartMaterialSlotDisplay((PartType)pt, gt.orElse((GearType)GearTypes.NONE.get()), (MaterialGrade)((Object)((Object)minGrade)), (MaterialGrade)((Object)((Object)maxGrade)), material.orElse(null), (Collection<IMaterialCategory>)categories, (Collection<IMaterialCategory>)notCategories)));
        public static final StreamCodec<RegistryFriendlyByteBuf, PartMaterialSlotDisplay> STREAM_CODEC = StreamCodec.of((buf, display) -> {
            PartType.STREAM_CODEC.encode(buf, (Object)display.partType);
            GearType.STREAM_CODEC.encode(buf, (Object)display.gearType);
            MaterialGrade.STREAM_CODEC.encode(buf, (Object)display.minGrade);
            MaterialGrade.STREAM_CODEC.encode(buf, (Object)display.maxGrade);
            buf.writeBoolean(display.material != null);
            if (display.material != null) {
                DataResource.MATERIAL_STREAM_CODEC.encode(buf, display.material);
            }
            CodecUtils.encodeList(buf, display.categories, MaterialCategories.STREAM_CODEC);
            CodecUtils.encodeList(buf, display.notCategories, MaterialCategories.STREAM_CODEC);
        }, buf -> {
            PartType partType = (PartType)PartType.STREAM_CODEC.decode(buf);
            GearType gearType = (GearType)GearType.STREAM_CODEC.decode(buf);
            MaterialGrade minGrade = (MaterialGrade)((Object)((Object)MaterialGrade.STREAM_CODEC.decode(buf)));
            MaterialGrade maxGrade = (MaterialGrade)((Object)((Object)MaterialGrade.STREAM_CODEC.decode(buf)));
            DataResource material = buf.readBoolean() ? (DataResource)DataResource.MATERIAL_STREAM_CODEC.decode(buf) : null;
            List<IMaterialCategory> categories = CodecUtils.decodeList(buf, MaterialCategories.STREAM_CODEC);
            List<IMaterialCategory> notCategories = CodecUtils.decodeList(buf, MaterialCategories.STREAM_CODEC);
            return new PartMaterialSlotDisplay(partType, gearType, minGrade, maxGrade, material, categories, notCategories);
        });
        public static final SlotDisplay.Type<PartMaterialSlotDisplay> TYPE = new SlotDisplay.Type(CODEC, STREAM_CODEC);
        private final PartType partType;
        private final GearType gearType;
        private final MaterialGrade minGrade;
        private final MaterialGrade maxGrade;
        @Nullable
        private final DataResource<Material> material;
        private final Set<IMaterialCategory> categories = new LinkedHashSet<IMaterialCategory>();
        private final Set<IMaterialCategory> notCategories = new LinkedHashSet<IMaterialCategory>();

        public PartMaterialSlotDisplay(PartType partType, GearType gearType, MaterialGrade minGrade, MaterialGrade maxGrade, @Nullable DataResource<Material> material, Collection<IMaterialCategory> categories, Collection<IMaterialCategory> notCategories) {
            this.partType = partType;
            this.gearType = gearType;
            this.minGrade = minGrade;
            this.maxGrade = maxGrade;
            this.material = material;
            this.categories.addAll(categories);
            this.notCategories.addAll(notCategories);
        }

        public PartMaterialSlotDisplay(PartMaterialIngredient ingredient) {
            this(ingredient.partType, ingredient.gearType, ingredient.minGrade, ingredient.maxGrade, ingredient.material, ingredient.categories, ingredient.notCategories);
        }

        public <T> Stream<T> resolve(ContextMap context, DisplayContentsFactory<T> output) {
            if (output instanceof DisplayContentsFactory.ForStacks) {
                DisplayContentsFactory.ForStacks forStacks = (DisplayContentsFactory.ForStacks)output;
                return SgRegistries.MATERIAL.getValues(true).stream().map(MaterialInstance::of).filter(mat -> mat.get().isCraftingAllowed(mat, this.partType, this.gearType)).filter(mat -> this.material == null || this.material.getId().equals((Object)mat.getId())).filter(mat -> this.categories.isEmpty() || mat.hasAnyCategory(this.categories)).filter(mat -> this.notCategories.isEmpty() || !mat.hasAnyCategory(this.notCategories)).flatMap(mat -> mat.get().getIngredient().map(IngredientUtils::getItems).orElse(HolderSet.empty()).stream()).map(arg_0 -> ((DisplayContentsFactory.ForStacks)forStacks).forStack(arg_0));
            }
            return Stream.of(new Object[0]);
        }

        public SlotDisplay.Type<? extends PartMaterialSlotDisplay> type() {
            return TYPE;
        }
    }
}

