/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ConversionRecipe
extends ExtendedShapelessRecipe {
    private final Result result;
    private final GearItem item;

    public ConversionRecipe(String pGroup, CraftingBookCategory pCategory, Result pResult, List<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult.item.getDefaultInstance(), pIngredients);
        this.result = pResult;
        if (!(this.result.item instanceof GearItem)) {
            throw new JsonParseException("result is not a gear item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.result.item)));
        }
        this.item = (GearItem)this.result.item;
    }

    public RecipeSerializer<? extends ConversionRecipe> getSerializer() {
        return (RecipeSerializer)SgRecipes.CONVERSION.get();
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack result = this.item.construct(this.getParts());
        ItemStack original = ConversionRecipe.findOriginalItem(inv);
        if (!original.isEmpty()) {
            result.applyComponents(original.getComponents());
        }
        return result;
    }

    private static ItemStack findOriginalItem(CraftingInput inv) {
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.isDamageableItem()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private Collection<PartInstance> getParts() {
        PartList ret = PartList.of(new PartInstance[0]);
        this.result.parts.forEach(part -> {
            if (part != null) {
                ret.add(part);
            }
        });
        return ret;
    }

    public boolean isSpecial() {
        return true;
    }

    public record Result(Item item, List<PartInstance> parts) {
        public static final Codec<Result> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(r -> r.item), (App)Codec.list(PartInstance.CODEC).fieldOf("parts").forGetter(r -> r.parts)).apply((Applicative)instance, Result::new));

        public static Result fromNetwork(RegistryFriendlyByteBuf buf) {
            Item item = (Item)((Holder.Reference)BuiltInRegistries.ITEM.get(buf.readIdentifier()).orElseThrow()).value();
            ArrayList<PartInstance> parts = new ArrayList<PartInstance>();
            int partListSize = buf.readByte();
            for (int i = 0; i < partListSize; ++i) {
                parts.add((PartInstance)PartInstance.STREAM_CODEC.decode((Object)buf));
            }
            return new Result(item, parts);
        }

        public void toNetwork(RegistryFriendlyByteBuf buf) {
            buf.writeIdentifier(BuiltInRegistries.ITEM.getKey((Object)this.item));
            buf.writeByte(this.parts.size());
            this.parts.forEach(part -> PartInstance.STREAM_CODEC.encode((Object)buf, part));
        }
    }

    public static class Serializer
    implements RecipeSerializer<ConversionRecipe> {
        private static final MapCodec<ConversionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> ((ConversionRecipe)recipe).group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(recipe -> ((ConversionRecipe)recipe).category), (App)Result.CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())).fieldOf("ingredients").forGetter(recipe -> ((ConversionRecipe)recipe).ingredients)).apply((Applicative)instance, ConversionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConversionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConversionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConversionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConversionRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            String group = buf.readUtf();
            CraftingBookCategory bookCategory = (CraftingBookCategory)buf.readEnum(CraftingBookCategory.class);
            Result result = Result.fromNetwork(buf);
            NonNullList ingredients = NonNullList.create();
            int ingredientListSize = buf.readVarInt();
            for (int i = 0; i < ingredientListSize; ++i) {
                ingredients.add((Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf)));
            }
            return new ConversionRecipe(group, bookCategory, result, (List<Ingredient>)ingredients);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, ConversionRecipe recipe) {
            buf.writeUtf(recipe.group);
            buf.writeEnum((Enum)recipe.category);
            recipe.result.toNetwork(buf);
            buf.writeVarInt(recipe.ingredients.size());
            recipe.ingredients.forEach(ing -> Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, ing));
        }
    }
}

