/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.MainPartItem;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class GearPartSwapRecipe
extends CustomRecipe {
    public GearPartSwapRecipe(CraftingBookCategory bookCategory) {
        super(bookCategory);
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        StackList list = StackList.from((CraftingInput)inv);
        ItemStack gear = list.uniqueOfType(GearItem.class);
        if (gear.isEmpty()) {
            return false;
        }
        GearItem item = (GearItem)gear.getItem();
        Collection others = list.allMatches(stack -> !(stack.getItem() instanceof GearItem));
        if (others.isEmpty()) {
            return false;
        }
        HashMap<PartType, Integer> typeCounts = new HashMap<PartType, Integer>();
        for (ItemStack stack2 : others) {
            PartInstance part = PartInstance.from(stack2);
            if (part == null) {
                return false;
            }
            PartType type = part.getType();
            if (!item.supportsPart(gear, part) || typeCounts.getOrDefault(type, 0) >= type.maxPerItem()) {
                return false;
            }
            typeCounts.merge(type, 1, Integer::sum);
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        StackList list = StackList.from((CraftingInput)inv);
        ItemStack gear = list.uniqueOfType(GearItem.class);
        if (gear.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Collection others = list.allMatches(stack -> !(stack.getItem() instanceof GearItem));
        if (others.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = gear.copy();
        PartList originalParts = GearData.getConstruction(gear).parts();
        ArrayList<PartInstance> parts = new ArrayList<PartInstance>(originalParts);
        PartList newParts = PartList.of(new PartInstance[0]);
        for (ItemStack stack2 : others) {
            PartInstance part = PartInstance.from(stack2);
            if (part == null) {
                return ItemStack.EMPTY;
            }
            PartType type = part.getType();
            ArrayList<PartInstance> partsOfType = new ArrayList<PartInstance>(originalParts.getPartsOfType(type));
            int maxPerItem = type.maxPerItem();
            if (partsOfType.size() >= maxPerItem) {
                PartInstance oldPart = (PartInstance)partsOfType.getFirst();
                partsOfType.remove(oldPart);
                parts.remove(oldPart);
                oldPart.onRemoveFromGear(result);
            }
            parts.add(part);
            newParts.add(part);
        }
        GearData.writeConstructionParts(result, parts);
        GearData.recalculateGearData(result, CommonHooks.getCraftingPlayer());
        newParts.forEach(p -> p.onAddToGear(result));
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList list = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        ItemStack gear = StackList.from((CraftingInput)inv).uniqueMatch(s -> s.getItem() instanceof GearItem);
        PartList oldParts = GearData.getConstruction(gear).parts();
        HashMap<PartType, Integer> removedCount = new HashMap<PartType, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.getItem() instanceof GearItem) {
                list.set(i, (Object)ItemStack.EMPTY);
                continue;
            }
            PartInstance newPart = PartInstance.from(stack);
            if (newPart == null || ((Boolean)Config.Common.destroySwappedParts.get()).booleanValue()) continue;
            PartType type = newPart.getType();
            List<PartInstance> partsOfType = oldParts.getPartsOfType(type);
            if (partsOfType.size() >= type.maxPerItem()) {
                int index = removedCount.getOrDefault(type, 0);
                if (index >= partsOfType.size()) continue;
                PartInstance oldPart = partsOfType.get(index);
                oldPart.onRemoveFromGear(gear);
                ItemStack oldPartItem = oldPart.getItem();
                if (oldPartItem.getItem() instanceof MainPartItem) {
                    oldPartItem.setDamageValue(gear.getDamageValue());
                }
                list.set(i, (Object)oldPartItem);
                removedCount.merge(type, 1, Integer::sum);
                continue;
            }
            list.set(i, (Object)ItemStack.EMPTY);
        }
        return list;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)SgRecipes.SWAP_GEAR_PART.get();
    }
}

