/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class ShapelessCompoundPartRecipe
extends ExtendedShapelessRecipe {
    private final CompoundPartItem item;

    public ShapelessCompoundPartRecipe(String pGroup, CraftingBookCategory pCategory, ItemStack pResult, List<Ingredient> pIngredients) {
        super(pGroup, pCategory, pResult, pIngredients);
        if (!(pResult.getItem() instanceof CompoundPartItem)) {
            throw new IllegalArgumentException("result is not a compound part item: " + String.valueOf(pResult));
        }
        this.item = (CompoundPartItem)pResult.getItem();
    }

    protected GearType getGearType() {
        return this.item.getGearType();
    }

    public RecipeSerializer<? extends ShapelessCompoundPartRecipe> getSerializer() {
        return (RecipeSerializer)SgRecipes.COMPOUND_PART.get();
    }

    public boolean matches(CraftingInput inv, Level worldIn) {
        if (!super.matches(inv, worldIn)) {
            return false;
        }
        Material first = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat == null) continue;
            if (!mat.get().isCraftingAllowed(mat, this.item.getPartType(), this.getGearType(), inv)) {
                return false;
            }
            if (first == null) {
                first = mat.get();
                continue;
            }
            if (first == mat.get()) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        return this.item.create(ShapelessCompoundPartRecipe.getMaterials(inv));
    }

    private static List<MaterialInstance> getMaterials(CraftingInput inv) {
        ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
        for (int i = 0; i < inv.size(); ++i) {
            MaterialInstance material;
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || (material = MaterialInstance.from(stack.copy().split(1))) == null) continue;
            ret.add(material);
        }
        return ret;
    }

    public boolean isSpecial() {
        return true;
    }
}

