/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.core.SoundPlayback;
import net.silentchaos512.gear.setup.SgRecipeBookCategories;
import net.silentchaos512.gear.setup.SgRecipes;

public class ToolActionRecipe
implements Recipe<Input> {
    private final Ingredient tool;
    private final Ingredient ingredient;
    private final int damageToTool;
    private final ItemStack result;
    private final SoundPlayback sound;
    @Nullable
    private PlacementInfo placementInfo;

    public ToolActionRecipe(Ingredient tool, Ingredient ingredient, int damageToTool, ItemStack result, SoundPlayback sound) {
        this.tool = tool;
        this.ingredient = ingredient;
        this.damageToTool = damageToTool;
        this.result = result;
        this.sound = sound;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public int getDamageToTool() {
        return this.damageToTool;
    }

    public ItemStack getResult() {
        return this.result.copy();
    }

    public SoundPlayback getSound() {
        return this.sound;
    }

    public boolean matches(Input input, Level pLevel) {
        return this.tool.test(input.tool()) && this.ingredient.test(input.ingredient());
    }

    public ItemStack assemble(Input pContainer, HolderLookup.Provider pRegistryAccess) {
        return this.result.copy();
    }

    public RecipeSerializer<? extends ToolActionRecipe> getSerializer() {
        return (RecipeSerializer)SgRecipes.TOOL_ACTION.get();
    }

    public RecipeType<? extends ToolActionRecipe> getType() {
        return (RecipeType)SgRecipes.TOOL_ACTION_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(List.of(this.tool, this.ingredient));
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)SgRecipeBookCategories.TOOL_ACTION.get();
    }

    public record Input(ItemStack tool, ItemStack ingredient) implements RecipeInput
    {
        public ItemStack getItem(int pIndex) {
            return switch (pIndex) {
                case 0 -> this.tool;
                case 1 -> this.ingredient;
                default -> throw new IllegalArgumentException("Index out of bounds: " + pIndex);
            };
        }

        public int size() {
            return 2;
        }
    }

    public static class Serializer
    implements RecipeSerializer<ToolActionRecipe> {
        public static final MapCodec<ToolActionRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("tool").forGetter(r -> r.tool), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("damage_to_tool").forGetter(r -> r.damageToTool), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.result), (App)SoundPlayback.CODEC.fieldOf("sound").forGetter(r -> r.sound)).apply((Applicative)instance, ToolActionRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ToolActionRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ToolActionRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ToolActionRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ToolActionRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            Ingredient tool = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            int damageToTool = buf.readVarInt();
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            SoundPlayback soundEffect = (SoundPlayback)SoundPlayback.STREAM_CODEC.decode((Object)buf);
            return new ToolActionRecipe(tool, ingredient, damageToTool, result, soundEffect);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, ToolActionRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.tool);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.ingredient);
            buf.writeVarInt(recipe.damageToTool);
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.result);
            SoundPlayback.STREAM_CODEC.encode((Object)buf, (Object)recipe.sound);
        }
    }
}

