/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.alloy;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.block.alloymaker.AlloyMakerInfo;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipeInput;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.setup.SgRecipeBookCategories;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.CodecUtils;
import net.silentchaos512.gear.util.Const;

public class AlloyRecipe
implements Recipe<AlloyRecipeInput> {
    final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    final Result result;
    @Nullable
    private PlacementInfo placementInfo = null;

    public AlloyRecipe(Result result, List<Ingredient> ingredients) {
        this.result = result;
        this.ingredients.addAll(ingredients);
    }

    public static <R extends AlloyRecipe> R makeExample(AlloyMakerInfo<?> info, int count, BiFunction<Result, List<Ingredient>, R> recipeFactory) {
        IMaterialCategory[] cats = info.getCategories().toArray(new IMaterialCategory[0]);
        ArrayList<Ingredient> list = new ArrayList<Ingredient>();
        for (int i = 0; i < count; ++i) {
            PartMaterialIngredient partMaterialIngredient = PartMaterialIngredient.of((PartType)PartTypes.NONE.get(), (GearType)GearTypes.ALL.get(), cats);
            list.add(new Ingredient((ICustomIngredient)partMaterialIngredient));
        }
        return (R)((AlloyRecipe)recipeFactory.apply(new Result(info.getOutputItem(), count, Const.Materials.EXAMPLE), list));
    }

    public ItemStack getResultForRecipeDisplay() {
        return this.result.getResult();
    }

    public boolean matches(AlloyRecipeInput inv, Level worldIn) {
        HashSet<Integer> matches = new HashSet<Integer>();
        int inputs = 0;
        for (int i = 0; i < inv.size(); ++i) {
            if (inv.getItem(i).isEmpty()) continue;
            ++inputs;
        }
        for (Ingredient ingredient : this.ingredients) {
            boolean found = false;
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                found = true;
                matches.add(i);
            }
            if (found) continue;
            return false;
        }
        int matchCount = matches.size();
        return matchCount == inputs && matchCount == this.ingredients.size();
    }

    public ItemStack assemble(AlloyRecipeInput inv, HolderLookup.Provider registryAccess) {
        return this.result.getResult();
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<? extends Recipe<AlloyRecipeInput>> getSerializer() {
        return (RecipeSerializer)SgRecipes.COMPOUNDING.get();
    }

    public RecipeType<? extends Recipe<AlloyRecipeInput>> getType() {
        return (RecipeType)SgRecipes.COMPOUNDING_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)SgRecipeBookCategories.ALLOY_FORGE.get();
    }

    public record Result(Item item, int count, @Nullable DataResource<Material> material) {
        public static final Codec<Result> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(r -> r.item), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(r -> r.count), (App)DataResource.MATERIAL_CODEC.optionalFieldOf("material").forGetter(r -> Optional.ofNullable(r.material))).apply((Applicative)instance, (item, count, material) -> new Result((Item)item, (int)count, material.orElse(null))));
        public static final StreamCodec<RegistryFriendlyByteBuf, Result> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), r -> r.item, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.count, (StreamCodec)DataResource.MATERIAL_STREAM_CODEC.apply(ByteBufCodecs::optional), r -> Optional.ofNullable(r.material), (item1, count1, material1) -> new Result((Item)item1, (int)count1, material1.orElse(null)));

        public ItemStack getResult() {
            Item item = this.item;
            if (item instanceof CustomMaterialItem) {
                CustomMaterialItem customMaterialItem = (CustomMaterialItem)item;
                if (this.material != null) {
                    return customMaterialItem.create(MaterialInstance.of(this.material), this.count);
                }
            }
            return new ItemStack((ItemLike)this.item, this.count);
        }
    }

    public static class Serializer<T extends AlloyRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Result.CODEC.fieldOf("result").forGetter(r -> r.result), (App)Codec.list((Codec)Ingredient.CODEC).fieldOf("ingredients").forGetter(r -> r.ingredients)).apply((Applicative)instance, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.of((buf, r) -> {
            Result.STREAM_CODEC.encode(buf, (Object)r.result);
            CodecUtils.encodeList(buf, r.ingredients, Ingredient.CONTENTS_STREAM_CODEC);
        }, buf -> {
            Result result = (Result)Result.STREAM_CODEC.decode(buf);
            List<Ingredient> ingredients = CodecUtils.decodeList(buf, Ingredient.CONTENTS_STREAM_CODEC);
            return factory.create(result, ingredients);
        });

        public Serializer(Factory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }
    }

    @FunctionalInterface
    public static interface Factory<R extends AlloyRecipe> {
        public R create(Result var1, List<Ingredient> var2);
    }
}

