/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.salvage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.CoreGearPart;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRecipeBookCategories;
import net.silentchaos512.gear.setup.SgRecipes;

public class SalvagingRecipe
implements Recipe<SingleRecipeInput> {
    protected final Ingredient ingredient;
    private final List<ItemStack> results = new ArrayList<ItemStack>();
    @Nullable
    private PlacementInfo placementInfo = null;

    public SalvagingRecipe(Ingredient ingredient, List<ItemStack> results) {
        this.ingredient = ingredient;
        this.results.addAll(results);
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public List<ItemStack> getPossibleResults(Container inv) {
        return new ArrayList<ItemStack>(this.results);
    }

    public List<ItemStack> getPossibleResultsForDisplay() {
        return this.getPossibleResults((Container)new SimpleContainer(1));
    }

    public boolean matches(SingleRecipeInput input, Level worldIn) {
        return this.ingredient.test(input.getItem(0));
    }

    @Deprecated
    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registryAccess) {
        return !this.results.isEmpty() ? this.results.getFirst() : ItemStack.EMPTY;
    }

    public RecipeSerializer<? extends Recipe<SingleRecipeInput>> getSerializer() {
        return (RecipeSerializer)SgRecipes.SALVAGING.get();
    }

    public RecipeType<? extends Recipe<SingleRecipeInput>> getType() {
        return (RecipeType)SgRecipes.SALVAGING_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.ingredient);
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)SgRecipeBookCategories.SALVAGER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static List<ItemStack> salvagePart(PartInstance part) {
        ItemStack partStack = part.getItem();
        if (SalvagingRecipe.canSalvagePart(part, partStack)) {
            List<MaterialInstance> materialsInPart = CompoundPartItem.getMaterials(partStack);
            if (materialsInPart.isEmpty()) {
                SilentGear.LOGGER.warn("Compound part contains no materials? {}", (Object)partStack);
                return List.of(partStack);
            }
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            List<MaterialInstance> partMaterials = part.getMaterials();
            for (MaterialInstance material : partMaterials) {
                MaterialInstance salvagedMaterial = material.onSalvage();
                result.add(salvagedMaterial.getItem());
            }
            return result;
        }
        return List.of(partStack);
    }

    private static boolean canSalvagePart(PartInstance part, ItemStack partStack) {
        return part.isValid() && part.get() instanceof CoreGearPart && partStack.getItem() instanceof CompoundPartItem && part.getItem().getMaxStackSize() == 1;
    }

    public static class Serializer
    implements RecipeSerializer<SalvagingRecipe> {
        public static final MapCodec<SalvagingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> r.ingredient), (App)Codec.list((Codec)ItemStack.CODEC).fieldOf("results").forGetter(r -> r.results)).apply((Applicative)instance, SalvagingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SalvagingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> r.ingredient, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), r -> r.results, SalvagingRecipe::new);

        public MapCodec<SalvagingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SalvagingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

