/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.util.GearData;

public abstract class GearSmithingRecipe
implements SmithingRecipe {
    protected final Optional<Ingredient> template;
    protected final Optional<Ingredient> addition;
    protected final Ingredient base;
    protected final ItemStack gearItem;
    @Nullable
    private PlacementInfo placementInfo;

    public GearSmithingRecipe(ItemStack gearItem, Optional<Ingredient> template, Optional<Ingredient> addition) {
        this.template = template;
        this.addition = addition;
        this.gearItem = gearItem;
        this.base = Ingredient.of((ItemLike)this.gearItem.getItem());
    }

    public abstract RecipeSerializer<? extends GearSmithingRecipe> getSerializer();

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registryAccess) {
        ItemStack result = input.base().transmuteCopy((ItemLike)this.gearItem.getItem(), 1);
        ItemStack upgradeItem = input.addition();
        this.applyUpgrade(result, upgradeItem);
        GearData.recalculateGearData(result, null);
        return result;
    }

    protected abstract void applyUpgrade(ItemStack var1, ItemStack var2);

    public Optional<Ingredient> templateIngredient() {
        return this.template;
    }

    public Ingredient baseIngredient() {
        return this.base;
    }

    public Optional<Ingredient> additionIngredient() {
        return this.addition;
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, Optional.of(this.base), this.addition));
        }
        return this.placementInfo;
    }

    @FunctionalInterface
    public static interface Factory<R extends GearSmithingRecipe> {
        public R create(ItemStack var1, Optional<Ingredient> var2, Optional<Ingredient> var3);
    }
}

