/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.smithing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.CommonHooks;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.crafting.recipe.smithing.GearSmithingRecipe;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class UpgradeSmithingRecipe
extends GearSmithingRecipe {
    public UpgradeSmithingRecipe(ItemStack gearItem, Optional<Ingredient> template, Optional<Ingredient> addition) {
        super(gearItem, template, addition);
    }

    @Override
    protected void applyUpgrade(ItemStack stackToModify, ItemStack upgradeItem) {
        GearType gearType;
        PartInstance part = PartInstance.from(upgradeItem);
        if (part != null && (gearType = GearHelper.getType(stackToModify)).isGear() && part.isValid() && part.get().canAddToGear(stackToModify, part) && !GearData.hasPart(stackToModify, part.get())) {
            ItemStack result = stackToModify.copy();
            GearData.addPart(result, part);
            GearData.recalculateGearData(result, CommonHooks.getCraftingPlayer());
        }
    }

    public RecipeSerializer<UpgradeSmithingRecipe> getSerializer() {
        return (RecipeSerializer)SgRecipes.SMITHING_UPGRADE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeSmithingRecipe> {
        public static final MapCodec<UpgradeSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("gear").forGetter(r -> r.gearItem), (App)Ingredient.CODEC.optionalFieldOf("template").forGetter(r -> r.template), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter(r -> r.addition)).apply((Applicative)instance, UpgradeSmithingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeSmithingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, r -> r.gearItem, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, r -> r.template, (StreamCodec)Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, r -> r.addition, UpgradeSmithingRecipe::new);

        public MapCodec<UpgradeSmithingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeSmithingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

