/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Util;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.data.MaterialsProvider;
import net.silentchaos512.gear.data.ModAdvancementProvider;
import net.silentchaos512.gear.data.ModDataMapProvider;
import net.silentchaos512.gear.data.ModSoundDefinitionsProvider;
import net.silentchaos512.gear.data.PartsProvider;
import net.silentchaos512.gear.data.client.ModEquipmentAssetsProvider;
import net.silentchaos512.gear.data.client.ModModelProvider;
import net.silentchaos512.gear.data.loot.ModLootModifierProvider;
import net.silentchaos512.gear.data.loot.ModLootTables;
import net.silentchaos512.gear.data.recipes.ModRecipesProvider;
import net.silentchaos512.gear.data.tags.ModBlockTagsProvider;
import net.silentchaos512.gear.data.tags.ModDamageTypeTagsProvider;
import net.silentchaos512.gear.data.tags.ModEntityTypeTagsProvider;
import net.silentchaos512.gear.data.tags.ModItemTagsProvider;
import net.silentchaos512.gear.data.trait.TraitsProvider;
import net.silentchaos512.lib.data.recipe.LibRecipeProvider;

@EventBusSubscriber
public final class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (DataProvider)new ModDataMapProvider(packOutput, lookupProvider));
        ModBlockTagsProvider blocks = new ModBlockTagsProvider(packOutput, lookupProvider);
        generator.addProvider(true, (DataProvider)blocks);
        generator.addProvider(true, (DataProvider)new ModItemTagsProvider((GatherDataEvent)event, blocks));
        generator.addProvider(true, (DataProvider)new ModDamageTypeTagsProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModEntityTypeTagsProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new TraitsProvider(lookupProvider, generator));
        generator.addProvider(true, (DataProvider)new MaterialsProvider(lookupProvider, generator));
        generator.addProvider(true, (DataProvider)new PartsProvider(generator));
        generator.addProvider(true, (DataProvider)new ModLootTables((GatherDataEvent)event));
        generator.addProvider(true, (DataProvider)new ModLootModifierProvider((GatherDataEvent)event));
        generator.addProvider(true, (DataProvider)LibRecipeProvider.createRunner((PackOutput)packOutput, (CompletableFuture)lookupProvider, (String)"Silent Gear Recipes", ModRecipesProvider::new));
        generator.addProvider(true, (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)new ModModelProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModSoundDefinitionsProvider(packOutput));
        generator.addProvider(true, (DataProvider)new ModEquipmentAssetsProvider(packOutput));
    }

    public static CompletableFuture<?> saveStable(CachedOutput p_253653_, JsonElement p_254542_, Path p_254467_) {
        return CompletableFuture.runAsync(() -> {
            try {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                HashingOutputStream hashingoutputstream = new HashingOutputStream(Hashing.sha1(), (OutputStream)bytearrayoutputstream);
                try (JsonWriter jsonwriter = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)hashingoutputstream, StandardCharsets.UTF_8));){
                    jsonwriter.setSerializeNulls(false);
                    jsonwriter.setIndent("  ");
                    GsonHelper.writeValue((JsonWriter)jsonwriter, (JsonElement)p_254542_, null);
                }
                p_253653_.writeIfNeeded(p_254467_, bytearrayoutputstream.toByteArray(), hashingoutputstream.hash());
            }
            catch (IOException ioexception) {
                SilentGear.LOGGER.error("Failed to save file to {}", (Object)p_254467_, (Object)ioexception);
            }
        }, (Executor)Util.backgroundExecutor());
    }
}

