/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.data.material.MaterialBuilder;
import net.silentchaos512.gear.api.data.material.MaterialsProviderBase;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.MaterialCraftingData;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.BooleanPropertyValue;
import net.silentchaos512.gear.api.property.HarvestTier;
import net.silentchaos512.gear.api.property.HarvestTierPropertyValue;
import net.silentchaos512.gear.api.property.NumberProperty;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.material.SgEquippableInfo;
import net.silentchaos512.gear.core.BuiltinMaterials;
import net.silentchaos512.gear.crafting.ingredient.CustomAlloyIngredient;
import net.silentchaos512.gear.crafting.ingredient.OptionalTagIngredient;
import net.silentchaos512.gear.data.ExtraMetals;
import net.silentchaos512.gear.gear.material.CompoundMaterial;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.SimpleMaterial;
import net.silentchaos512.gear.gear.trait.condition.GearTypeTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.MaterialCountTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.MaterialRatioTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.NotTraitCondition;
import net.silentchaos512.gear.gear.trait.condition.OrTraitCondition;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;

public class MaterialsProvider
extends MaterialsProviderBase {
    private HolderGetter<Item> items;

    public MaterialsProvider(CompletableFuture<HolderLookup.Provider> lookupProvider, DataGenerator generator) {
        super(lookupProvider, generator, "silentgear");
    }

    @Override
    protected Collection<MaterialBuilder<?>> getMaterials(HolderLookup.Provider registries) {
        this.items = registries.lookupOrThrow(Registries.ITEM);
        ArrayList ret = new ArrayList();
        this.addCraftedMaterials(ret, registries);
        this.addIntangibles(ret, registries);
        this.addModMetals(ret, registries);
        this.addVanillaMetals(ret, registries);
        this.addGems(ret, registries);
        this.addDusts(ret, registries);
        this.addStones(ret, registries);
        this.addWoods(ret, registries);
        this.addClothLikes(ret, registries);
        this.addStringsAndFibers(ret, registries);
        this.addRandomOrganics(ret, registries);
        this.addCompounds(ret, registries);
        this.addSimpleRods(ret, registries);
        this.addExtraMetals(ret, registries);
        return ret;
    }

    private void addCraftedMaterials(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.processed(this.modId("sheet_metal")).crafting((ItemLike)SgItems.SHEET_METAL, MaterialCategories.SHEET).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, -1.0f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, -0.4f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR, -0.5f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_TOUGHNESS, -0.5f, NumberProperty.Operation.MULTIPLY_TOTAL));
    }

    private void addIntangibles(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("barrier")).crafting(new MaterialCraftingData(Ingredient.of((ItemLike)Items.BARRIER), Collections.singletonList(MaterialCategories.INTANGIBLE), Collections.emptyList(), Collections.emptyMap(), false)).display((Component)Component.translatable((String)Items.BARRIER.getDescriptionId()), 0xFF0000).mainStatsCommon(1337.0f, 84.0f, 5.0f, 111.0f, 0.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -1.0f).mainStatsHarvest(HarvestTier.WOOD, 5.0f).mainStatsMelee(1.0f, 1.0f, 0.0f).mainStatsRanged(1.0f, 0.0f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 10.0f, 10.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ADAMANT, 5, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HOLY, 5, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("example")).crafting(new MaterialCraftingData(Optional.empty(), Collections.singletonList(MaterialCategories.INTANGIBLE), Collections.singletonList((GearType)GearTypes.ALL.get()), Collections.emptyMap(), false)).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST).mainStatsCommon(100.0f, 6.0f, 1.0f, 0.0f, 1.0f).mainStatsHarvest(HarvestTier.WOOD, 1.0f).mainStatsMelee(1.0f, 1.0f, 0.0f).mainStatsRanged(0.0f, 0.0f).mainStatsArmor(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f).noProperties((Supplier<PartType>)PartTypes.ROD).noProperties((Supplier<PartType>)PartTypes.TIP).noProperties((Supplier<PartType>)PartTypes.COATING).noProperties((Supplier<PartType>)PartTypes.GRIP).noProperties((Supplier<PartType>)PartTypes.BINDING).noProperties((Supplier<PartType>)PartTypes.LINING).noProperties((Supplier<PartType>)PartTypes.CORD).noProperties((Supplier<PartType>)PartTypes.FLETCHING).noProperties((Supplier<PartType>)PartTypes.SETTING));
    }

    private void addModMetals(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.AZURE_ELECTRUM).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_AZURE_ELECTRUM, SgTags.Items.RODS_AZURE_ELECTRUM, MaterialCategories.METAL, MaterialCategories.ENDGAME).displayWithDefaultName(4552163, TextureType.HIGH_CONTRAST).mainStatsCommon(1259.0f, 61.0f, 37.0f, 109.0f, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.5f).mainStatsHarvest(29.0f).mainStatsMelee(7.0f, 11.0f, 0.0f).mainStatsRanged(3.0f, 0.0f).mainStatsProjectile(2.0f, 1.5f).mainStatsArmor(3.0f, 7.0f, 6.0f, 3.0f, 8.0f, 19.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ACCELERATE, 3, new MaterialRatioTraitCondition(0.35f)).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LIGHT, 4, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 3.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.PROJECTILE_SPEED, 1.5f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.ACCELERATE, 5, new MaterialRatioTraitCondition(0.66f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 401.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 11.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 5.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.AZURE_SILVER).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_AZURE_SILVER, SgTags.Items.RODS_AZURE_SILVER, MaterialCategories.METAL, MaterialCategories.ADVANCED).displayWithDefaultName(13351679, TextureType.HIGH_CONTRAST).mainStatsCommon(197.0f, 17.0f, 29.0f, 83.0f, 1.4f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.5f).mainStatsHarvest(19.0f).mainStatsMelee(5.0f, 7.0f, 0.0f).mainStatsRanged(2.0f, 0.0f).mainStatsProjectile(1.2f, 1.1f).mainStatsArmor(2.0f, 5.0f, 4.0f, 2.0f, 0.0f, 13.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MOONWALKER, 4, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, -0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 3.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BENDING, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 83.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 3.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 3.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_SPEED, 0.2f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 31.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.FORTUNATE, 3, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BLAZE_GOLD).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_BLAZE_GOLD, SgTags.Items.RODS_BLAZE_GOLD, MaterialCategories.METAL, MaterialCategories.ADVANCED).displayWithDefaultName(14517504).mainStatsCommon(69.0f, 9.0f, 24.0f, 45.0f, 1.2f).mainStatsHarvest(15.0f).mainStatsMelee(2.0f, 5.0f, 0.1f).mainStatsRanged(1.0f, 0.2f).mainStatsProjectile(1.2f, 0.9f).mainStatsArmor(2.0f, 5.0f, 4.0f, 2.0f, 1.0f, 10.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRILLIANT, 1, new MaterialRatioTraitCondition(0.7f)).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.GREEDY, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 32.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 3.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 4.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 14.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.SOFT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.FIERY, 4, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.DURABILITY, -0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_DURABILITY, -0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.RARITY, 20.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.BRILLIANT, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.SOFT, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BRONZE).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_BRONZE, SgTags.Items.RODS_BRONZE, MaterialCategories.METAL, MaterialCategories.INTERMEDIATE).displayWithDefaultName(14061627, TextureType.HIGH_CONTRAST).mainStatsCommon(300.0f, 13.0f, 12.0f, 15.0f, 1.1f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).mainStatsHarvest(6.0f).mainStatsMelee(2.5f, 1.0f, 0.2f).mainStatsRanged(2.0f, -0.2f).mainStatsArmor(3.0f, 6.0f, 4.0f, 2.0f, 1.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SHARP, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 96.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 2.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 0.75f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 0.75f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_SPEED, 0.1f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 6.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.CRIMSON_IRON).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_CRIMSON_IRON, SgTags.Items.RODS_CRIMSON_IRON, MaterialCategories.METAL, MaterialCategories.ADVANCED).displayWithDefaultName(16736649, TextureType.HIGH_CONTRAST).mainStatsCommon(420.0f, 27.0f, 14.0f, 31.0f, 0.7f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.5f).mainStatsHarvest(10.0f).mainStatsMelee(3.0f, 3.0f, -0.1f).mainStatsRanged(2.0f, -0.1f).mainStatsProjectile(1.0f, 1.1f).mainStatsArmor(3.0f, 7.0f, 5.0f, 3.0f, 2.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HEAT_RESISTANT, 4, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 224.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 8.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.FIERY, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.CRIMSON_STEEL).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_CRIMSON_STEEL, SgTags.Items.RODS_CRIMSON_STEEL, MaterialCategories.METAL, MaterialCategories.ENDGAME).displayWithDefaultName(14423100, TextureType.HIGH_CONTRAST, SgEquippableInfo.CRIMSON_STEEL).mainStatsCommon(2400.0f, 42.0f, 19.0f, 83.0f, 0.9f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.5f).mainStatsHarvest(15.0f).mainStatsMelee(6.0f, 6.0f, -0.1f).mainStatsRanged(3.0f, -0.1f).mainStatsProjectile(1.0f, 1.3f).mainStatsArmor(4.0f, 8.0f, 6.0f, 4.0f, 10.0f, 10.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 5, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLAME_WARD, 1, MaterialsProvider.materialCountOrRatio(3, 0.33f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 1.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.STURDY, 1, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 448.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 16.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 20.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MAGMATIC, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.TYRIAN_STEEL).craftingWithRodSubstitute(this.items, SgTags.Items.INGOTS_TYRIAN_STEEL, SgTags.Items.RODS_TYRIAN_STEEL, MaterialCategories.METAL, MaterialCategories.ENDGAME).displayWithDefaultName(11538560, TextureType.HIGH_CONTRAST).mainStatsCommon(3652.0f, 81.0f, 16.0f, 100.0f, 1.1f).mainStatsHarvest(18.0f).mainStatsMelee(8.0f, 6.0f, 0.0f).mainStatsRanged(4.0f, 0.0f).mainStatsProjectile(1.1f, 1.1f).mainStatsArmor(5.0f, 9.0f, 7.0f, 4.0f, 12.0f, 12.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.STURDY, 3, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.VOID_WARD, 1, MaterialsProvider.materialCountOrRatio(3, 0.5f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, -2.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.STURDY, 4, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 251.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 30.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.IMPERIAL, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.GOLD_DIGGER, 3, new ITraitCondition[0]));
    }

    private void addVanillaMetals(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.COPPER).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.INGOTS_COPPER, SgTags.Items.RODS_COPPER, MaterialCategories.METAL, MaterialCategories.BASIC).displayWithDefaultName(16613452, TextureType.HIGH_CONTRAST).mainStatsCommon(190.0f, 11.0f, 13.0f, 12.0f, 1.3f).mainStatsHarvest(5.0f).mainStatsMelee(1.0f, 1.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.1f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, 0.0f).mainStatsRanged(0.1f, 0.0f).mainStatsArmor(2.0f, 4.0f, 3.0f, 1.0f, 0.0f, 8.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.POLISHED, 1, new MaterialRatioTraitCondition(1.0f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BENDING, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 32.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 1.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 4.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.DULLING, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.GOLD).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.INGOTS_GOLD, SgTags.Items.RODS_GOLD, MaterialCategories.METAL, MaterialCategories.INTERMEDIATE).displayWithDefaultName(16646000, TextureType.HIGH_CONTRAST).mainStatsCommon(32.0f, 7.0f, 22.0f, 50.0f, 1.2f).mainStatsHarvest(12.0f).mainStatsMelee(0.0f, 4.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -2.0f).mainStatsRanged(0.0f, 0.3f).mainStatsProjectile(1.1f, 1.0f).mainStatsArmor(2.0f, 5.0f, 3.0f, 1.0f, 0.0f, 8.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRILLIANT, 1, new MaterialRatioTraitCondition(0.7f)).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 3.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BENDING, 4, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 16.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 6.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DRAW_SPEED, 0.2f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 30.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.SOFT, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.DURABILITY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_DURABILITY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.BRILLIANT, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.SOFT, 3, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.IRON).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.INGOTS_IRON, SgTags.Items.RODS_IRON, MaterialCategories.METAL, MaterialCategories.INTERMEDIATE).displayWithDefaultName(0xFFFFFF, TextureType.HIGH_CONTRAST).mainStatsCommon(250.0f, 15.0f, 14.0f, 20.0f, 0.7f).mainStatsHarvest(6.0f).mainStatsMelee(2.0f, 1.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.1f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, 0.0f).mainStatsRanged(1.0f, 0.1f).mainStatsProjectile(1.0f, 1.1f).mainStatsArmor(2.0f, 6.0f, 5.0f, 2.0f, 0.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 128.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 4.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DRAW_SPEED, 0.2f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 8.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("netherite")).crafting(this.items, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, MaterialCategories.METAL, MaterialCategories.ENDGAME).display((Component)TextUtil.translate("material", "netherite"), (Component)TextUtil.translate("material", "netherite"), 8813446).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.DURABILITY, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.DURABILITY, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_DURABILITY, 0.121212125f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.RARITY, 40.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.HARVEST_TIER, new HarvestTierPropertyValue(HarvestTier.create("netherite", "4", (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL))).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.HARVEST_SPEED, 0.125f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ATTACK_DAMAGE, 0.33333334f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.MAGIC_DAMAGE, 0.33333334f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.RANGED_DAMAGE, 0.33333334f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_TOUGHNESS, 4.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.KNOCKBACK_RESISTANCE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ENCHANTMENT_VALUE, 5.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.FIREPROOF, 1, new ITraitCondition[0]));
    }

    private void addGems(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.DIAMOND).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, SgTags.Items.RODS_DIAMOND, MaterialCategories.GEM, MaterialCategories.ADVANCED).displayWithDefaultName(3402699, TextureType.HIGH_CONTRAST).mainStatsCommon(1561.0f, 33.0f, 10.0f, 70.0f, 0.8f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, 1.0f).mainStatsHarvest(8.0f).mainStatsMelee(3.0f, 1.0f, 0.0f).mainStatsRanged(2.0f, -0.2f).mainStatsProjectile(0.9f, 1.1f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 8.0f, 4.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 1, MaterialsProvider.materialCountOrRatio(3, 0.5f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 5, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.LUSTROUS, 4, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 256.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 9.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RANGED_DAMAGE, 0.5f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 20.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.LUSTROUS, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.BASTION, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.EMERALD).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.GEMS_EMERALD, SgTags.Items.RODS_EMERALD, MaterialCategories.GEM, MaterialCategories.ADVANCED).displayWithDefaultName(45112, TextureType.HIGH_CONTRAST).mainStatsCommon(1080.0f, 24.0f, 16.0f, 40.0f, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.25f).mainStatsHarvest(10.0f).mainStatsMelee(2.0f, 2.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, 1.0f).mainStatsRanged(1.0f, -0.1f).mainStatsProjectile(1.1f, 0.9f).mainStatsArmor(3.0f, 6.0f, 4.0f, 3.0f, 4.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SYNERGISTIC, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 4, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 512.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 12.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RANGED_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 20.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.SYNERGISTIC, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.REACH, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.LAPIS_LAZULI).crafting(this.items, (TagKey<Item>)Tags.Items.GEMS_LAPIS, MaterialCategories.GEM, MaterialCategories.INTERMEDIATE).displayWithDefaultName(2247599, TextureType.HIGH_CONTRAST).mainStatsCommon(200.0f, 13.0f, 17.0f, 30.0f, 1.3f).mainStatsHarvest(5.0f).mainStatsMelee(2.0f, 3.0f, 0.0f).mainStatsRanged(0.0f, -0.1f).mainStatsProjectile(1.0f, 0.8f).mainStatsArmor(2.0f, 6.0f, 5.0f, 2.0f, 0.0f, 10.0f).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_SPEED, 0.3f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.HOLY, 1, new MaterialRatioTraitCondition(0.75f)).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.LUCKY, 4, new MaterialRatioTraitCondition(0.75f)).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.LUCKY, 3, new MaterialRatioTraitCondition(0.75f)));
        ret.add(MaterialBuilder.simple(this.modId("prismarine")).crafting(this.items, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE, MaterialCategories.GEM, MaterialCategories.ORGANIC, MaterialCategories.ADVANCED).displayWithDefaultName((Component)TextUtil.translate("material", "prismarine"), 9553335, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.DURABILITY, 0.075f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_DURABILITY, 0.125f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.ARMOR_TOUGHNESS, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.COATING, GearProperties.KNOCKBACK_RESISTANCE, 0.25f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.AQUATIC, 5, new MaterialRatioTraitCondition(0.67f)).trait((Supplier<PartType>)PartTypes.COATING, Const.Traits.AQUATIC, 3, new NotTraitCondition(new MaterialRatioTraitCondition(0.67f))).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.SWIFT_SWIM, 3, new MaterialRatioTraitCondition(0.67f)));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.QUARTZ).craftingWithRodSubstitute(this.items, (TagKey<Item>)Tags.Items.GEMS_QUARTZ, SgTags.Items.RODS_QUARTZ, MaterialCategories.GEM, MaterialCategories.INTERMEDIATE).displayWithDefaultName(13945530, TextureType.HIGH_CONTRAST).mainStatsCommon(330.0f, 13.0f, 10.0f, 40.0f, 1.2f).mainStatsHarvest(7.0f).mainStatsMelee(2.0f, 0.0f, 0.1f).mainStatsRanged(0.0f, 0.1f).mainStatsProjectile(1.0f, 1.0f).mainStatsArmor(3.0f, 5.0f, 4.0f, 2.0f, 0.0f, 4.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.CRUSHING, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 64.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ARMOR_DURABILITY, 64.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 4.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RANGED_DAMAGE, 1.5f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 20.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.CHIPPING, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.JAGGED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.MIGHTY, 2, new MaterialRatioTraitCondition(0.5f)));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.AMETHYST).crafting(this.items, (TagKey<Item>)Tags.Items.GEMS_AMETHYST, MaterialCategories.GEM, MaterialCategories.INTERMEDIATE).displayWithDefaultName(10690022, TextureType.HIGH_CONTRAST).mainStatsCommon(210.0f, 10.0f, 16.0f, 35.0f, 1.3f).mainStatsHarvest(6.0f).mainStatsMelee(1.0f, 3.0f, 0.0f).mainStatsRanged(1.0f, 0.0f).mainStatsProjectile(1.0f, 1.0f).mainStatsArmor(3.0f, 5.0f, 4.0f, 3.0f, 0.0f, 10.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.RENEW, 1, new MaterialRatioTraitCondition(0.7f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, -0.25f, NumberProperty.Operation.MULTIPLY_TOTAL).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.SILKY, 1, new MaterialRatioTraitCondition(0.66f)).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.CURSED, 4, new ITraitCondition[0]));
    }

    private void addDusts(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("crushed_shulker_shell")).crafting(CraftingItems.CRUSHED_SHULKER_SHELL, MaterialCategories.ROCK, MaterialCategories.DUST, MaterialCategories.ENDGAME).displayWithDefaultName(14715871, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ADDITIVE, new BooleanPropertyValue(true)).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 2500.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 91.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ERODED, 4, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("glowstone")).crafting(this.items, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, MaterialCategories.GEM, MaterialCategories.DUST, MaterialCategories.INTERMEDIATE).displayWithDefaultName(0xD2D200, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ADDITIVE, new BooleanPropertyValue(true)).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.15f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.4f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 3.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.RENEW, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 0.4f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DRAW_SPEED, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 15.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.REFRACTIVE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.LUSTROUS, 4, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("redstone")).crafting(this.items, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, MaterialCategories.METAL, MaterialCategories.DUST, MaterialCategories.INTERMEDIATE).displayWithDefaultName(0xBB0000, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ADDITIVE, new BooleanPropertyValue(true)).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, -0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 30.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.IMPERIAL, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_SPEED, 0.3f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RANGED_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 10.0f, NumberProperty.Operation.ADD));
    }

    private void addStones(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BASALT).crafting((ItemLike)Items.BASALT, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(0x4F4B4F, TextureType.LOW_CONTRAST).mainStatsCommon(137.0f, 4.0f, 6.0f, 7.0f, 0.7f).mainStatsHarvest(4.0f).mainStatsMelee(1.0f, 0.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.2f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -1.0f).mainStatsRanged(0.0f, -0.1f, 1.0f, 0.8f).mainStatsArmor(1.0f, 3.0f, 1.0f, 1.0f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.CHIPPING, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.CHIPPING, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BLACKSTONE).crafting((ItemLike)Items.BLACKSTONE, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(3946823, TextureType.LOW_CONTRAST).mainStatsCommon(151.0f, 5.0f, 4.0f, 9.0f, 0.6f).mainStatsHarvest(4.0f).mainStatsMelee(1.0f, 0.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.2f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -1.0f).mainStatsRanged(0.0f, -0.2f, 1.0f, 0.8f).mainStatsArmor(1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.JAGGED, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.HARD, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.END_STONE).crafting(this.items, (TagKey<Item>)Tags.Items.END_STONES, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFCC).mainStatsCommon(1164.0f, 15.0f, 10.0f, 32.0f, 0.9f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.2f).mainStatsHarvest(7.0f).mainStatsMelee(2.0f, 3.0f, 0.1f).mainStatsRanged(0.0f, 0.0f, 1.0f, 0.8f).mainStatsArmor(3.0f, 5.0f, 4.0f, 3.0f, 1.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ANCIENT, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 1.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.ANCIENT, 4, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.FLINT).crafting((ItemLike)Items.FLINT, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(0x969696, TextureType.HIGH_CONTRAST).mainStatsCommon(124.0f, 4.0f, 3.0f, 6.0f, 0.8f).mainStatsHarvest(5.0f).mainStatsMelee(2.0f, 0.0f, -0.1f).mainStatsRanged(1.0f, -0.3f, 1.0f, 1.0f).mainStatsArmor(0.5f, 2.0f, 1.0f, 0.5f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.JAGGED, 2, new ITraitCondition[0]).noProperties((Supplier<PartType>)PartTypes.SETTING));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.NETHERRACK).crafting(this.items, (TagKey<Item>)Tags.Items.NETHERRACKS, MaterialCategories.ROCK, MaterialCategories.ORGANIC, MaterialCategories.BASIC).displayWithDefaultName(8733250, TextureType.LOW_CONTRAST).mainStatsCommon(142.0f, 5.0f, 8.0f, 11.0f, 0.8f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.2f).mainStatsHarvest(5.0f).mainStatsMelee(0.5f, 0.5f, 0.0f).mainStatsRanged(0.5f, 0.1f, 0.8f, 1.0f).mainStatsArmor(1.0f, 4.0f, 2.0f, 1.0f, 0.0f, 4.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ERODED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.ERODED, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BENDING, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.OBSIDIAN).crafting(this.items, (TagKey<Item>)Tags.Items.OBSIDIANS, MaterialCategories.ROCK, MaterialCategories.ADVANCED).displayWithDefaultName(0x443464, TextureType.LOW_CONTRAST).mainStatsCommon(1024.0f, 13.0f, 7.0f, 10.0f, 0.6f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.25f).mainStatsHarvest(6.0f).mainStatsMelee(3.0f, 2.0f, -0.4f).mainStatsRanged(0.0f, -0.4f, 0.7f, 0.7f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 4.0f, 8.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.CRUSHING, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.CHIPPING, 3, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.SANDSTONE).crafting(this.items, (TagKey<Item>)Tags.Items.SANDSTONE_UNCOLORED_BLOCKS, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(14932912, TextureType.LOW_CONTRAST).mainStatsCommon(117.0f, 6.0f, 7.0f, 7.0f, 0.7f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.1f).mainStatsHarvest(4.0f).mainStatsMelee(1.0f, 0.0f, 0.1f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.1f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -1.0f).mainStatsRanged(0.0f, -0.1f, 1.0f, 0.8f).mainStatsArmor(1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("sandstone/red")).parent(BuiltinMaterials.SANDSTONE.getMaterial()).crafting(this.items, (TagKey<Item>)Tags.Items.SANDSTONE_RED_BLOCKS, new IMaterialCategory[0]).displayWithDefaultName(14252848));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.STONE).crafting(new MaterialCraftingData(this.taggedItems((TagKey<Item>)Tags.Items.COBBLESTONES), List.of(MaterialCategories.ROCK, MaterialCategories.BASIC), List.of(), Map.of((PartType)PartTypes.ROD.get(), this.taggedItems(SgTags.Items.RODS_STONE)), true)).displayWithDefaultName(0x9A9A9A, TextureType.LOW_CONTRAST).mainStatsCommon(131.0f, 5.0f, 5.0f, 4.0f, 0.5f).mainStatsHarvest(4.0f).mainStatsMelee(1.0f, 0.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.2f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -1.0f).mainStatsRanged(0.0f, -0.2f, 1.0f, 0.8f).mainStatsArmor(1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ANCIENT, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.CRUSHING, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("stone/andesite")).parent(BuiltinMaterials.STONE.getMaterial()).crafting((ItemLike)Items.ANDESITE, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(0x8A8A8E, TextureType.LOW_CONTRAST));
        ret.add(MaterialBuilder.simple(this.modId("stone/diorite")).parent(BuiltinMaterials.STONE.getMaterial()).crafting((ItemLike)Items.DIORITE, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST));
        ret.add(MaterialBuilder.simple(this.modId("stone/granite")).parent(BuiltinMaterials.STONE.getMaterial()).crafting((ItemLike)Items.GRANITE, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(10447704, TextureType.LOW_CONTRAST));
        DataResource<Material> sgTerracotta = BuiltinMaterials.TERRACOTTA.getMaterial();
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.TERRACOTTA).crafting((ItemLike)Items.TERRACOTTA, MaterialCategories.ROCK, MaterialCategories.BASIC).displayWithDefaultName(9985861, TextureType.LOW_CONTRAST).mainStatsCommon(165.0f, 11.0f, 9.0f, 7.0f, 0.8f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.1f).mainStatsHarvest(4.0f).mainStatsMelee(1.5f, 0.0f, 0.2f).mainStatsRanged(0.0f, -0.2f, 1.0f, 0.9f).mainStatsArmor(2.0f, 3.0f, 3.0f, 1.0f, 0.0f, 3.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.CHIPPING, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.RUSTIC, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.CRUSHING, 1, new ITraitCondition[0]));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "black", (ItemLike)Items.BLACK_TERRACOTTA, 2430480));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "blue", (ItemLike)Items.BLUE_TERRACOTTA, 4864859));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "brown", (ItemLike)Items.BROWN_TERRACOTTA, 5059108));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "cyan", (ItemLike)Items.CYAN_TERRACOTTA, 13742497));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "gray", (ItemLike)Items.GRAY_TERRACOTTA, 13742497));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "green", (ItemLike)Items.GREEN_TERRACOTTA, 4936234));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "light_blue", (ItemLike)Items.LIGHT_BLUE_TERRACOTTA, 7367818));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "light_gray", (ItemLike)Items.LIGHT_GRAY_TERRACOTTA, 8874593));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "lime", (ItemLike)Items.LIME_TERRACOTTA, 6780212));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "magenta", (ItemLike)Items.MAGENTA_TERRACOTTA, 9787244));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "orange", (ItemLike)Items.ORANGE_TERRACOTTA, 10507045));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "pink", (ItemLike)Items.PINK_TERRACOTTA, 10505550));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "purple", (ItemLike)Items.PURPLE_TERRACOTTA, 7750998));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "red", (ItemLike)Items.RED_TERRACOTTA, 9321518));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "white", (ItemLike)Items.WHITE_TERRACOTTA, 13742497));
        ret.add(MaterialsProvider.terracotta(sgTerracotta, "yellow", (ItemLike)Items.YELLOW_TERRACOTTA, 12157987));
    }

    private void addWoods(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.WOOD).crafting(new MaterialCraftingData(this.taggedItems((TagKey<Item>)ItemTags.PLANKS), List.of(MaterialCategories.ORGANIC, MaterialCategories.WOOD), List.of(), Map.of((PartType)PartTypes.ROD.get(), Ingredient.of((ItemLike)Items.STICK)), true)).displayWithDefaultName(9004839, TextureType.LOW_CONTRAST).mainStatsCommon(59.0f, 8.0f, 15.0f, 1.0f, 0.6f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.25f).mainStatsHarvest(2.0f).mainStatsMelee(0.0f, 0.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.2f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -2.0f).mainStatsRanged(0.0f, 0.0f, 1.0f, 0.9f).mainStatsArmor(1.0f, 3.0f, 2.0f, 1.0f, 0.0f, 2.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLAMMABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialsProvider.wood("acacia", (ItemLike)Items.ACACIA_PLANKS, 12215095));
        ret.add(MaterialsProvider.wood("birch", (ItemLike)Items.BIRCH_PLANKS, 14139781));
        ret.add(MaterialsProvider.wood("dark_oak", (ItemLike)Items.DARK_OAK_PLANKS, 5190168));
        ret.add(MaterialsProvider.wood("jungle", (ItemLike)Items.JUNGLE_PLANKS, 12093284));
        ret.add(MaterialsProvider.wood("oak", (ItemLike)Items.OAK_PLANKS, 12096607));
        ret.add(MaterialsProvider.wood("spruce", (ItemLike)Items.SPRUCE_PLANKS, 8544570));
        ret.add(MaterialsProvider.wood("crimson", (ItemLike)Items.CRIMSON_PLANKS, 8272470).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialsProvider.wood("warped", (ItemLike)Items.WARPED_PLANKS, 3769218).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.NETHERWOOD).parent(Const.Materials.WOOD).crafting(new MaterialCraftingData(Ingredient.of(SgBlocks.NETHERWOOD_PLANKS), List.of(MaterialCategories.ORGANIC, MaterialCategories.WOOD), List.of(), Map.of((PartType)PartTypes.ROD.get(), this.taggedItems(SgTags.Items.RODS_NETHERWOOD)), true)).displayWithDefaultName(0x7D272D, TextureType.LOW_CONTRAST).mainStatsCommon(72.0f, 12.0f, 13.0f, 4.0f, 0.7f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.1f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_EFFICIENCY, 0.5f).mainStatsHarvest(2.0f).mainStatsMelee(0.0f, 0.0f, 0.2f).mainStatsRanged(0.0f, 0.0f, 1.0f, 0.8f).mainStatsArmor(1.0f, 4.0f, 2.0f, 1.0f, 0.0f, 6.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.JAGGED, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.5f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BAMBOO).crafting(new MaterialCraftingData(Ingredient.of((ItemLike)Items.BAMBOO_PLANKS), List.of(MaterialCategories.ORGANIC, MaterialCategories.WOOD, MaterialCategories.BASIC), List.of(), Map.of((PartType)PartTypes.ROD.get(), Ingredient.of((ItemLike)Items.BAMBOO)), true)).displayWithDefaultName(10142050, TextureType.LOW_CONTRAST).mainStatsCommon(65.0f, 9.0f, 15.0f, 4.0f, 0.7f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.25f).mainStatsHarvest(2.0f).mainStatsMelee(0.0f, 0.0f, 0.0f).stat(PartGearKey.ofMain(GearTypes.AXE), GearProperties.ATTACK_SPEED, -0.2f).stat(PartGearKey.ofMain(GearTypes.HOE), GearProperties.ATTACK_SPEED, -2.0f).mainStatsRanged(0.0f, 0.0f, 1.0f, 0.9f).mainStatsArmor(1.0f, 3.0f, 2.0f, 1.0f, 0.0f, 2.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLAMMABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]));
    }

    private void addClothLikes(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("phantom_membrane")).crafting((ItemLike)Items.PHANTOM_MEMBRANE, MaterialCategories.ORGANIC, MaterialCategories.CLOTH, MaterialCategories.INTERMEDIATE).displayWithDefaultName(12827041, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 12.0f, 10.0f, 35.0f, 0.7f).stat(PartGearKey.ofMain(GearTypes.ELYTRA), GearProperties.ARMOR_DURABILITY, 17.0f).mainStatsArmor(1.0f, 2.0f, 2.0f, 1.0f, 0.0f, 8.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.RENEW, 2, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.REPAIR_EFFICIENCY, 0.15f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.ATTACK_SPEED, 0.2f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.GRIP, Const.Traits.ANCIENT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.LIGHT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("fine_silk_cloth")).crafting(CraftingItems.FINE_SILK_CLOTH, MaterialCategories.ORGANIC, MaterialCategories.CLOTH, MaterialCategories.INTERMEDIATE).displayWithDefaultName(12827041, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 14.0f, 14.0f, 40.0f, 0.9f).stat(PartGearKey.ofMain(GearTypes.ELYTRA), GearProperties.ARMOR_DURABILITY, 18.0f).mainStatsArmor(1.0f, 2.0f, 2.0f, 1.0f, 0.0f, 14.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SNOW_WALKER, 1, new GearTypeTraitCondition((Supplier<GearType>)GearTypes.BOOTS)).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.REPAIR_EFFICIENCY, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.HARVEST_SPEED, 0.15f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.GRIP, Const.Traits.ACCELERATE, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.LINING, GearProperties.MAGIC_ARMOR, 2.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("leather")).crafting(this.items, (TagKey<Item>)Tags.Items.LEATHERS, MaterialCategories.ORGANIC, MaterialCategories.CLOTH, MaterialCategories.BASIC).displayWithDefaultName(8409395, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 5.0f, 15.0f, 11.0f, 0.8f).mainStatsArmor(1.0f, 3.0f, 2.0f, 1.0f, 0.0f, 8.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SNOW_WALKER, 1, new GearTypeTraitCondition((Supplier<GearType>)GearTypes.BOOTS)).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.REPAIR_EFFICIENCY, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.HARVEST_SPEED, 0.15f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.ATTACK_SPEED, 0.15f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.GRIP, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(Const.Materials.WOOL).crafting(this.items, (TagKey<Item>)ItemTags.WOOL, MaterialCategories.ORGANIC, MaterialCategories.CLOTH, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 4.0f, 7.0f, 7.0f, 0.7f).mainStatsArmor(0.5f, 2.0f, 1.0f, 0.5f, 0.0f, 4.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SNOW_WALKER, 1, new GearTypeTraitCondition((Supplier<GearType>)GearTypes.BOOTS)).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.REPAIR_EFFICIENCY, 0.2f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.GRIP, GearProperties.ATTACK_SPEED, 0.2f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.GRIP, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.LINING, GearProperties.KNOCKBACK_RESISTANCE, 0.1f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialsProvider.wool("black", (ItemLike)Items.BLACK_WOOL, 1316121));
        ret.add(MaterialsProvider.wool("blue", (ItemLike)Items.BLUE_WOOL, 3488157));
        ret.add(MaterialsProvider.wool("brown", (ItemLike)Items.BROWN_WOOL, 7489320));
        ret.add(MaterialsProvider.wool("cyan", (ItemLike)Items.CYAN_WOOL, 1411473));
        ret.add(MaterialsProvider.wool("gray", (ItemLike)Items.GRAY_WOOL, 4080711));
        ret.add(MaterialsProvider.wool("green", (ItemLike)Items.GREEN_WOOL, 5532955));
        ret.add(MaterialsProvider.wool("light_blue", (ItemLike)Items.LIGHT_BLUE_WOOL, 3846105));
        ret.add(MaterialsProvider.wool("light_gray", (ItemLike)Items.LIGHT_GRAY_WOOL, 0x8E8E86));
        ret.add(MaterialsProvider.wool("lime", (ItemLike)Items.LIME_WOOL, 7387417));
        ret.add(MaterialsProvider.wool("magenta", (ItemLike)Items.MAGENTA_WOOL, 12403891));
        ret.add(MaterialsProvider.wool("orange", (ItemLike)Items.ORANGE_WOOL, 15758867));
        ret.add(MaterialsProvider.wool("pink", (ItemLike)Items.PINK_WOOL, 15568300));
        ret.add(MaterialsProvider.wool("purple", (ItemLike)Items.PURPLE_WOOL, 7940780));
        ret.add(MaterialsProvider.wool("red", (ItemLike)Items.RED_WOOL, 10561314));
        ret.add(MaterialsProvider.wool("white", (ItemLike)Items.WHITE_WOOL, 0xE9ECEC));
        ret.add(MaterialsProvider.wool("yellow", (ItemLike)Items.YELLOW_WOOL, 16303655));
    }

    private void addStringsAndFibers(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("fine_silk")).crafting(CraftingItems.FINE_SILK, MaterialCategories.ORGANIC, MaterialCategories.FIBER, MaterialCategories.BASIC).displayWithDefaultName(0xCCFFFF, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.MAGIC_ARMOR, 2.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.LUCKY, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.RANGED_DAMAGE, 0.07f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.CORD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("flax")).crafting(CraftingItems.FLAX_STRING, MaterialCategories.ORGANIC, MaterialCategories.FIBER, MaterialCategories.BASIC).displayWithDefaultName(8674871, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.ARMOR_DURABILITY, 0.05f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.HARVEST_SPEED, 0.05f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.RANGED_DAMAGE, -0.1f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.DRAW_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_BASE));
        ret.add(MaterialBuilder.simple(this.modId("fluffy_string")).crafting(CraftingItems.FLUFFY_STRING, MaterialCategories.ORGANIC, MaterialCategories.FIBER, MaterialCategories.BASIC).displayWithDefaultName(16775909, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.ARMOR_DURABILITY, 0.05f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.HARVEST_SPEED, -0.05f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.FLEXIBLE, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.RANGED_DAMAGE, 0.05f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.DRAW_SPEED, -0.05f, NumberProperty.Operation.MULTIPLY_BASE));
        ret.add(MaterialBuilder.simple(this.modId("sinew")).crafting(CraftingItems.SINEW_FIBER, MaterialCategories.ORGANIC, MaterialCategories.FIBER, MaterialCategories.BASIC).displayWithDefaultName(14195035, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.REPAIR_EFFICIENCY, -0.05f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.RANGED_DAMAGE, 0.2f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.CORD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("string")).crafting((ItemLike)Items.STRING, MaterialCategories.ORGANIC, MaterialCategories.FIBER, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.REPAIR_EFFICIENCY, 0.05f, NumberProperty.Operation.MULTIPLY_BASE).trait((Supplier<PartType>)PartTypes.BINDING, Const.Traits.FLEXIBLE, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.DRAW_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_BASE));
        ret.add(MaterialBuilder.simple(this.modId("vine")).crafting((ItemLike)Items.VINE, MaterialCategories.ORGANIC, MaterialCategories.BASIC).displayWithDefaultName(32526, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.BINDING, GearProperties.REPAIR_EFFICIENCY, 0.03f, NumberProperty.Operation.MULTIPLY_BASE).stat((Supplier<PartType>)PartTypes.CORD, GearProperties.RANGED_DAMAGE, -0.1f, NumberProperty.Operation.MULTIPLY_BASE));
    }

    private void addRandomOrganics(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("feather")).crafting(this.items, (TagKey<Item>)Tags.Items.FEATHERS, MaterialCategories.ORGANIC, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 2.0f, 9.0f, 1.0f, 1.1f).mainStatsArmor(0.5f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLUTTER, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_SPEED, 0.9f).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_ACCURACY, 1.1f));
        ret.add(MaterialBuilder.simple(this.modId("leaves")).crafting(this.items, (TagKey<Item>)ItemTags.LEAVES, MaterialCategories.ORGANIC, MaterialCategories.BASIC).displayWithDefaultName(4886312, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 2.0f, 12.0f, 1.0f, 1.1f).mainStatsArmor(0.5f, 1.0f, 1.0f, 0.5f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLAMMABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LIGHT, 1, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_SPEED, 1.1f).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_ACCURACY, 0.9f));
        ret.add(MaterialBuilder.simple(this.modId("paper")).crafting(this.items, SgTags.Items.PAPER, MaterialCategories.ORGANIC, MaterialCategories.SHEET, MaterialCategories.BASIC).displayWithDefaultName(0xFFFFFF, TextureType.LOW_CONTRAST).mainStatsCommon(0.0f, 2.0f, 11.0f, 3.0f, 1.0f).mainStatsArmor(1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLAMMABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.RUSTIC, 3, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_SPEED, 1.1f).stat((Supplier<PartType>)PartTypes.FLETCHING, GearProperties.PROJECTILE_ACCURACY, 0.9f));
        ret.add(MaterialBuilder.simple(this.modId("slime")).crafting((ItemLike)Items.SLIME_BLOCK, MaterialCategories.SLIME, MaterialCategories.ORGANIC, MaterialCategories.INTERMEDIATE).displayWithDefaultName(9230210, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.LINING, GearProperties.ARMOR_TOUGHNESS, 0.5f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.LINING, Const.Traits.BOUNCE, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("turtle")).crafting((ItemLike)Items.TURTLE_SCUTE, MaterialCategories.ORGANIC, MaterialCategories.INTERMEDIATE).displayWithDefaultName(4702026, TextureType.LOW_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 0.0f).stat(PartGearKey.ofMain(GearTypes.HELMET), GearProperties.ARMOR_DURABILITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 9.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 20.0f).mainStatsArmor(2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 4.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.TURTLE, 1, new MaterialCountTraitCondition(2)));
    }

    private void addCompounds(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(this.compoundBuilder(this.modId("crude_alloy"), (ItemLike)SgItems.CRUDE_ALLOY));
        ret.add(this.compoundBuilder(this.modId("hybrid_gem"), (ItemLike)SgItems.HYBRID_GEM));
        ret.add(this.compoundBuilder(this.modId("metal_alloy"), (ItemLike)SgItems.ALLOY_INGOT));
        ret.add(this.compoundBuilder(this.modId("mixed_fabric"), (ItemLike)SgItems.MIXED_FABRIC));
        ret.add(this.compoundBuilder(this.modId("super_alloy"), (ItemLike)SgItems.SUPER_ALLOY));
        ret.add(this.customCompoundBuilder(this.modId("dimerald"), (CustomMaterialItem)SgItems.CUSTOM_GEM.get(), MaterialCategories.GEM, MaterialCategories.ADVANCED).displayWithDefaultName(1756802, TextureType.HIGH_CONTRAST).mainStatsCommon(1776.0f, 36.0f, 12.0f, 80.0f, 0.7f).mainStatsHarvest(BuiltinMaterials.DIMERALD.getHarvestTier(), 9.0f).mainStatsMelee(3.0f, 3.0f, 0.1f).mainStatsRanged(3.0f, 0.1f, 1.0f, 1.2f).mainStatsArmor(4.0f, 9.0f, 6.0f, 3.0f, 10.0f, 10.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.BRITTLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.GOLD_DIGGER, 2, MaterialsProvider.materialCountOrRatio(3, 0.5f)).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.15f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.BRITTLE, 1, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.ANCIENT, 3, new MaterialRatioTraitCondition(0.5f)).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 360.0f, NumberProperty.Operation.ADD).harvestTierBuiltin((Supplier<PartType>)PartTypes.TIP).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.MAGIC_DAMAGE, 1.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RANGED_DAMAGE, 0.5f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.RARITY, 25.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.IMPERIAL, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.SETTING, Const.Traits.KITTY_VISION, 1, new ITraitCondition[0]));
        ret.add(this.customCompoundBuilder(this.modId("high_carbon_steel"), (CustomMaterialItem)SgItems.CUSTOM_INGOT.get(), MaterialCategories.METAL, MaterialCategories.ADVANCED).displayWithDefaultName(0x848484, TextureType.HIGH_CONTRAST).mainStatsCommon(420.0f, 24.0f, 11.0f, 40.0f, 0.8f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.05f).mainStatsHarvest(BuiltinMaterials.HIGH_CARBON_STEEL.getHarvestTier(), 6.0f).mainStatsMelee(4.0f, 1.0f, -0.2f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 2.0f, 6.0f).mainStatsRanged(2.0f, -0.2f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
    }

    private void addSimpleRods(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(MaterialBuilder.simple(this.modId("blaze_rod")).crafting(new MaterialCraftingData(Optional.empty(), List.of(MaterialCategories.METAL), List.of(), Map.of((PartType)PartTypes.ROD.get(), this.taggedItems((TagKey<Item>)Tags.Items.RODS_BLAZE)), true)).displayWithDefaultName(16762368, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.REACH, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.builtin(BuiltinMaterials.BONE).crafting(new MaterialCraftingData(Ingredient.of((ItemLike)Items.BONE_BLOCK), List.of(MaterialCategories.ORGANIC, MaterialCategories.BASIC), List.of(), Map.of((PartType)PartTypes.ROD.get(), Ingredient.of((ItemLike)Items.BONE)), true)).displayWithDefaultName(16579565, TextureType.LOW_CONTRAST).mainStatsCommon(108.0f, 4.0f, 5.0f, 8.0f, 0.9f).mainStatsHarvest(4.0f).mainStatsMelee(2.0f, 1.0f, 0.1f).mainStatsRanged(1.0f, 0.0f, 0.9f, 1.0f).mainStatsArmor(1.0f, 2.0f, 1.0f, 1.0f, 0.0f, 1.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.CHIPPING, 2, new ITraitCondition[0]).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("breeze_rod")).crafting(new MaterialCraftingData(Optional.empty(), List.of(MaterialCategories.METAL), List.of(), Map.of((PartType)PartTypes.ROD.get(), this.taggedItems((TagKey<Item>)Tags.Items.RODS_BREEZE)), true)).displayWithDefaultName(9672897, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.WIND_BLAST, 1, new ITraitCondition[0]));
        ret.add(MaterialBuilder.simple(this.modId("end_rod")).crafting(new MaterialCraftingData(Optional.empty(), List.of(MaterialCategories.METAL), List.of(), Map.of((PartType)PartTypes.ROD.get(), Ingredient.of((ItemLike)Items.END_ROD)), true)).displayWithDefaultName(16179917, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.STURDY, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.REFRACTIVE, 1, new ITraitCondition[0]));
    }

    private void addExtraMetals(Collection<MaterialBuilder<?>> ret, HolderLookup.Provider registries) {
        ret.add(this.extraMetal(ExtraMetals.ALUMINUM, 2).displayWithDefaultName(12571870, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 365.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.2f).mainStatsArmor(2.0f, 6.0f, 4.0f, 2.0f, 0.5f, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.9f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 30.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SYNERGISTIC, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SYNERGISTIC, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.ALUMINUM_STEEL, 3).displayWithDefaultName(10017242, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 660.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 18.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 11.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(3.0f, 7.0f, 5.0f, 3.0f, 2.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 45.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.0f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 45.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SYNERGISTIC, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SYNERGISTIC, 3, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.BISMUTH, 2).displayWithDefaultName(13746901, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 330.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 5.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 3.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(3.0f, 6.0f, 5.0f, 2.0f, 2.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 35.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.9f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 35.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.BISMUTH_BRASS, 2).displayWithDefaultName(15319476, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 580.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 9.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(3.0f, 7.0f, 5.0f, 3.0f, 2.0f, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.1f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 50.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.BISMUTH_STEEL, 3).displayWithDefaultName(14458855, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 1050.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 5.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, -0.1f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 4.0f, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.1f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 60.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.0f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.15f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 60.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.BRASS, 2).displayWithDefaultName(15914072, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 240.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 13.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 7.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(2.0f, 6.0f, 4.0f, 2.0f, 1.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.2f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 25.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SILKY, 1, new MaterialRatioTraitCondition(0.66f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.COMPRESSED_IRON, 3).displayWithDefaultName(0xA6A6A6, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 1024.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 24.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 9.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, -0.2f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 2.0f, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.ELECTRUM, 2).displayWithDefaultName(14082103, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 96.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 5.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.3f).mainStatsArmor(2.0f, 6.0f, 5.0f, 2.0f, 0.0f, 11.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.4f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.5f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_SPEED, 0.1f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DRAW_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.LUSTROUS, 3, new MaterialRatioTraitCondition(0.5f)));
        ret.add(this.extraMetal(ExtraMetals.ENDERIUM, 4).displayWithDefaultName(4623477, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 1200.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 34.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 13.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.NETHERITE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 18.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(3.0f, 9.0f, 7.0f, 3.0f, 8.0f, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 80.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.2f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 60.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.INVAR, 2).displayWithDefaultName(12766136, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 640.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 13.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 7.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 3.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(2.0f, 8.0f, 6.0f, 2.0f, 2.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.2f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 50.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ADAMANT, 2, MaterialsProvider.materialCountOrRatio(3, 0.35f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.LEAD, 2).displayWithDefaultName(12766136, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 260.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, -0.4f).mainStatsArmor(2.0f, 5.0f, 4.0f, 2.0f, 0.0f, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, -0.3f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.AQUATIC, 2, MaterialsProvider.materialCountOrRatio(3, 0.35f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 4, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.LUMIUM, 3).displayWithDefaultName(16766857, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 920.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.2f).mainStatsArmor(2.0f, 8.0f, 6.0f, 2.0f, 4.0f, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 75.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.3f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 75.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.REFRACTIVE, 1, new MaterialRatioTraitCondition(0.5f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.REFRACTIVE, 1, new MaterialRatioTraitCondition(0.5f)));
        ret.add(this.extraMetal(ExtraMetals.NICKEL, 2).displayWithDefaultName(15722619, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 380.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 17.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 7.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(2.0f, 5.0f, 4.0f, 2.0f, 0.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 0.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.1f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.0f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ADAMANT, 1, MaterialsProvider.materialCountOrRatio(3, 0.35f)).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.OSMIUM, 2).displayWithDefaultName(9610936, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 500.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 30.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(3.0f, 6.0f, 5.0f, 3.0f, 0.0f, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 35.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.1f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.REPAIR_EFFICIENCY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 35.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.PLATINUM, 3).displayWithDefaultName(0xB3B3FF, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 900.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 21.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(2.0f, 8.0f, 6.0f, 2.0f, 2.0f, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 80.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.2f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.REPAIR_EFFICIENCY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 70.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 4, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.REDSTONE_ALLOY, 2).displayWithDefaultName(0xE60006, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 840.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 18.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 11.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.2f).mainStatsArmor(3.0f, 7.0f, 5.0f, 2.0f, 1.0f, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 45.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.9f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 45.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.ERODED, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.REFINED_GLOWSTONE, 3).displayWithDefaultName(16638036, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 300.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 18.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 18.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 14.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 5.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(3.0f, 7.0f, 6.0f, 3.0f, 0.0f, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 45.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 45.0f).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.HARVEST_SPEED, 5.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.LUSTROUS, 1, new MaterialRatioTraitCondition(0.75f)).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.REFRACTIVE, 1, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.REFINED_IRON, 2).displayWithDefaultName(0xD7D7D7, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 512.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 7.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(3.0f, 7.0f, 5.0f, 3.0f, 2.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.15f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RANGED_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 25.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.STELLAR, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 4, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.REFINED_OBSIDIAN, 4).displayWithDefaultName(6706306, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 2500.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.3f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.3f).mainStatsArmor(5.0f, 12.0f, 8.0f, 5.0f, 16.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 70.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 70.0f).stat((Supplier<PartType>)PartTypes.TIP, GearProperties.DURABILITY, 600.0f, NumberProperty.Operation.ADD).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.HARD, 3, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.TIP, Const.Traits.VULCAN, 1, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.SIGNALUM, 4).displayWithDefaultName(16735784, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 800.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 25.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 16.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 13.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(2.0f, 7.0f, 5.0f, 2.0f, 2.0f, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.2f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.3f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.REPAIR_EFFICIENCY, -0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 50.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.LUSTROUS, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.LUSTROUS, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.SILVER, 2).displayWithDefaultName(13356266, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 64.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 9.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.GOLD).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 11.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.2f).mainStatsArmor(2.0f, 5.0f, 3.0f, 1.0f, 0.0f, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.3f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.1f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.MAGIC_DAMAGE, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.STEEL, 2).displayWithDefaultName(0x929292, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 500.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, 0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 11.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.IRON).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, -0.2f).mainStatsArmor(3.0f, 8.0f, 6.0f, 3.0f, 2.0f, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, -0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 40.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 0.8f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.25f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 5, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 5, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.TIN, 1).displayWithDefaultName(9020852, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 192.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 13.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.STONE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 5.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(2.0f, 5.0f, 3.0f, 2.0f, 0.0f, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 0.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.1f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_SPEED, 0.2f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 15.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 1, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.TITANIUM, 4).displayWithDefaultName(3034342, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 1600.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 37.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 12.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.NETHERITE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 8.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(4.0f, 9.0f, 7.0f, 4.0f, 8.0f, 4.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, -0.2f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 80.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.0f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.2f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 2.0f, NumberProperty.Operation.ADD).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 80.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.HARD, 4, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.FLEXIBLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.HARD, 4, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.URANIUM, 3).displayWithDefaultName(2227983, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 800.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 20.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.REPAIR_VALUE, -0.15f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 17.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.DIAMOND).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 6.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.1f).mainStatsArmor(2.0f, 5.0f, 4.0f, 2.0f, 1.0f, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 0.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.1f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 50.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.5f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.HARVEST_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DRAW_SPEED, 0.1f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 40.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]));
        ret.add(this.extraMetal(ExtraMetals.ZINC, 1).displayWithDefaultName(13226958, TextureType.HIGH_CONTRAST).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DURABILITY, 192.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ARMOR_DURABILITY, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ENCHANTMENT_VALUE, 15.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_TIER, HarvestTier.STONE).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.HARVEST_SPEED, 3.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_DAMAGE, 1.5f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.MAGIC_DAMAGE, 1.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.ATTACK_SPEED, 0.0f).mainStatsArmor(1.0f, 5.0f, 3.0f, 1.0f, 0.0f, 2.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RANGED_DAMAGE, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.DRAW_SPEED, 0.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.RARITY, 10.0f).stat((Supplier<PartType>)PartTypes.MAIN, GearProperties.CHARGING_VALUE, 1.1f).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.DURABILITY, -0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.ATTACK_DAMAGE, 0.05f, NumberProperty.Operation.MULTIPLY_TOTAL).stat((Supplier<PartType>)PartTypes.ROD, GearProperties.RARITY, 15.0f).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.MALLEABLE, 1, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.MAIN, Const.Traits.SOFT, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.MALLEABLE, 2, new ITraitCondition[0]).trait((Supplier<PartType>)PartTypes.ROD, Const.Traits.SOFT, 3, new ITraitCondition[0]));
    }

    protected MaterialBuilder<CompoundMaterial> compoundBuilder(DataResource<Material> material, ItemLike item) {
        return new MaterialBuilder<CompoundMaterial>(material.getId(), (parent, crafting, display, __) -> new CompoundMaterial(parent, crafting, display)).crafting(item, new IMaterialCategory[0]);
    }

    protected MaterialBuilder<CustomCompoundMaterial> customCompoundBuilder(DataResource<Material> material, CustomMaterialItem item, IMaterialCategory ... categories) {
        return MaterialBuilder.customCompound(material).crafting(new Ingredient((ICustomIngredient)CustomAlloyIngredient.of(item, material)), categories);
    }

    private MaterialBuilder<SimpleMaterial> extraMetal(ExtraMetals metal, int tier) {
        String name = metal.getName();
        MaterialCategories tierCategory = List.of(MaterialCategories.BASIC, MaterialCategories.BASIC, MaterialCategories.INTERMEDIATE, MaterialCategories.ADVANCED, MaterialCategories.ENDGAME).get(tier);
        TagKey<Item> materialTag = metal.getMainTag();
        TagKey<Item> rodTag = metal.getRodTag();
        return MaterialBuilder.simple(DataResource.material(SilentGear.getId(name))).crafting(new MaterialCraftingData(OptionalTagIngredient.create(this.items, materialTag), List.of(MaterialCategories.METAL, tierCategory), List.of(), Map.of((PartType)PartTypes.ROD.get(), OptionalTagIngredient.create(this.items, rodTag)), true));
    }

    private static MaterialBuilder<SimpleMaterial> terracotta(DataResource<Material> parent, String suffix, ItemLike item, int color) {
        Identifier id = Identifier.fromNamespaceAndPath((String)parent.getId().getNamespace(), (String)(parent.getId().getPath() + "/" + suffix));
        return MaterialBuilder.simple(DataResource.material(id)).parent(parent).crafting(item, new IMaterialCategory[0]).displayWithDefaultName(color, TextureType.LOW_CONTRAST);
    }

    private static MaterialBuilder<SimpleMaterial> wood(String suffix, ItemLike item, int color) {
        DataResource<Material> parent = Const.Materials.WOOD;
        Identifier id = Identifier.fromNamespaceAndPath((String)parent.getId().getNamespace(), (String)(parent.getId().getPath() + "/" + suffix));
        return MaterialBuilder.simple(DataResource.material(id)).parent(parent).crafting(item, new IMaterialCategory[0]).displayWithDefaultName(color, TextureType.LOW_CONTRAST);
    }

    private static MaterialBuilder<SimpleMaterial> wool(String suffix, ItemLike item, int color) {
        DataResource<Material> parent = Const.Materials.WOOL;
        Identifier id = Identifier.fromNamespaceAndPath((String)parent.getId().getNamespace(), (String)(parent.getId().getPath() + "/" + suffix));
        return MaterialBuilder.simple(DataResource.material(id)).parent(parent).crafting(item, new IMaterialCategory[0]).displayWithDefaultName(color, TextureType.LOW_CONTRAST);
    }

    protected static ITraitCondition materialCountOrRatio(int count, float ratio) {
        return new OrTraitCondition(new MaterialCountTraitCondition(count), new MaterialRatioTraitCondition(ratio));
    }

    private Ingredient taggedItems(TagKey<Item> tag) {
        return Ingredient.of((HolderSet)this.items.getOrThrow(tag));
    }
}

