/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.setup.SgItemTintSources;
import net.silentchaos512.gear.data.client.ModItemModelProvider;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.setup.SgRegistries;

public class GearItemModelBuilder {
    private static final List<TextureSlot> TEXTURE_SLOTS = List.of(TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ModItemModelProvider.ExtraSlots.LAYER3, ModItemModelProvider.ExtraSlots.LAYER4, ModItemModelProvider.ExtraSlots.LAYER5);
    private static final List<ModelTemplate> MODEL_TEMPLATES = List.of(ModelTemplates.FLAT_HANDHELD_ITEM, ModItemModelProvider.ExtraModelTemplates.TWO_LAYERED_HANDHELD_ITEM, ModItemModelProvider.ExtraModelTemplates.THREE_LAYERED_HANDHELD_ITEM, ModItemModelProvider.ExtraModelTemplates.FOUR_LAYERED_HANDHELD_ITEM, ModItemModelProvider.ExtraModelTemplates.FIVE_LAYERED_HANDHELD_ITEM, ModItemModelProvider.ExtraModelTemplates.SIX_LAYERED_HANDHELD_ITEM);
    private static final List<ModelTemplate> ROD_MODEL_TEMPLATES = List.of(ModelTemplates.FLAT_HANDHELD_ROD_ITEM, ModItemModelProvider.ExtraModelTemplates.TWO_LAYERED_HANDHELD_ROD_ITEM, ModItemModelProvider.ExtraModelTemplates.THREE_LAYERED_HANDHELD_ROD_ITEM, ModItemModelProvider.ExtraModelTemplates.FOUR_LAYERED_HANDHELD_ROD_ITEM, ModItemModelProvider.ExtraModelTemplates.FIVE_LAYERED_HANDHELD_ROD_ITEM, ModItemModelProvider.ExtraModelTemplates.SIX_LAYERED_HANDHELD_ROD_ITEM);
    private final GearItemSet<? extends GearItem> itemSet;
    private final Identifier typeKey;
    private final Map<PartType, Identifier> layers = new LinkedHashMap<PartType, Identifier>();
    private final Map<PartType, ItemTintSource> tints = new HashMap<PartType, ItemTintSource>();
    private final Function<Integer, ModelTemplate> modelTemplateGetter;

    public GearItemModelBuilder(GearItemSet<? extends GearItem> itemSet, Function<Integer, ModelTemplate> modelTemplateGetter) {
        this.itemSet = itemSet;
        this.typeKey = Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)this.itemSet.type()));
        this.modelTemplateGetter = modelTemplateGetter;
    }

    public static GearItemModelBuilder handheldItem(GearItemSet<? extends GearItem> itemSet) {
        return new GearItemModelBuilder(itemSet, MODEL_TEMPLATES::get);
    }

    public static GearItemModelBuilder handheldRodItem(GearItemSet<? extends GearItem> itemSet) {
        return new GearItemModelBuilder(itemSet, ROD_MODEL_TEMPLATES::get);
    }

    public static GearItemModelBuilder unique(GearItemSet<? extends GearItem> itemSet, Function<Integer, ModelTemplate> layerCountToModelTemplate) {
        return new GearItemModelBuilder(itemSet, layerCountToModelTemplate);
    }

    public GearItemModelBuilder simpleLayer(Supplier<PartType> partType, String texturePath) {
        Identifier texture = Identifier.fromNamespaceAndPath((String)this.typeKey.getNamespace(), (String)("item/" + this.typeKey.getPath() + "/" + texturePath));
        this.layers.put(partType.get(), texture);
        return this;
    }

    public GearItemModelBuilder tintedLayer(Supplier<PartType> partType, String texturePath) {
        Identifier texture = Identifier.fromNamespaceAndPath((String)this.typeKey.getNamespace(), (String)("item/" + this.typeKey.getPath() + "/" + texturePath));
        this.layers.put(partType.get(), texture);
        this.tints.put(partType.get(), SgItemTintSources.gearPartColor(partType));
        return this;
    }

    public void generateModel(ItemModelOutput itemModelOutput, BiConsumer<Identifier, ModelInstance> modelOutput) {
        TextureMapping textureMapping = new TextureMapping();
        ArrayList<ItemTintSource> tintSourceList = new ArrayList<ItemTintSource>();
        int i = 0;
        for (PartType partType : this.layers.keySet()) {
            textureMapping.put(TEXTURE_SLOTS.get(i), this.layers.get(partType));
            tintSourceList.add(this.tints.getOrDefault(partType, ItemModelGenerators.BLANK_LAYER));
            if (++i < TEXTURE_SLOTS.size()) continue;
            throw new IllegalStateException("Too many layers for gear model");
        }
        ModelTemplate modelTemplate = this.modelTemplateGetter.apply(this.layers.size() - 1);
        Identifier modelKey = modelTemplate.create((Item)this.itemSet.gearItem(), textureMapping, modelOutput);
        itemModelOutput.accept((Item)this.itemSet.gearItem(), ItemModelUtils.tintedModel((Identifier)modelKey, (ItemTintSource[])tintSourceList.toArray(new ItemTintSource[0])));
    }
}

