/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.block.ModCropBlock;
import net.silentchaos512.gear.data.SgBlockFamilies;
import net.silentchaos512.gear.setup.SgBlocks;

public class ModBlockModelGenerator
extends BlockModelGenerators {
    public ModBlockModelGenerator(Consumer<BlockModelDefinitionGenerator> blockStateOutput, ItemModelOutput itemModelOutput, BiConsumer<Identifier, ModelInstance> modelOutput) {
        super(blockStateOutput, itemModelOutput, modelOutput);
    }

    public void run() {
        this.createTrivialCube((Block)SgBlocks.BORT_ORE.get());
        this.createTrivialCube((Block)SgBlocks.DEEPSLATE_BORT_ORE.get());
        this.createTrivialCube((Block)SgBlocks.CRIMSON_IRON_ORE.get());
        this.createTrivialCube((Block)SgBlocks.BLACKSTONE_CRIMSON_IRON_ORE.get());
        this.createTrivialCube((Block)SgBlocks.AZURE_SILVER_ORE.get());
        this.createTrivialCube((Block)SgBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.BORT_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.CRIMSON_IRON_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.CRIMSON_STEEL_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.BLAZE_GOLD_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.AZURE_SILVER_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.TYRIAN_STEEL_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.NETHERWOOD_LEAVES.get());
        this.woodProvider((Block)SgBlocks.NETHERWOOD_LOG.get()).logWithHorizontal((Block)SgBlocks.NETHERWOOD_LOG.get()).wood((Block)SgBlocks.NETHERWOOD_WOOD.get());
        this.woodProvider((Block)SgBlocks.STRIPPED_NETHERWOOD_LOG.get()).logWithHorizontal((Block)SgBlocks.STRIPPED_NETHERWOOD_LOG.get()).wood((Block)SgBlocks.STRIPPED_NETHERWOOD_WOOD.get());
        this.createPlantWithDefaultItem((Block)SgBlocks.NETHERWOOD_SAPLING.get(), (Block)SgBlocks.POTTED_NETHERWOOD_SAPLING.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        this.family((Block)SgBlocks.NETHERWOOD_PLANKS.get()).generateFor(SgBlockFamilies.NETHERWOOD.get());
        this.createTrivialCube((Block)SgBlocks.WHITE_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.LIME_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.PINK_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.GRAY_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.CYAN_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.BLUE_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.BROWN_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.GREEN_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.RED_FLUFFY_BLOCK.get());
        this.createTrivialCube((Block)SgBlocks.BLACK_FLUFFY_BLOCK.get());
        this.createPhantomLight();
        this.createNormalTorch((Block)SgBlocks.STONE_TORCH.get(), (Block)SgBlocks.WALL_STONE_TORCH.get());
        this.createSimpleCustomModel(SgBlocks.GEAR_SMITHING_TABLE, "block/gear_smithing_table");
        this.createSimpleCustomModel(SgBlocks.STARLIGHT_CHARGER, "block/starlight_charger");
        this.createSimpleCustomModel(SgBlocks.STONE_ANVIL, "block/stone_anvil");
        this.orientableMachineBlock(SgBlocks.MATERIAL_GRADER, "material_grader");
        this.orientableMachineBlock(SgBlocks.METAL_PRESS, "metal_press");
        this.orientableMachineBlock(SgBlocks.SALVAGER, "salvager");
        this.orientableMachineBlock(SgBlocks.ALLOY_FORGE, "alloy_forge");
        this.orientableMachineBlock(SgBlocks.RECRYSTALLIZER, "recrystallizer");
        this.orientableMachineBlock(SgBlocks.REFABRICATOR, "refabricator");
        this.orientableMachineBlockWithoutLitState(SgBlocks.CRUDE_MIXER, "crude_mixer");
        this.orientableMachineBlockWithoutLitState(SgBlocks.SUPER_MIXER, "super_mixer");
        this.createCropBlock((Block)SgBlocks.FLAX_PLANT.get(), (Property)ModCropBlock.AGE, new int[]{0, 0, 1, 1, 2, 2, 2, 3});
        this.createCropBlock((Block)SgBlocks.FLUFFY_PLANT.get(), (Property)ModCropBlock.AGE, new int[]{0, 0, 1, 1, 2, 2, 2, 3});
        this.createWildCrop(SgBlocks.WILD_FLAX_PLANT, "block/flax_plant_stage3");
        this.createWildCrop(SgBlocks.WILD_FLUFFY_PLANT, "block/fluffy_plant_stage3");
    }

    private void createSimpleCustomModel(DeferredBlock<?> block, String modelPath) {
        this.blockStateOutput.accept(ModBlockModelGenerator.createSimpleBlock((Block)((Block)block.get()), (MultiVariant)ModBlockModelGenerator.plainVariant((Identifier)SilentGear.getId(modelPath))));
    }

    private void createPhantomLight() {
        ItemModel.Unbaked itemModel = ItemModelUtils.plainModel((Identifier)this.createFlatItemModel(SgBlocks.PHANTOM_LIGHT.asItem()));
        this.itemModelOutput.accept(SgBlocks.PHANTOM_LIGHT.asItem(), itemModel);
    }

    private void createWildCrop(DeferredBlock<?> block, String texturePath) {
        MultiVariant multivariant = ModBlockModelGenerator.plainVariant((Identifier)BlockModelGenerators.PlantType.NOT_TINTED.getCross().create((Block)block.get(), TextureMapping.cross((Identifier)SilentGear.getId(texturePath)), this.modelOutput));
        this.blockStateOutput.accept(ModBlockModelGenerator.createSimpleBlock((Block)((Block)block.get()), (MultiVariant)multivariant));
    }

    private void orientableMachineBlock(DeferredBlock<? extends Block> block, String name) {
        MultiVariant offModel = ModBlockModelGenerator.plainVariant((Identifier)SilentGear.getId("block/" + name));
        MultiVariant onModel = ModBlockModelGenerator.plainVariant((Identifier)SilentGear.getId("block/" + name + "_on"));
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)block.get())).with(ModBlockModelGenerator.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)onModel, (MultiVariant)offModel)).with(ROTATION_HORIZONTAL_FACING));
    }

    private void orientableMachineBlockWithoutLitState(DeferredBlock<? extends Block> block, String name) {
        MultiVariant model = ModBlockModelGenerator.plainVariant((Identifier)SilentGear.getId("block/" + name));
        this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)block.get()), (MultiVariant)model).with(ROTATION_HORIZONTAL_FACING));
    }
}

