/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.setup.SgItemTintSources;
import net.silentchaos512.gear.data.client.GearItemModelBuilder;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.GearItemSet;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.PartTypes;

public class ModItemModelProvider
extends ItemModelGenerators {
    public ModItemModelProvider(ItemModelOutput itemModelOutput, BiConsumer<Identifier, ModelInstance> modelOutput) {
        super(itemModelOutput, modelOutput);
    }

    public void run() {
        for (CraftingItems item2 : CraftingItems.values()) {
            this.flatItem(item2);
        }
        this.flatItem((ItemLike)SgItems.NETHERWOOD_CHARCOAL);
        this.generateWithTintedBaseLayer((ItemLike)SgItems.SHEET_METAL, "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.ALLOY_INGOT, "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.HYBRID_GEM, "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateTintedSingleLayer((ItemLike)SgItems.MIXED_FABRIC, SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.CRUDE_ALLOY, "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.SUPER_ALLOY, "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.CUSTOM_INGOT, "item/alloy_ingot", "_highlight", SgItemTintSources.blendedMaterialColor());
        this.generateWithTintedBaseLayer((ItemLike)SgItems.CUSTOM_GEM, "item/hybrid_gem", "_highlight", SgItemTintSources.blendedMaterialColor());
        this.layeredItem((ItemLike)SgItems.BLUEPRINT_BOOK, "item/blueprint_book_cover", "item/blueprint_book_pages", "item/blueprint_book_deco");
        this.flatItem((ItemLike)SgItems.JEWELER_TOOLS);
        SgItems.getItems(PartBlueprintItem.class).forEach(item -> {
            if (item.hasStandardModel()) {
                Identifier partTypeKey = SgRegistries.PART_TYPE.getKey((Object)item.getPartType());
                this.layeredItem((ItemLike)item, "item/" + (item.isSingleUse() ? "template" : "blueprint"), "item/blueprint_" + Objects.requireNonNull(partTypeKey).getPath());
            }
        });
        SgItems.getItems(GearBlueprintItem.class).forEach(item -> {
            Identifier gearTypeKey = SgRegistries.GEAR_TYPE.getKey((Object)item.gearType());
            this.layeredItem((ItemLike)item, "item/" + (item.isSingleUse() ? "template" : "blueprint"), "item/blueprint_" + Objects.requireNonNull(gearTypeKey).getPath());
        });
        this.flatItem((ItemLike)SgItems.MOD_KIT);
        this.flatItem((ItemLike)SgItems.VERY_CRUDE_REPAIR_KIT);
        this.flatItem((ItemLike)SgItems.CRUDE_REPAIR_KIT);
        this.flatItem((ItemLike)SgItems.STURDY_REPAIR_KIT);
        this.flatItem((ItemLike)SgItems.CRIMSON_REPAIR_KIT);
        this.flatItem((ItemLike)SgItems.AZURE_REPAIR_KIT);
        this.flatItem((ItemLike)SgItems.CRUDE_KNIFE);
        this.flatItem((ItemLike)SgItems.CRUDE_HAMMER);
        this.flatItem((ItemLike)SgItems.COATING_SMITHING_TEMPLATE);
        this.flatItem((ItemLike)SgItems.BLUEPRINT_PACKAGE);
        this.flatItem((ItemLike)SgItems.GOLDEN_NETHER_BANANA);
        this.flatItem((ItemLike)SgItems.NETHER_BANANA);
        this.flatItem((ItemLike)SgItems.PEBBLE);
        this.tempGearStandardTool(GearItemSets.SWORD);
        this.tempGearStandardTool(GearItemSets.KATANA);
        this.tempGearStandardTool(GearItemSets.MACHETE);
        this.tempGearStandardTool(GearItemSets.MACE);
        this.tempGearStandardTool(GearItemSets.KNIFE);
        this.tempGearStandardTool(GearItemSets.DAGGER);
        this.tempGearStandardTool(GearItemSets.PICKAXE);
        this.tempGearStandardTool(GearItemSets.SHOVEL);
        this.tempGearStandardTool(GearItemSets.AXE);
        this.tempGearStandardTool(GearItemSets.PAXEL);
        this.tempGearStandardTool(GearItemSets.HAMMER);
        this.tempGearStandardTool(GearItemSets.EXCAVATOR);
        this.gearSawItem(GearItemSets.SAW);
        this.tempGearStandardTool(GearItemSets.PROSPECTOR_HAMMER);
        this.tempGearStandardTool(GearItemSets.HOE);
        this.tempGearStandardTool(GearItemSets.MATTOCK);
        this.tempGearStandardTool(GearItemSets.SICKLE);
        this.tempGearStandardTool(GearItemSets.SHEARS);
        this.gearFishingRodItem(GearItemSets.FISHING_ROD);
        this.gearArrowItem(GearItemSets.ARROW);
        this.gearArmorItem(GearItemSets.HELMET);
        this.gearArmorItem(GearItemSets.CHESTPLATE);
        this.gearArmorItem(GearItemSets.LEGGINGS);
        this.gearArmorItem(GearItemSets.BOOTS);
        this.gearElytraItem(GearItemSets.ELYTRA);
        this.gearCurioItem(GearItemSets.RING);
        this.gearCurioItem(GearItemSets.BRACELET);
        this.gearCurioItem(GearItemSets.NECKLACE);
        this.mainPartItem(GearItemSets.SWORD);
        this.mainPartItem(GearItemSets.KATANA);
        this.mainPartItem(GearItemSets.MACHETE);
        this.mainPartItemNewTextureNames(GearItemSets.SPEAR);
        this.mainPartItem(GearItemSets.TRIDENT);
        this.mainPartItem(GearItemSets.MACE);
        this.mainPartItem(GearItemSets.KNIFE);
        this.mainPartItem(GearItemSets.DAGGER);
        this.mainPartItem(GearItemSets.PICKAXE);
        this.mainPartItem(GearItemSets.SHOVEL);
        this.mainPartItem(GearItemSets.AXE);
        this.mainPartItem(GearItemSets.PAXEL);
        this.mainPartItem(GearItemSets.HAMMER);
        this.mainPartItem(GearItemSets.EXCAVATOR);
        this.mainPartItem(GearItemSets.SAW);
        this.mainPartItem(GearItemSets.HOE);
        this.mainPartItem(GearItemSets.MATTOCK);
        this.mainPartItem(GearItemSets.PROSPECTOR_HAMMER);
        this.mainPartItem(GearItemSets.SICKLE);
        this.mainPartItem(GearItemSets.SHEARS);
        this.mainPartItem(GearItemSets.FISHING_ROD);
        this.mainPartItem(GearItemSets.BOW);
        this.mainPartItem(GearItemSets.CROSSBOW);
        this.mainPartItem(GearItemSets.SLINGSHOT);
        this.mainPartItem(GearItemSets.SHIELD);
        this.mainPartItem(GearItemSets.HELMET);
        this.mainPartItem(GearItemSets.CHESTPLATE);
        this.mainPartItem(GearItemSets.LEGGINGS);
        this.mainPartItem(GearItemSets.BOOTS);
        this.mainPartItem(GearItemSets.ELYTRA);
        this.mainPartItem(GearItemSets.ARROW);
        this.mainPartItem(GearItemSets.RING);
        this.mainPartItem(GearItemSets.BRACELET);
        this.mainPartItem(GearItemSets.NECKLACE);
        this.gearPartItem(SgItems.ROD);
        this.tipUpgradePartItem(SgItems.TIP);
        this.coatingPartItem(SgItems.COATING);
        this.gearPartItem(SgItems.GRIP);
        this.gearPartItem(SgItems.BINDING);
        this.gearPartItem(SgItems.LINING, "item/part/lining_cloth");
        this.gearPartItem(SgItems.CORD);
        this.gearPartItem(SgItems.FLETCHING);
        this.gearPartItem(SgItems.SETTING);
    }

    private void flatItem(ItemLike item) {
        this.generateFlatItem(item.asItem(), ModelTemplates.FLAT_ITEM);
    }

    private void generateWithTintedBaseLayer(ItemLike item, String overlaySuffix, ItemTintSource tintSource) {
        Identifier key = this.generateLayeredItem(item.asItem(), TextureMapping.getItemTexture((Item)item.asItem()), TextureMapping.getItemTexture((Item)item.asItem(), (String)overlaySuffix));
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.tintedModel((Identifier)key, (ItemTintSource[])new ItemTintSource[]{tintSource, BLANK_LAYER}));
    }

    private void generateWithTintedBaseLayer(ItemLike item, String texturePath, String overlaySuffix, ItemTintSource tintSource) {
        Identifier key = this.generateLayeredItem(item.asItem(), SilentGear.getId(texturePath), SilentGear.getId(texturePath + overlaySuffix));
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.tintedModel((Identifier)key, (ItemTintSource[])new ItemTintSource[]{tintSource, BLANK_LAYER}));
    }

    private void generateTintedSingleLayer(ItemLike item, ItemTintSource tintSource) {
        Identifier key = this.createFlatItemModel(item.asItem(), ModelTemplates.FLAT_ITEM);
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.tintedModel((Identifier)key, (ItemTintSource[])new ItemTintSource[]{tintSource}));
    }

    private void layeredItem(ItemLike item, String texture0, String texture1) {
        Identifier model = this.generateLayeredItem(item.asItem(), SilentGear.getId(texture0), SilentGear.getId(texture1));
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.plainModel((Identifier)model));
    }

    private void layeredItem(ItemLike item, String texture0, String texture1, String texture2) {
        Identifier model = ModelTemplates.THREE_LAYERED_ITEM.create(item.asItem(), TextureMapping.layered((Identifier)SilentGear.getId(texture0), (Identifier)SilentGear.getId(texture1), (Identifier)SilentGear.getId(texture2)), this.modelOutput);
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.plainModel((Identifier)model));
    }

    private void generateMaterialColoredItemWithOverlay(ItemLike item, String texturePath, String overlayTexture) {
        Identifier key = this.generateLayeredItem(item.asItem(), SilentGear.getId(texturePath), SilentGear.getId(overlayTexture));
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.tintedModel((Identifier)key, (ItemTintSource[])new ItemTintSource[]{SgItemTintSources.blendedMaterialColor(), BLANK_LAYER}));
    }

    private void generateMaterialColoredItemWithOverlay(ItemLike item, String texturePath, String overlayTexture1, String overlayTexture2) {
        Identifier key = ModelTemplates.THREE_LAYERED_ITEM.create(item.asItem(), TextureMapping.layered((Identifier)SilentGear.getId(texturePath), (Identifier)SilentGear.getId(overlayTexture1), (Identifier)SilentGear.getId(overlayTexture2)), this.modelOutput);
        this.itemModelOutput.accept(item.asItem(), ItemModelUtils.tintedModel((Identifier)key, (ItemTintSource[])new ItemTintSource[]{SgItemTintSources.blendedMaterialColor(), BLANK_LAYER}));
    }

    private String gearTypeName(GearType gearType) {
        return Objects.requireNonNull(SgRegistries.GEAR_TYPE.getKey((Object)gearType)).getPath();
    }

    private String itemNamePath(GearItemSet<?> itemSet) {
        return BuiltInRegistries.ITEM.getKey(itemSet.gearItem()).getPath();
    }

    private String itemNamePath(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).getPath();
    }

    private void tempGearStandardTool(GearItemSet<? extends GearItem> item) {
        this.tempGearStandardTool(item, true);
    }

    private void tempGearStandardTool(GearItemSet<? extends GearItem> itemSet, boolean buildMainModel) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.ROD, "rod_generic_lc").tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearBowItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.ROD, "rod_generic_lc").tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").tintedLayer((Supplier<PartType>)PartTypes.CORD, "bowstring_string").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearFishingRodItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldRodItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.ROD, "rod_generic_lc").tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").tintedLayer((Supplier<PartType>)PartTypes.CORD, "bowstring_string").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearSawItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.unique(itemSet, layers -> ExtraModelTemplates.THREE_LAYER_SAW_BASE).tintedLayer((Supplier<PartType>)PartTypes.ROD, "rod_generic_lc").tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearCurioItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").tintedLayer((Supplier<PartType>)PartTypes.SETTING, "adornment_generic").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearArmorItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearElytraItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").tintedLayer((Supplier<PartType>)PartTypes.BINDING, "binding_generic").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void gearArrowItem(GearItemSet<? extends GearItem> itemSet) {
        GearItemModelBuilder.handheldItem(itemSet).tintedLayer((Supplier<PartType>)PartTypes.ROD, "rod_generic_lc").tintedLayer((Supplier<PartType>)PartTypes.MAIN, "main_generic_hc").simpleLayer((Supplier<PartType>)PartTypes.NONE, "_highlight").tintedLayer((Supplier<PartType>)PartTypes.FLETCHING, "fletching_generic").generateModel(this.itemModelOutput, this.modelOutput);
    }

    private void mainPartItem(GearItemSet<? extends GearItem> item) {
        String name = this.gearTypeName(item.type());
        this.generateMaterialColoredItemWithOverlay((ItemLike)item.mainPart(), "item/" + name + "/main_generic_hc", "item/" + name + "/_highlight", "item/part_marker");
    }

    private void mainPartItemNewTextureNames(GearItemSet<? extends GearItem> item) {
        String name = this.gearTypeName(item.type());
        this.generateMaterialColoredItemWithOverlay((ItemLike)item.mainPart(), "item/" + name + "/main_hc", "item/" + name + "/icon_highlight", "item/part_marker");
    }

    private void gearPartItem(DeferredItem<CompoundPartItem> item) {
        String name = Objects.requireNonNull(SgRegistries.PART_TYPE.getKey((Object)((CompoundPartItem)((Object)item.get())).getPartType())).getPath();
        this.gearPartItem(item, "item/part/" + name);
    }

    private void gearPartItem(DeferredItem<CompoundPartItem> item, String texture) {
        this.generateMaterialColoredItemWithOverlay((ItemLike)item, texture, "item/part_marker");
    }

    private void tipUpgradePartItem(DeferredItem<CompoundPartItem> item) {
        this.generateMaterialColoredItemWithOverlay((ItemLike)item, "item/part/tip", "item/part/tip_shine", "item/part_marker");
    }

    private void coatingPartItem(DeferredItem<CompoundPartItem> item) {
        this.generateMaterialColoredItemWithOverlay((ItemLike)item, "item/part/coating_material", "item/part/coating_jar", "item/part_marker");
    }

    static class ExtraModelTemplates {
        static final ModelTemplate FOUR_LAYERED_ITEM = ModelTemplates.createItem((String)"generated", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3});
        static final ModelTemplate FIVE_LAYERED_ITEM = ModelTemplates.createItem((String)"generated", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4});
        static final ModelTemplate SIX_LAYERED_ITEM = ModelTemplates.createItem((String)"generated", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4, ExtraSlots.LAYER5});
        static final ModelTemplate TWO_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1});
        static final ModelTemplate THREE_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2});
        static final ModelTemplate FOUR_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3});
        static final ModelTemplate FIVE_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4});
        static final ModelTemplate SIX_LAYERED_HANDHELD_ITEM = ModelTemplates.createItem((String)"handheld", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4, ExtraSlots.LAYER5});
        static final ModelTemplate TWO_LAYERED_HANDHELD_ROD_ITEM = ModelTemplates.createItem((String)"handheld_rod", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1});
        static final ModelTemplate THREE_LAYERED_HANDHELD_ROD_ITEM = ModelTemplates.createItem((String)"handheld_rod", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2});
        static final ModelTemplate FOUR_LAYERED_HANDHELD_ROD_ITEM = ModelTemplates.createItem((String)"handheld_rod", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3});
        static final ModelTemplate FIVE_LAYERED_HANDHELD_ROD_ITEM = ModelTemplates.createItem((String)"handheld_rod", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4});
        static final ModelTemplate SIX_LAYERED_HANDHELD_ROD_ITEM = ModelTemplates.createItem((String)"handheld_rod", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2, ExtraSlots.LAYER3, ExtraSlots.LAYER4, ExtraSlots.LAYER5});
        static final ModelTemplate THREE_LAYER_SAW_BASE = ModelTemplates.createItem((String)"silentgear:saw_base", (TextureSlot[])new TextureSlot[]{TextureSlot.LAYER0, TextureSlot.LAYER1, TextureSlot.LAYER2});

        ExtraModelTemplates() {
        }
    }

    static class ExtraSlots {
        static final TextureSlot LAYER3 = TextureSlot.create((String)"layer3");
        static final TextureSlot LAYER4 = TextureSlot.create((String)"layer4");
        static final TextureSlot LAYER5 = TextureSlot.create((String)"layer5");

        ExtraSlots() {
        }
    }
}

