/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.setup.SgLoot;

public class ModEntityLootTables
extends EntityLootSubProvider {
    protected ModEntityLootTables(HolderLookup.Provider registries) {
        super(FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate() {
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
        consumer.accept(SgLoot.Tables.DROPS_SINEW, this.addSinew());
        consumer.accept(SgLoot.Tables.DROPS_FINE_SILK_HIGH, this.addFineSilk(0.04f, 0.01f));
        consumer.accept(SgLoot.Tables.DROPS_FINE_SILK_LOW, this.addFineSilk(0.02f, 0.005f));
        consumer.accept(SgLoot.Tables.DROPS_LEATHER_SCRAPS_HIGH, this.addLeatherScraps());
        consumer.accept(SgLoot.Tables.DROPS_LEATHER_SCRAPS_LOW, this.addLeatherScrapsLow());
    }

    private LootTable.Builder addSinew() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.SINEW).when(LootItemKilledByPlayerCondition.killedByPlayer())).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.2f, (float)0.05f))));
    }

    private LootTable.Builder addFineSilk(float baseChance, float lootingBonus) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.FINE_SILK).when(LootItemKilledByPlayerCondition.killedByPlayer())).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)baseChance, (float)lootingBonus))));
    }

    private LootTable.Builder addLeatherScraps() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.LEATHER_SCRAP).when(LootItemKilledByPlayerCondition.killedByPlayer())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)))));
    }

    private LootTable.Builder addLeatherScrapsLow() {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.LEATHER_SCRAP).when(LootItemKilledByPlayerCondition.killedByPlayer())).when(LootItemRandomChanceWithEnchantedBonusCondition.randomChanceAndLootingBoost((HolderLookup.Provider)this.registries, (float)0.05f, (float)0.01f))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))));
    }

    private static void heroOfTheVillage(BiConsumer<Identifier, LootTable.Builder> consumer, Identifier tableName, ItemLike ... items) {
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        for (ItemLike item : items) {
            pool.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item));
        }
        consumer.accept(tableName, LootTable.lootTable().withPool(pool));
    }
}

