/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.crafting.recipe.salvage.GearSalvagingRecipe;
import net.silentchaos512.gear.crafting.recipe.salvage.SalvagingRecipe;

public final class SalvagingRecipeBuilder<R extends SalvagingRecipe>
implements RecipeBuilder {
    private final BiFunction<Ingredient, List<ItemStack>, R> factory;
    private final String recipeFolder;
    private final Ingredient ingredient;
    private final List<ItemStack> results = new ArrayList<ItemStack>();
    private final boolean resultsMustBePresent;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private SalvagingRecipeBuilder(BiFunction<Ingredient, List<ItemStack>, R> factory, String recipeFolder, Ingredient ingredient, boolean resultsMustBePresent) {
        this.factory = factory;
        this.recipeFolder = recipeFolder;
        this.ingredient = ingredient;
        this.resultsMustBePresent = resultsMustBePresent;
    }

    public static SalvagingRecipeBuilder<SalvagingRecipe> builder(ItemLike ingredient) {
        return SalvagingRecipeBuilder.builder(Ingredient.of((ItemLike)ingredient));
    }

    public static SalvagingRecipeBuilder<SalvagingRecipe> builder(Ingredient ingredient) {
        return new SalvagingRecipeBuilder<SalvagingRecipe>(SalvagingRecipe::new, "salvaging", ingredient, true);
    }

    public static SalvagingRecipeBuilder<GearSalvagingRecipe> gearBuilder(GearItem item) {
        return new SalvagingRecipeBuilder<GearSalvagingRecipe>((ingredient, __) -> new GearSalvagingRecipe((Ingredient)ingredient), "salvaging/gear", Ingredient.of((ItemLike)item), false);
    }

    public SalvagingRecipeBuilder<R> addResult(ItemLike item) {
        return this.addResult(item, 1);
    }

    public SalvagingRecipeBuilder<R> addResult(ItemLike item, int count) {
        this.results.add(new ItemStack(item, count));
        return this;
    }

    public RecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public Item getResult() {
        return !this.results.isEmpty() ? this.results.iterator().next().getItem() : Items.AIR;
    }

    public void save(RecipeOutput pRecipeOutput, ResourceKey<Recipe<?>> pId) {
        this.ensureValid(pId);
        Advancement.Builder advancement$builder = null;
        if (!this.criteria.isEmpty()) {
            advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked(pId)).rewards(AdvancementRewards.Builder.recipe(pId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        }
        SalvagingRecipe recipe = (SalvagingRecipe)this.factory.apply(this.ingredient, this.results);
        AdvancementHolder advancementHolder = advancement$builder != null ? advancement$builder.build(pId.identifier().withPrefix("recipes/" + this.recipeFolder + "/")) : null;
        pRecipeOutput.accept(pId, (Recipe)recipe, advancementHolder);
    }

    private void ensureValid(ResourceKey<Recipe<?>> pId) {
        if (this.resultsMustBePresent && this.results.isEmpty()) {
            throw new IllegalStateException("Empty results for standard salvaging recipe");
        }
    }
}

