/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.setup.SgEntities;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;

public class GearArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_COLOR_ROD = SynchedEntityData.defineId(GearArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ID_COLOR_TIP = SynchedEntityData.defineId(GearArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ID_COLOR_FLETCHING = SynchedEntityData.defineId(GearArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemStack arrowStack = ItemStack.EMPTY;

    public GearArrowEntity(EntityType<? extends GearArrowEntity> entityType, Level level) {
        super(entityType, level);
    }

    public GearArrowEntity(Level level, double x, double y, double z, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)SgEntities.ARROW.get(), x, y, z, level, pickupItemStack, firedFromWeapon);
        this.setArrowStack(pickupItemStack);
        this.setColors(pickupItemStack);
    }

    public GearArrowEntity(Level level, LivingEntity owner, ItemStack pickupItemStack, @Nullable ItemStack firedFromWeapon) {
        super((EntityType)SgEntities.ARROW.get(), owner, level, pickupItemStack, firedFromWeapon);
        this.setArrowStack(pickupItemStack);
        this.setColors(pickupItemStack);
    }

    protected void setPickupItemStack(ItemStack pickupItemStack) {
        super.setPickupItemStack(pickupItemStack);
        this.setArrowStack(pickupItemStack);
        this.setColors(pickupItemStack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_COLOR_ROD, (Object)-1);
        builder.define(ID_COLOR_TIP, (Object)-1);
        builder.define(ID_COLOR_FLETCHING, (Object)-1);
    }

    private void setColors(ItemStack stack) {
        int rodColor = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
        int tipColor = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
        int fletchingColor = ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.FLETCHING.get());
        this.entityData.set(ID_COLOR_ROD, (Object)rodColor);
        this.entityData.set(ID_COLOR_TIP, (Object)tipColor);
        this.entityData.set(ID_COLOR_FLETCHING, (Object)fletchingColor);
    }

    public int getRodColor() {
        return (Integer)this.entityData.get(ID_COLOR_ROD);
    }

    public int getTipColor() {
        return (Integer)this.entityData.get(ID_COLOR_TIP);
    }

    public int getFletchingColor() {
        return (Integer)this.entityData.get(ID_COLOR_FLETCHING);
    }

    protected ItemStack getDefaultPickupItem() {
        GearItem item = GearType.getItem((GearType)GearTypes.ARROW.get());
        return item != null ? new ItemStack((ItemLike)item) : ItemStack.EMPTY;
    }

    public void setArrowStack(ItemStack stack) {
        this.arrowStack = stack.copyWithCount(1);
    }

    public void shootFromRotation(Entity shooter, float x, float y, float z, float velocity, float inaccuracy) {
        float speedMulti = GearData.getProperties(this.arrowStack).getNumber(GearProperties.PROJECTILE_SPEED);
        float accuracy = GearData.getProperties(this.arrowStack).getNumber(GearProperties.PROJECTILE_ACCURACY);
        super.shootFromRotation(shooter, x, y, z, velocity * speedMulti, accuracy > 0.0f ? inaccuracy / accuracy : inaccuracy);
    }
}

