/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.item.gear.GearTridentItem;
import net.silentchaos512.gear.setup.SgEntities;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;

public class GearThrownTrident
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> ID_COLOR_TOOLROD = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ID_COLOR_GRIP = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ID_COLOR_SPIKES = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> ID_COLOR_TIP = SynchedEntityData.defineId(GearThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean dealtDamage;
    private float attackDamage;
    public int clientSideReturnTridentTickCount;
    private int life;

    public GearThrownTrident(EntityType<? extends GearThrownTrident> entityType, Level level) {
        super(entityType, level);
    }

    public GearThrownTrident(Level level, LivingEntity shooter, ItemStack pickupItemStack) {
        super((EntityType)SgEntities.TRIDENT_PROJECTILE.get(), shooter, level, pickupItemStack, null);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(pickupItemStack));
        this.entityData.set(ID_FOIL, (Object)pickupItemStack.hasFoil());
        this.attackDamage = GearTridentItem.getProjectileAttackDamage(pickupItemStack);
        this.setColors(pickupItemStack);
    }

    public GearThrownTrident(Level level, double x, double y, double z, ItemStack pickupItemStack) {
        super((EntityType)SgEntities.TRIDENT_PROJECTILE.get(), x, y, z, level, pickupItemStack, pickupItemStack);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(pickupItemStack));
        this.entityData.set(ID_FOIL, (Object)pickupItemStack.hasFoil());
        this.attackDamage = GearTridentItem.getProjectileAttackDamage(pickupItemStack);
        this.setColors(pickupItemStack);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_LOYALTY, (Object)0);
        builder.define(ID_FOIL, (Object)false);
        builder.define(ID_COLOR_TOOLROD, (Object)-1);
        builder.define(ID_COLOR_GRIP, (Object)-1);
        builder.define(ID_COLOR_SPIKES, (Object)-1);
        builder.define(ID_COLOR_TIP, (Object)-1);
    }

    public int getToolRodColor() {
        return (Integer)this.entityData.get(ID_COLOR_TOOLROD);
    }

    public int getGripColor() {
        return (Integer)this.entityData.get(ID_COLOR_GRIP);
    }

    public int getSpikesColor() {
        return (Integer)this.entityData.get(ID_COLOR_SPIKES);
    }

    public int getTipColor() {
        return (Integer)this.entityData.get(ID_COLOR_TIP);
    }

    private void setColors(ItemStack pickupItemStack) {
        int toolRodColor = ColorUtils.getBlendedColorForPartInGear(pickupItemStack, (PartType)PartTypes.ROD.get());
        int gripColor = ColorUtils.getBlendedColorForPartInGear(pickupItemStack, (PartType)PartTypes.GRIP.get());
        int spikesColor = ColorUtils.getBlendedColorForPartInGear(pickupItemStack, (PartType)PartTypes.MAIN.get());
        int tipColor = ColorUtils.getBlendedColorForPartInGear(pickupItemStack, (PartType)PartTypes.TIP.get());
        int coatingColor = ColorUtils.getBlendedColorForPartInGear(pickupItemStack, (PartType)PartTypes.COATING.get());
        this.entityData.set(ID_COLOR_TOOLROD, (Object)toolRodColor);
        this.entityData.set(ID_COLOR_GRIP, (Object)(gripColor == -1 ? toolRodColor : gripColor));
        this.entityData.set(ID_COLOR_SPIKES, (Object)(coatingColor == -1 ? spikesColor : coatingColor));
        this.entityData.set(ID_COLOR_TIP, (Object)(tipColor == -1 ? spikesColor : tipColor));
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.getOwner();
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                        this.spawnAtLocation(serverLevel, this.getPickupItem(), 0.1f);
                    }
                }
                this.discard();
            } else {
                this.setNoPhysics(true);
                Vec3 vec3 = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + vec3.y * 0.015 * (double)i, this.getZ());
                if (this.level().isClientSide()) {
                    this.yOld = this.getY();
                }
                double d0 = 0.05 * (double)i;
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(vec3.normalize().scale(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.tick();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.getOwner();
        return entity == null || !entity.isAlive() ? false : !(entity instanceof ServerPlayer) || !entity.isSpectator();
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.findHitEntity(startVec, endVec);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        float f = this.attackDamage;
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(entity1 == null ? this : entity1));
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)f);
        }
        this.dealtDamage = true;
        if (entity.hurtOrSimulate(damagesource, f)) {
            if (entity.getType() == EntityType.ENDERMAN) {
                return;
            }
            level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel1 = (ServerLevel)level;
                EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)entity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                this.doKnockback(livingentity, damagesource);
                this.doPostHurtEffects(livingentity);
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        this.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
    }

    protected void hitBlockEnchantmentEffects(ServerLevel level, BlockHitResult hitResult, ItemStack stack) {
        LivingEntity livingentity;
        Vec3 vec3 = hitResult.getBlockPos().clampLocationWithin(hitResult.getLocation());
        Entity entity = this.getOwner();
        EnchantmentHelper.onHitBlock((ServerLevel)level, (ItemStack)stack, (LivingEntity)(entity instanceof LivingEntity ? (livingentity = (LivingEntity)entity) : null), (Entity)this, null, (Vec3)vec3, (BlockState)level.getBlockState(hitResult.getBlockPos()), p_348680_ -> this.kill(level));
    }

    public ItemStack getWeaponItem() {
        return this.getPickupItemStackOrigin();
    }

    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.ownedBy((Entity)player) && player.getInventory().add(this.getPickupItem());
    }

    protected ItemStack getDefaultPickupItem() {
        GearItem item = GearType.getItem((GearType)GearTypes.TRIDENT.get());
        return item != null ? new ItemStack((ItemLike)item) : ItemStack.EMPTY;
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player entity) {
        if (this.ownedBy((Entity)entity) || this.getOwner() == null) {
            super.playerTouch(entity);
        }
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        this.dealtDamage = input.getBooleanOr("DealtDamage", false);
        this.entityData.set(ID_LOYALTY, (Object)this.getLoyaltyFromItem(this.getPickupItemStackOrigin()));
        this.setColors(this.getPickupItemStackOrigin());
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("DealtDamage", this.dealtDamage);
    }

    private byte getLoyaltyFromItem(ItemStack stack) {
        byte by;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            by = (byte)Mth.clamp((int)EnchantmentHelper.getTridentReturnToOwnerAcceleration((ServerLevel)serverlevel, (ItemStack)stack, (Entity)this), (int)0, (int)127);
        } else {
            by = 0;
        }
        return by;
    }

    public void tickDespawn() {
        byte i = (Byte)this.entityData.get(ID_LOYALTY);
        if (this.pickup != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            ++this.life;
            if (this.life > 6000) {
                this.discard();
            }
        }
    }

    protected float getWaterInertia() {
        return 0.99f;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }
}

