/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.animal.chicken.Chicken;
import net.minecraft.world.entity.animal.feline.Cat;
import net.minecraft.world.entity.animal.fish.Cod;
import net.minecraft.world.entity.animal.fish.Pufferfish;
import net.minecraft.world.entity.animal.fish.Salmon;
import net.minecraft.world.entity.animal.rabbit.Rabbit;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.advancements.criterion.GearPropertyTrigger;
import net.silentchaos512.gear.advancements.criterion.GearRepairedTrigger;
import net.silentchaos512.gear.advancements.criterion.HasPartTrigger;
import net.silentchaos512.gear.api.item.BreakEventHandler;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.NumberPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.setup.SgAttributes;
import net.silentchaos512.gear.setup.SgCriteriaTriggers;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.event.ServerTicks;

@EventBusSubscriber
public final class GearEvents {
    private static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final float BURN_TICKS_PER_DURABILITY = 4.0f;
    private static final List<Function<Level, Entity>> JABBERWOCKY_MOBS = ImmutableList.of(level -> new Wolf(EntityType.WOLF, level), level -> new Cat(EntityType.CAT, level), level -> new Rabbit(EntityType.RABBIT, level), level -> new Chicken(EntityType.CHICKEN, level), level -> new Cod(EntityType.COD, level), level -> new Salmon(EntityType.SALMON, level), level -> new Pufferfish(EntityType.PUFFERFISH, level));

    private GearEvents() {
    }

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingIncomingDamageEvent event) {
        ItemStack weapon;
        LivingEntity target = event.getEntity();
        if (target.level().isClientSide()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.getEntity();
        if (attacker instanceof LivingEntity) {
            LivingEntity attackingLivingEntity = (LivingEntity)attacker;
            v0 = attackingLivingEntity.getItemBySlot(EquipmentSlot.MAINHAND);
        } else {
            v0 = weapon = ItemStack.EMPTY;
        }
        if (attacker instanceof Player) {
            Player attackingPlayer = (Player)attacker;
            if (weapon.getItem() instanceof GearTool) {
                float baseDamage = event.getAmount();
                float newDamage = TraitHelper.activateTraits(weapon, Float.valueOf(baseDamage), (trait, value) -> Float.valueOf(trait.getTrait().onAttackEntity(new TraitActionContext(attackingPlayer, trait, weapon), target, value.floatValue()))).floatValue();
                event.setAmount(newDamage);
            }
        }
        float incomingDamage = event.getAmount();
        float newIncomingDamage = event.getAmount();
        for (EquipmentSlot armorSlot : ARMOR_SLOTS) {
            ItemStack armor = target.getItemBySlot(armorSlot);
            if (!(armor.getItem() instanceof GearArmor)) continue;
            newIncomingDamage = TraitHelper.activateTraits(armor, Float.valueOf(newIncomingDamage), (trait, value) -> Float.valueOf(trait.getTrait().onEntityIncomingDamage(armor, trait.getLevel(), target, source, value.floatValue(), incomingDamage))).floatValue();
        }
        event.setAmount(newIncomingDamage);
        if (newIncomingDamage < 1.0E-4f && event.getOriginalAmount() > 0.0f) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamagePost(LivingDamageEvent.Post event) {
        if (event.getEntity() instanceof Player && GearEvents.isFireDamage(event.getSource())) {
            GearEvents.damageFlammableItems(event);
        }
    }

    private static boolean isFireDamage(@Nullable DamageSource source) {
        return source != null && source.is(DamageTypeTags.IS_FIRE);
    }

    private static void damageFlammableItems(LivingDamageEvent.Post event) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = event.getEntity().getItemBySlot(slot);
            if (!GearHelper.isGear(stack) || !TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) continue;
            GearHelper.attemptDamage(stack, 2, event.getEntity(), slot);
            GearEvents.checkAndDisplayFlammableItemBroken(event, slot, stack);
        }
    }

    private static void checkAndDisplayFlammableItemBroken(LivingDamageEvent.Post event, EquipmentSlot slot, ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            event.getEntity().onEquippedItemBroken(stack.getItem(), slot);
            stack.shrink(1);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                MutableComponent text = TextUtil.translate("trait", "flammable.itemDestroyed", stack.getHoverName());
                player.displayClientMessage((Component)text, false);
            }
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        ItemStack stack = event.getItemStack();
        if (GearHelper.isGear(stack) && TraitHelper.hasTrait(stack, Const.Traits.FLAMMABLE)) {
            float durability = stack.getMaxDamage();
            event.setBurnTime((int)(durability * 4.0f));
        }
    }

    @SubscribeEvent
    public static void onLivingHurtMagicArmor(LivingDamageEvent.Pre event) {
        if (event.getSource().is(DamageTypes.MAGIC)) {
            AttributeInstance attributeInstance = event.getEntity().getAttribute(SgAttributes.MAGIC_ARMOR);
            float magicArmor = attributeInstance != null ? (float)attributeInstance.getValue() : 0.0f;
            float scale = 1.0f - GearEvents.getReducedMagicDamageScale(magicArmor);
            event.setNewDamage(event.getNewDamage() * scale);
        }
    }

    private static float getReducedMagicDamageScale(float magicArmor) {
        if (magicArmor > 20.0f) {
            return 0.6f + 0.015f * (magicArmor - 20.0f);
        }
        return 0.03f * magicArmor;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState state;
        Player player = event.getEntity();
        ItemStack tool = player.getMainHandItem();
        if (tool.getItem() instanceof GearItem && tool.isCorrectToolForDrops(state = event.getState())) {
            int level = TraitHelper.getTraitLevel(tool, Const.Traits.LUSTROUS);
            int light = GearEvents.getLightForLustrousTrait((BlockAndTintGetter)player.level(), player.blockPosition());
            event.setNewSpeed(event.getNewSpeed() + (float)GearEvents.getLustrousSpeedBonus(level, light));
        }
    }

    public static int getLightForLustrousTrait(BlockAndTintGetter world, BlockPos pos) {
        int blockLight = world.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = world.getBrightness(LightLayer.SKY, pos);
        return Math.max(skyLight, blockLight * 3 / 4);
    }

    public static int getLustrousSpeedBonus(int level, int light) {
        return 4 * level * light / 15;
    }

    @SubscribeEvent
    public static void onXpDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() == null) {
            return;
        }
        ItemStack tool = event.getAttackingPlayer().getMainHandItem();
        if (tool.isEmpty() || !(tool.getItem() instanceof GearTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel == 0) {
            return;
        }
        int bonusXp = (int)((float)event.getOriginalExperience() * 0.25f * (float)ancientLevel);
        event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
    }

    @SubscribeEvent
    public static void onBlockDrops(BlockDropsEvent event) {
        if (event.getBreaker() == null) {
            return;
        }
        ItemStack tool = event.getTool();
        if (tool.isEmpty() || !(tool.getItem() instanceof GearTool)) {
            return;
        }
        int ancientLevel = TraitHelper.getTraitLevel(tool, Const.Traits.ANCIENT);
        if (ancientLevel > 0) {
            int bonusXp = (int)((float)event.getDroppedExperience() * 0.25f * (float)ancientLevel);
            event.setDroppedExperience(event.getDroppedExperience() + bonusXp);
        }
        if (TraitHelper.hasTrait(tool, Const.Traits.SILKY)) {
            event.setDroppedExperience(0);
        }
        if (TraitHelper.hasTrait(tool, Const.Traits.JABBERWOCKY) && event.getState().is(Tags.Blocks.ORES_DIAMOND) && !GearEvents.hasSilkTouch((Level)event.getLevel(), tool)) {
            Entity entity = JABBERWOCKY_MOBS.get(SilentGear.RANDOM.nextInt(JABBERWOCKY_MOBS.size())).apply(event.getBreaker().level());
            entity.teleportTo((double)event.getPos().getX() + 0.5, (double)event.getPos().getY(), (double)event.getPos().getZ() + 0.5);
            event.getLevel().addFreshEntity(entity);
        }
    }

    private static boolean hasSilkTouch(Level level, ItemStack tool) {
        Holder.Reference silkTouch = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.SILK_TOUCH);
        return EnchantmentHelper.getTagEnchantmentLevel((Holder)silkTouch, (ItemStack)tool) > 0;
    }

    @SubscribeEvent
    public static void onGearCrafted(PlayerEvent.ItemCraftedEvent event) {
        Player player;
        ItemStack result = event.getCrafting();
        if (GearHelper.isGear(result) && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (GearData.hasPart(result, (PartType)PartTypes.ROD.get(), p -> {
                MaterialInstance primaryMaterial = p.getPrimaryMaterial();
                return primaryMaterial != null && primaryMaterial.is(Const.Materials.WOOD_ROUGH);
            })) {
                ((PlayerTrigger)SgCriteriaTriggers.CRAFTED_WITH_ROUGH_ROD.get()).trigger(player2);
            }
            int brokenCount = GearData.getBrokenCount(result);
            int repairedCount = GearData.getRepairedCount(result);
            ((GearRepairedTrigger)((Object)SgCriteriaTriggers.GEAR_REPAIRED.get())).trigger(player2, brokenCount, repairedCount);
            for (GearProperty propertyType : SgRegistries.GEAR_PROPERTY) {
                Object property = GearData.getProperties(result, (Player)player2).get(propertyType);
                if (!(property instanceof NumberPropertyValue)) continue;
                NumberPropertyValue numberProperty = (NumberPropertyValue)property;
                ((GearPropertyTrigger)((Object)SgCriteriaTriggers.GEAR_PROPERTY.get())).trigger(player2, propertyType, ((Float)numberProperty.value()).floatValue());
            }
            ((HasPartTrigger)((Object)SgCriteriaTriggers.HAS_PART.get())).trigger(player2, result);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity killer = event.getSource().getEntity();
        if (killer instanceof Player) {
            Player player = (Player)killer;
            if (!killer.level().isClientSide() && TraitHelper.hasTraitEitherHand(player, Const.Traits.CONFETTI)) {
                for (int i = 0; i < 3; ++i) {
                    FireworkRocketEntity rocket = new FireworkRocketEntity(player.level(), event.getEntity().getX(), event.getEntity().getEyeY(), event.getEntity().getZ(), GearEvents.createRandomFirework());
                    killer.level().addFreshEntity((Entity)rocket);
                }
            }
        }
    }

    private static ItemStack createRandomFirework() {
        ItemStack ret = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        int flightDuration = SilentGear.RANDOM.nextInt(3) + 1;
        FireworkExplosion.Shape shape = FireworkExplosion.Shape.values()[SilentGear.RANDOM.nextInt(FireworkExplosion.Shape.values().length)];
        int fireworkColor = DyeColor.values()[SilentGear.RANDOM.nextInt(DyeColor.values().length)].getFireworkColor();
        FireworkExplosion fireworkExplosion = new FireworkExplosion(shape, IntList.of((int)fireworkColor), IntList.of(), false, false);
        ret.set(DataComponents.FIREWORKS, (Object)new Fireworks(flightDuration, Collections.singletonList(fireworkExplosion)));
        return ret;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        Level level = player.level();
        if (!level.isClientSide()) {
            if (!player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && TraitHelper.hasTrait(player.getItemBySlot(EquipmentSlot.HEAD), Const.Traits.TURTLE)) {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 210, 0, false, false, true));
            }
            if (player.getY() < (double)(level.getMinY() - 32) && TraitHelper.hasTraitArmor(player, Const.Traits.VOID_WARD)) {
                player.push(0.0, 20.0, 0.0);
                player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 400, 3, true, false));
                player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 200, 9, true, false));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        LivingEntity livingEntity;
        ItemStack stack = event.getEntity().getItemBySlot(EquipmentSlot.FEET);
        if (event.getDistance() > 3.0 && (livingEntity = event.getEntity()) instanceof Player) {
            int bounce;
            Player player = (Player)livingEntity;
            int moonwalker = TraitHelper.getHighestLevelArmorOrCurio(player, Const.Traits.MOONWALKER);
            if (moonwalker > 0) {
                float gravity = 1.0f + (float)moonwalker * -0.15f;
                event.setDistance(event.getDistance() * (double)gravity);
                LivingEntity livingEntity2 = event.getEntity();
                if (livingEntity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                    ((PlayerTrigger)SgCriteriaTriggers.FALL_WITH_MOONWALKER.get()).trigger(serverPlayer);
                }
            }
            if ((bounce = TraitHelper.getHighestLevelArmorOrCurio(player, Const.Traits.BOUNCE)) > 0 && !event.getEntity().isSuppressingBounce() && !event.getEntity().isFallFlying()) {
                GearEvents.bounceEntity((Entity)event.getEntity());
                int damage = (int)(event.getDistance() / 3.0) - 1;
                if (damage > 0) {
                    GearHelper.attemptDamage(stack, damage, event.getEntity(), EquipmentSlot.FEET);
                }
                event.getEntity().level().playSound(null, event.getEntity().blockPosition(), SoundEvents.SLIME_BLOCK_FALL, SoundSource.PLAYERS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    private static void bounceEntity(Entity entity) {
        Vec3 movement = entity.getDeltaMovement();
        if (movement.y < 0.0) {
            Vec3 vec = new Vec3(0.0, -0.75 * movement.y, 0.0);
            ServerTicks.scheduleAction(() -> entity.push(vec));
        }
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingDamageEvent.Post event) {
        Player player;
        int bounce;
        Entity source;
        if (event.getEntity() instanceof Player && (source = event.getSource().getDirectEntity()) instanceof LivingEntity && (bounce = TraitHelper.getHighestLevelArmor(player = (Player)event.getEntity(), Const.Traits.BOUNCE)) > 0) {
            SilentGear.LOGGER.debug("knockback");
            ((LivingEntity)source).knockback((double)(2 * bounce), (double)(-Mth.sin((double)(source.getYRot() * ((float)Math.PI / 180)))), (double)Mth.cos((double)(source.getYRot() * ((float)Math.PI / 180))));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        ItemStack tool = player.getMainHandItem();
        Item item = tool.getItem();
        if (item instanceof BreakEventHandler) {
            BreakEventHandler breakEventHandler = (BreakEventHandler)item;
            breakEventHandler.onBlockBreakEvent(tool, player, player.level(), event.getPos(), event.getState());
        }
        List traits = (List)GearData.getProperties(tool, player).getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty()).value();
        for (TraitInstance traitInstance : traits) {
            traitInstance.getTrait().onBlockBreak(new TraitActionContext(player, traitInstance, tool), event);
        }
    }
}

