/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.event;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.gear.part.UpgradeGearPart;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.GearData;

@EventBusSubscriber(modid="silentgear")
public final class RepairHandler {
    private RepairHandler() {
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        if (event.getLeft().getItem() instanceof GearItem) {
            MaterialInstance material = MaterialInstance.from(event.getRight());
            PartInstance part = PartInstance.from(event.getRight());
            if (material != null) {
                RepairHandler.handleGearRepair(event, material);
            } else if (part != null && part.isValid() && part.get() instanceof UpgradeGearPart) {
                RepairHandler.handleUpgradeApplication(event, part);
            }
        }
    }

    private static void handleUpgradeApplication(AnvilUpdateEvent event, PartInstance part) {
        ItemStack result = event.getLeft().copy();
        RepairHandler.applyName(event, result);
        GearData.addUpgradePart(result, part);
        GearData.recalculateGearData(result, null);
        event.setOutput(result);
        event.setXpCost(3);
    }

    private static void handleGearRepair(AnvilUpdateEvent event, MaterialInstance material) {
        ItemStack result = event.getLeft().copy();
        RepairHandler.applyName(event, result);
        float repairValue = material.getRepairValue(result, RepairContext.Type.ANVIL);
        float gearRepairEfficiency = GearData.getProperties(result, event.getPlayer()).getNumber(GearProperties.REPAIR_EFFICIENCY);
        float anvilEfficiency = ((Double)Config.Common.repairFactorAnvil.get()).floatValue();
        float amount = repairValue * gearRepairEfficiency * anvilEfficiency;
        int materialCount = 1;
        for (float repaired = amount; materialCount < event.getRight().getCount() && repaired < (float)result.getDamageValue(); ++materialCount, repaired += amount) {
        }
        if (amount > 0.0f) {
            int repairAmount = Math.round(amount * (float)materialCount);
            result.setDamageValue(result.getDamageValue() - repairAmount);
            GearData.recalculateGearData(result, null);
            event.setOutput(result);
            event.setXpCost(materialCount);
            event.setMaterialCost(materialCount);
        }
    }

    private static void applyName(AnvilUpdateEvent event, ItemStack stack) {
        if (event.getName() != null && !event.getName().isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)event.getName()));
        }
    }
}

