/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.GearComponentInstance;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.MaterialModifiers;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public final class MaterialInstance
implements GearComponentInstance<Material> {
    public static final Codec<MaterialInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DataResource.MATERIAL_CODEC.fieldOf("material").forGetter(m -> m.material), (App)ItemStack.OPTIONAL_CODEC.optionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(m -> m.item), (App)Codec.list(MaterialModifiers.CODEC).optionalFieldOf("modifiers", List.of()).forGetter(m -> m.modifiers)).apply((Applicative)instance, MaterialInstance::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MaterialInstance> STREAM_CODEC = StreamCodec.composite(DataResource.MATERIAL_STREAM_CODEC, m -> m.material, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, m -> m.item, (StreamCodec)MaterialModifiers.STREAM_CODEC.apply(ByteBufCodecs.list()), m -> m.modifiers, MaterialInstance::new);
    private static final Map<Identifier, MaterialInstance> QUICK_CACHE = new HashMap<Identifier, MaterialInstance>();
    private final DataResource<Material> material;
    private final ItemStack item;
    private final List<IMaterialModifier> modifiers;

    private MaterialInstance(DataResource<Material> material) {
        this(material, ItemStack.EMPTY);
    }

    private MaterialInstance(DataResource<Material> material, ItemStack craftingItem) {
        this(material, craftingItem, MaterialInstance.getMaterialModifiersFromItem(craftingItem));
    }

    private MaterialInstance(DataResource<Material> material, ItemStack craftingItem, List<IMaterialModifier> modifiers) {
        this.material = material;
        this.item = craftingItem.copy();
        if (!this.item.isEmpty()) {
            this.item.setCount(1);
        }
        this.modifiers = modifiers;
    }

    public static MaterialInstance of(DataResource<Material> material) {
        return QUICK_CACHE.computeIfAbsent(material.getId(), id -> new MaterialInstance(material));
    }

    public static MaterialInstance of(Material material) {
        return MaterialInstance.of(DataResource.material(SgRegistries.MATERIAL.getKey(material)));
    }

    public static MaterialInstance of(DataResource<Material> material, ItemStack craftingItem) {
        return new MaterialInstance(material, craftingItem);
    }

    public static MaterialInstance of(Material material, ItemStack craftingItem) {
        return MaterialInstance.of(DataResource.material(SgRegistries.MATERIAL.getKey(material)), craftingItem);
    }

    @Nullable
    public static MaterialInstance from(ItemStack stack) {
        Material material = SgRegistries.MATERIAL.fromItem(stack);
        if (material != null) {
            return MaterialInstance.of(material, stack);
        }
        return null;
    }

    private static List<IMaterialModifier> getMaterialModifiersFromItem(ItemStack stack) {
        ArrayList list = new ArrayList();
        for (IMaterialModifierType type : SgRegistries.MATERIAL_MODIFIER_TYPE) {
            type.readModifier(stack).ifPresent(list::add);
        }
        return List.copyOf(list);
    }

    @Override
    public Identifier getId() {
        return this.material.getId();
    }

    @Override
    @Nonnull
    public Material get() {
        return this.material.get();
    }

    @Nullable
    public Material getNullable() {
        return this.material.getNullable();
    }

    public boolean isValid() {
        return this.material.isPresent();
    }

    public Collection<IMaterialModifier> getModifiers() {
        return this.modifiers;
    }

    @Nullable
    public <T extends IMaterialModifier> T getModifier(IMaterialModifierType<T> modifierType) {
        for (IMaterialModifier modifier : this.getModifiers()) {
            if (modifier.getType() != modifierType) continue;
            return (T)modifier;
        }
        return null;
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    public Collection<IMaterialCategory> getCategories() {
        Material mat = this.getNullable();
        return mat != null ? mat.getCategories(this) : Collections.emptySet();
    }

    public Optional<Ingredient> getIngredient() {
        Material mat = this.getNullable();
        return mat != null ? mat.getIngredient() : Optional.empty();
    }

    public boolean canRepair(ItemStack gear) {
        MaterialInstance partMaterial;
        if (!this.material.isPresent() || !this.material.get().isAllowedInPart(this, (PartType)PartTypes.MAIN.get())) {
            return false;
        }
        GearConstructionData gearConstructionData = GearData.getConstruction(gear);
        PartInstance primaryPart = gearConstructionData.getPrimaryPart();
        if (primaryPart != null && (partMaterial = primaryPart.getPrimaryMaterial()) != null) {
            return this.material.get().canRepair(partMaterial);
        }
        return false;
    }

    public int getRepairValue(ItemStack gear) {
        return this.getRepairValue(gear, RepairContext.Type.QUICK);
    }

    public int getRepairValue(ItemStack gear, RepairContext.Type type) {
        if (this.canRepair(gear)) {
            float durability = this.getProperty((PartType)PartTypes.MAIN.get(), GearHelper.getDurabilityProperty(gear)).floatValue();
            float repairValueMulti = 1.0f + ((Float)this.getProperty((PartType)PartTypes.MAIN.get(), GearProperties.REPAIR_VALUE.get())).floatValue();
            float itemRepairModifier = GearHelper.getRepairModifier(gear);
            float typeBonus = 1.0f + type.getBonusEfficiency();
            return Math.round(durability * repairValueMulti * itemRepairModifier * typeBonus) + 1;
        }
        return 0;
    }

    public int getColor(GearType gearType, PartType partType) {
        Material mat = this.getNullable();
        return mat != null ? mat.getColor(this, partType, gearType) : 0xFFFFFF;
    }

    public TextureType getMainTextureType() {
        Material mat = this.getNullable();
        return mat != null ? mat.getMainTextureType(this) : TextureType.LOW_CONTRAST;
    }

    @Override
    public Component getDisplayName(PartType partType, ItemStack gear) {
        Material mat = this.getNullable();
        return mat != null ? mat.getDisplayName(this, partType) : Component.literal((String)this.getId().toString());
    }

    public String getModelKey() {
        Material mat = this.getNullable();
        return mat != null ? mat.getModelKey(this) : "null";
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType) {
        Material mat = this.getNullable();
        return mat != null ? mat.getNameColor(this, partType, gearType) : 0xFFFFFF;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaterialInstance that = (MaterialInstance)o;
        return this.getId().equals((Object)that.getId()) && ItemStack.isSameItemSameComponents((ItemStack)this.item, (ItemStack)that.item);
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.material.getId().hashCode(), ItemStack.hashItemAndComponents((ItemStack)this.item)});
    }

    public String toString() {
        return "MaterialInstance{" + String.valueOf(this.material.getId()) + "}";
    }

    public boolean hasAnyCategory(Collection<IMaterialCategory> others) {
        for (IMaterialCategory cat1 : this.getCategories()) {
            for (IMaterialCategory cat2 : others) {
                if (!cat1.matches(cat2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSimple() {
        Material mat = this.getNullable();
        return mat != null && mat.isSimple();
    }

    @Override
    public <T, V extends GearPropertyValue<T>> T getProperty(PartType partType, PropertyKey<T, V> key) {
        Material material = this.getNullable();
        if (material != null) {
            return material.getProperty(this, partType, key);
        }
        return key.property().getDefaultValue();
    }

    public Set<PartType> getPartTypes() {
        Material material = this.getNullable();
        if (material != null) {
            return material.getPartTypes(this);
        }
        return Collections.emptySet();
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PartType partType, PropertyKey<T, V> key) {
        Material material = this.getNullable();
        if (material == null) {
            return Collections.emptyList();
        }
        Collection<V> propertyModifiers = material.getPropertyModifiers(this, partType, key);
        for (IMaterialModifier modifier : this.modifiers) {
            propertyModifiers = modifier.modifyProperties(this, partType, key, propertyModifiers);
        }
        return propertyModifiers;
    }

    public MutableComponent getDisplayNameWithModifiers(PartType partType, ItemStack gear) {
        MutableComponent name = this.getDisplayName(partType, gear).copy();
        for (IMaterialModifier modifier : this.getModifiers()) {
            name = modifier.modifyMaterialName(name);
        }
        return name;
    }

    public Component getDisplayNamePrefix(PartType partType) {
        Material material = this.getNullable();
        return material != null ? material.getDisplayNamePrefix(partType) : Component.empty();
    }

    public boolean allowedInPart(PartType partType) {
        Material material = this.getNullable();
        return material != null && material.isAllowedInPart(this, partType);
    }

    public boolean isCraftingAllowed(PartType partType, GearType gearType) {
        Material material = this.getNullable();
        return material != null && material.isCraftingAllowed(this, partType, gearType);
    }

    public MaterialInstance onSalvage() {
        Material material = this.getNullable();
        return material != null ? material.onSalvage(this) : this;
    }

    public boolean is(DataResource<Material> material) {
        return this.material == material;
    }

    public boolean parentIs(DataResource<Material> material) {
        Material parent = this.get().getParent();
        return parent == material;
    }
}

