/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.core.DataResourceManager;
import net.silentchaos512.gear.gear.MaterialJsonException;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.util.TextUtil;

public class MaterialManager
extends DataResourceManager<Material> {
    private static final Collection<String> INGREDIENT_CONFLICT_LIST = new ArrayList<String>();
    private final Multimap<String, Material> ingredientChecks = HashMultimap.create();
    private static List<Material> GET_VALUES_CACHE_WITH_CHILDREN = List.of();
    private static List<Material> GET_VALUES_CACHE_WITHOUT_CHILDREN = List.of();

    public MaterialManager() {
        super(MaterialSerializers.DISPATCH_CODEC, MaterialJsonException::new, "material", "silentgear_materials", "MaterialManager", SilentGear.LOGGER);
    }

    @Override
    public void validate(Material value, JsonObject json) {
        this.addIngredientChecks(value, json);
    }

    @Override
    public void onReloadPost() {
        this.checkForIngredientConflicts();
        this.ingredientChecks.clear();
    }

    private void addIngredientChecks(Material material, JsonObject json) {
        JsonObject craftingItemsJson = json.getAsJsonObject("crafting_items");
        if (craftingItemsJson != null && craftingItemsJson.has("main")) {
            JsonElement mainJson = craftingItemsJson.get("main");
            String key = mainJson.toString();
            this.ingredientChecks.put((Object)key, (Object)material);
        }
    }

    private void checkForIngredientConflicts() {
        INGREDIENT_CONFLICT_LIST.clear();
        for (String key : this.ingredientChecks.keySet()) {
            if (this.ingredientChecks.get((Object)key).size() <= 1) continue;
            String collect = this.ingredientChecks.get((Object)key).stream().map(mat -> this.getKey(mat).toString()).collect(Collectors.joining(" and "));
            INGREDIENT_CONFLICT_LIST.add("Conflicting crafting items for: " + collect);
        }
    }

    public List<Material> getValues(boolean includeChildren) {
        if (this.isReloading()) {
            return List.of();
        }
        if (includeChildren) {
            if (this.isCacheInvalid(GET_VALUES_CACHE_WITH_CHILDREN)) {
                GET_VALUES_CACHE_WITH_CHILDREN = this.computeValuesList(true);
            }
            return GET_VALUES_CACHE_WITH_CHILDREN;
        }
        if (this.isCacheInvalid(GET_VALUES_CACHE_WITHOUT_CHILDREN)) {
            GET_VALUES_CACHE_WITHOUT_CHILDREN = this.computeValuesList(false);
        }
        return GET_VALUES_CACHE_WITHOUT_CHILDREN;
    }

    private boolean isCacheInvalid(List<Material> list) {
        return list.isEmpty() || this.getKey(list.getFirst()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Material> computeValuesList(boolean includeChildren) {
        MaterialManager materialManager = this;
        synchronized (materialManager) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Material m : this) {
                if (!includeChildren && m.getParent() != null || !m.isValid()) continue;
                builder.add((Object)m);
            }
            return builder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Material> getChildren(Material material) {
        MaterialManager materialManager = this;
        synchronized (materialManager) {
            ArrayList<Material> list = new ArrayList<Material>();
            for (Material m : this) {
                if (m.getParent() != material) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Material> getRandomObtainable(RandomSource randomSource) {
        MaterialManager materialManager = this;
        synchronized (materialManager) {
            List<Material> list = this.stream().filter(material -> material.getIngredient().isPresent()).filter(material -> !material.isInCategory(MaterialCategories.INTANGIBLE)).toList();
            return Util.getRandomSafe(list, (RandomSource)randomSource);
        }
    }

    @Nullable
    public Material fromItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        ArrayList<Material> matches = new ArrayList<Material>();
        for (Material material : this) {
            Optional<Ingredient> ingredient = material.getIngredient();
            if (!ingredient.isPresent() || !ingredient.get().test(stack)) continue;
            matches.add(material);
        }
        if (matches.size() > 1) {
            for (Material material : matches) {
                if (material.getParent() == null) continue;
                return material;
            }
        }
        if (!matches.isEmpty()) {
            return (Material)matches.getFirst();
        }
        return null;
    }

    @Override
    public Collection<Component> getErrorMessages(ServerPlayer player) {
        Collection<Component> ret = super.getErrorMessages(player);
        INGREDIENT_CONFLICT_LIST.forEach(line -> {
            MutableComponent text = TextUtil.withColor(Component.literal((String)line), ChatFormatting.YELLOW);
            ret.add((Component)Component.literal((String)"[Silent Gear] ").append((Component)text));
        });
        return ret;
    }
}

