/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.gear.api.event.GetPropertyModifiersEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartCraftingData;
import net.silentchaos512.gear.api.part.PartDisplayData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.PartTypes;

public abstract class AbstractGearPart
implements GearPart {
    String packName = "UNKNOWN PACK";
    protected final PartCraftingData crafting;
    protected final PartDisplayData display;
    protected final GearPropertyMap properties;

    protected AbstractGearPart(PartCraftingData crafting, PartDisplayData display, GearPropertyMap properties) {
        this.crafting = crafting;
        this.display = display;
        this.properties = properties;
    }

    @Override
    public Optional<Ingredient> getIngredient() {
        return this.crafting.craftingItem();
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(PartInstance instance, PartType partType, PropertyKey<T, V> key) {
        if (key.property().isForMaterialsOnly()) {
            return List.of();
        }
        ArrayList<V> mods = new ArrayList<V>(this.properties.getValues(key));
        GetPropertyModifiersEvent<T, V> event = new GetPropertyModifiersEvent<T, V>(instance, key, mods);
        NeoForge.EVENT_BUS.post(event);
        return event.getModifiers();
    }

    @Override
    public boolean isCraftingAllowed(PartInstance part, PartType partType, GearType gearType, @Nullable CraftingInput craftingInput) {
        if (!gearType.matches((GearType)GearTypes.ALL.get())) {
            return true;
        }
        for (GearType blacklistedGearType : this.crafting.gearTypeBlacklist()) {
            if (!gearType.matches(blacklistedGearType)) continue;
            return false;
        }
        return GearPart.super.isCraftingAllowed(part, partType, gearType, craftingInput);
    }

    @Override
    public void onAddToGear(ItemStack gear, PartInstance part) {
        GearPart.super.onAddToGear(gear, part);
        if (part.getType() == PartTypes.MAIN.get()) {
            gear.setDamageValue(part.getItem().getDamageValue());
        }
    }

    @Override
    public Component getDisplayName(@Nullable PartInstance part) {
        return this.display.name().copy();
    }

    @Override
    public Component getDisplayName(@Nullable PartInstance part, PartType type) {
        return this.display.name().copy();
    }

    @Override
    public Component getDisplayNamePrefix(@Nullable PartInstance part, ItemStack gear) {
        return this.display.namePrefix().copy();
    }

    @Override
    public void addInformation(PartInstance part, ItemStack gear, List<Component> tooltip, TooltipFlag flag) {
    }

    public List<GearType> getBlacklistedGearTypes() {
        return ImmutableList.copyOf(this.crafting.gearTypeBlacklist());
    }

    public String toString() {
        return "AbstractGearPart{id=" + String.valueOf(SgRegistries.PART.getKey(this)) + ", partType=" + String.valueOf(this.getType()) + "}";
    }
}

