/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.core.DataResourceManager;
import net.silentchaos512.gear.gear.PartJsonException;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartSerializers;

public final class PartManager
extends DataResourceManager<GearPart> {
    public PartManager() {
        super(PartSerializers.DISPATCH_CODEC, PartJsonException::new, "part", "silentgear_parts", "PartManager", SilentGear.LOGGER);
    }

    @Override
    public void attachExtraData(GearPart value, String packName, JsonObject json) {
        if (value instanceof AbstractGearPart) {
            AbstractGearPart gearPart = (AbstractGearPart)value;
            gearPart.packName = packName;
        }
    }

    public List<GearPart> getPartsOfType(PartType type) {
        return this.stream().filter(part -> part.getType() == type).collect(Collectors.toList());
    }

    @Nullable
    public GearPart fromItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (GearPart part : this) {
            Optional<Ingredient> ingredient = part.getIngredient();
            if (!ingredient.isPresent() || !ingredient.get().test(stack)) continue;
            return part;
        }
        return null;
    }
}

