/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.google.common.primitives.Floats;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;

public class AttributeTraitEffect
extends TraitEffect {
    public static final MapCodec<AttributeTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(Key.CODEC, (Codec)Codec.list(ModifierData.CODEC)).fieldOf("attribute_modifiers").forGetter(e -> e.modifiers)).apply((Applicative)instance, AttributeTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AttributeTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, Key.STREAM_CODEC, (StreamCodec)ModifierData.STREAM_CODEC.apply(ByteBufCodecs.list())), e -> e.modifiers, AttributeTraitEffect::new);
    private final Map<Key, List<ModifierData>> modifiers = new HashMap<Key, List<ModifierData>>();

    public AttributeTraitEffect(Map<Key, List<ModifierData>> map) {
        this.modifiers.putAll(map);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.ATTRIBUTE.get();
    }

    @Override
    public void onGetAttributeModifiers(TraitActionContext context, ItemAttributeModifiers.Builder builder) {
        int traitLevel = context.traitLevel();
        for (Map.Entry<Key, List<ModifierData>> entry : this.modifiers.entrySet()) {
            Key key = entry.getKey();
            List<ModifierData> mods = entry.getValue();
            if (!AttributeTraitEffect.gearMatchesKey(context.gear(), key)) continue;
            for (ModifierData mod : mods) {
                float modValue = mod.values.get(Mth.clamp((int)(traitLevel - 1), (int)0, (int)(mod.values.size() - 1))).floatValue();
                builder.add(mod.attribute, new AttributeModifier(mod.getModId(key, context), (double)modValue, mod.operation), key.group);
            }
        }
    }

    private static boolean gearMatchesKey(ItemStack gear, Key key) {
        GearType gearType = GearHelper.getType(gear);
        return gearType.matches(key.gearType());
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        this.modifiers.forEach((type, list) -> {
            ret.add("  - " + String.valueOf(type));
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class Builder {
        private final Map<Key, List<ModifierData>> mods = new LinkedHashMap<Key, List<ModifierData>>();

        public Builder add(Supplier<GearType> gearType, EquipmentSlotGroup group, Holder<Attribute> attribute, AttributeModifier.Operation operation, float ... values) {
            this.mods.computeIfAbsent(Key.of(gearType.get(), group), k -> new ArrayList()).add(new ModifierData(attribute, Floats.asList((float[])values), operation));
            return this;
        }

        public Builder addAnySlot(Supplier<GearType> gearType, Holder<Attribute> attribute, AttributeModifier.Operation operation, float ... values) {
            return this.add(gearType, EquipmentSlotGroup.ANY, attribute, operation, values);
        }

        public Builder addArmorSlots(Holder<Attribute> attribute, AttributeModifier.Operation operation, float ... values) {
            this.add((Supplier<GearType>)GearTypes.ARMOR, EquipmentSlotGroup.HEAD, attribute, operation, values);
            this.add((Supplier<GearType>)GearTypes.ARMOR, EquipmentSlotGroup.CHEST, attribute, operation, values);
            this.add((Supplier<GearType>)GearTypes.ARMOR, EquipmentSlotGroup.LEGS, attribute, operation, values);
            this.add((Supplier<GearType>)GearTypes.ARMOR, EquipmentSlotGroup.FEET, attribute, operation, values);
            return this;
        }

        public AttributeTraitEffect build() {
            return new AttributeTraitEffect(this.mods);
        }
    }

    public record Key(GearType gearType, EquipmentSlotGroup group) {
        public static final Codec<Key> CODEC = Codec.STRING.comapFlatMap(Key::tryParseKey, Key::key).stable();
        public static final StreamCodec<RegistryFriendlyByteBuf, Key> STREAM_CODEC = StreamCodec.of((buf, val) -> buf.writeUtf(val.key()), buf -> (Key)Key.tryParseKey(buf.readUtf()).getOrThrow());

        public static Key of(GearType gearType, EquipmentSlotGroup group) {
            return new Key(gearType, group);
        }

        private String key() {
            return SilentGear.shortenId(SgRegistries.GEAR_TYPE.getKey((Object)this.gearType)) + "/" + this.group.getSerializedName();
        }

        private static DataResult<Key> tryParseKey(String str) {
            String[] split = str.split("/");
            if (split.length != 2) {
                return DataResult.error(() -> "Invalid key: " + str);
            }
            Identifier gearTypeId = SilentGear.getIdWithDefaultNamespace(split[0]);
            Optional gearTypeOptional = SgRegistries.GEAR_TYPE.get(gearTypeId);
            if (gearTypeOptional.isEmpty()) {
                return DataResult.error(() -> "Unknown gear type: " + String.valueOf(gearTypeId));
            }
            EquipmentSlotGroup group = Key.readGroup(split[1]);
            return DataResult.success((Object)new Key((GearType)((Holder.Reference)gearTypeOptional.get()).value(), group));
        }

        private static EquipmentSlotGroup readGroup(String groupName) {
            for (EquipmentSlotGroup group : EquipmentSlotGroup.values()) {
                if (!group.getSerializedName().equalsIgnoreCase(groupName)) continue;
                return group;
            }
            return EquipmentSlotGroup.ANY;
        }
    }

    public static class ModifierData {
        public static final Codec<ModifierData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(d -> d.attribute), (App)Codec.list((Codec)Codec.FLOAT).fieldOf("values").forGetter(d -> d.values), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(d -> d.operation)).apply((Applicative)instance, ModifierData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ModifierData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ATTRIBUTE), d -> d.attribute, (StreamCodec)ByteBufCodecs.FLOAT.apply(ByteBufCodecs.list()), d -> d.values, (StreamCodec)AttributeModifier.Operation.STREAM_CODEC, d -> d.operation, ModifierData::new);
        private final Holder<Attribute> attribute;
        private final List<Float> values;
        private final AttributeModifier.Operation operation;

        public ModifierData(Holder<Attribute> attribute, List<Float> values, AttributeModifier.Operation operation) {
            this.attribute = attribute;
            this.values = values;
            this.operation = operation;
        }

        public static ModifierData of(Holder<Attribute> attribute, AttributeModifier.Operation operation, Float ... values) {
            return new ModifierData(attribute, Arrays.stream(values).toList(), operation);
        }

        public Identifier getModId(Key key, TraitActionContext context) {
            Identifier itemId = BuiltInRegistries.ITEM.getKey((Object)context.gear().getItem());
            PartInstance primaryPart = GearData.getConstruction(context.gear()).getPrimaryPart();
            MaterialInstance primaryMaterial = primaryPart != null ? primaryPart.getPrimaryMaterial() : null;
            String primaryMaterialIdDotted = primaryMaterial != null ? primaryMaterial.getId().getNamespace() + "." + primaryMaterial.getId().getPath() : "";
            return Identifier.fromNamespaceAndPath((String)itemId.getNamespace(), (String)(itemId.getPath() + "/" + key.group.getSerializedName() + "/" + primaryMaterialIdDotted));
        }

        private String getWikiLine() {
            CharSequence[] valueText = new String[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                valueText[i] = Float.toString(this.values.get(i).floatValue());
            }
            Identifier name = BuiltInRegistries.ATTRIBUTE.getKey((Object)((Attribute)this.attribute.value()));
            return String.valueOf(name) + ": " + this.operation.name() + " [" + String.join((CharSequence)", ", valueText) + "]";
        }
    }
}

