/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.advancements.criterion.PlayerTrigger;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.SgCriteriaTriggers;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.lib.util.MathUtils;

public final class DurabilityTraitEffect
extends TraitEffect {
    public static final MapCodec<DurabilityTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("activation_chance").forGetter(e -> Float.valueOf(e.activationChance)), (App)Codec.INT.fieldOf("effect_scale").forGetter(e -> e.effectScale)).apply((Applicative)instance, DurabilityTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DurabilityTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.FLOAT, e -> Float.valueOf(e.activationChance), (StreamCodec)ByteBufCodecs.VAR_INT, e -> e.effectScale, DurabilityTraitEffect::new);
    private final float activationChance;
    private final int effectScale;

    public DurabilityTraitEffect(float activationChance, int effectScale) {
        this.activationChance = activationChance;
        this.effectScale = effectScale;
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.DURABILITY.get();
    }

    private boolean shouldActivate(int level) {
        return MathUtils.tryPercentage((double)(this.activationChance * (float)level));
    }

    @Override
    public int onDurabilityDamage(TraitActionContext context, int damageTaken) {
        Player player = context.player();
        if (damageTaken != 0 && this.shouldActivate(context.traitLevel())) {
            if (this.effectScale > 0 && player instanceof ServerPlayer) {
                ((PlayerTrigger)SgCriteriaTriggers.BRITTLE_DAMAGE.get()).trigger((ServerPlayer)player);
            }
            return damageTaken + this.effectScale;
        }
        return super.onDurabilityDamage(context, damageTaken);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        int chancePercent = (int)(100.0f * this.activationChance);
        String line = String.format("  - %d damage with a %d%% chance per level", this.effectScale, chancePercent);
        ret.add(line);
        return ret;
    }
}

