/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.silentchaos512.gear.api.event.GearNamePrefixesEvent;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.trait.Trait;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.GearData;

public class OxidationTraitEffect
extends TraitEffect {
    public static final MapCodec<OxidationTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataResource.TRAIT_CODEC.optionalFieldOf("next_oxidation_trait").forGetter(e -> e.nextOxidationTrait), (App)Codec.list((Codec)Codec.INT, (int)1, (int)100).fieldOf("counter_times_per_stage").forGetter(e -> e.counterTimesPerLevel)).apply((Applicative)instance, OxidationTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, OxidationTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)DataResource.TRAIT_STREAM_CODEC.apply(ByteBufCodecs::optional), e -> e.nextOxidationTrait, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), e -> e.counterTimesPerLevel, OxidationTraitEffect::new);
    private final Optional<DataResource<Trait>> nextOxidationTrait;
    private final List<Integer> counterTimesPerLevel;

    protected OxidationTraitEffect(Optional<DataResource<Trait>> nextOxidationTrait, List<Integer> counterTimesPerLevel) {
        this.nextOxidationTrait = nextOxidationTrait;
        this.counterTimesPerLevel = counterTimesPerLevel;
    }

    public static OxidationTraitEffect create(@Nullable DataResource<Trait> nextOxidationTrait, int ... counterTimesInSecondsPerLevel) {
        return new OxidationTraitEffect(Optional.ofNullable(nextOxidationTrait), Arrays.stream(counterTimesInSecondsPerLevel).boxed().toList());
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.OXIDATION.get();
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return List.of();
    }

    @Override
    public Optional<TraitInstance> transformTrait(ItemStack gear, Trait trait, int traitLevel) {
        byte stage = (Byte)gear.getOrDefault(SgDataComponents.OXIDATION_STAGE, (Object)0);
        if (stage == 0) {
            return Optional.empty();
        }
        if (this.nextOxidationTrait.isPresent() && stage >= trait.getMaxLevel()) {
            gear.set(SgDataComponents.OXIDATION_STAGE, (Object)1);
            return Optional.of(TraitInstance.of(this.nextOxidationTrait.get(), (int)stage, new ITraitCondition[0]));
        }
        return Optional.of(TraitInstance.of(trait, (int)stage, new ITraitCondition[0]));
    }

    @Override
    public void inventoryTick(TraitActionContext context, Level level, Entity entity, boolean isEquipped) {
        if (isEquipped || level.isClientSide() || entity.tickCount % 20 != 0 || !this.canOxidize(context, level)) {
            return;
        }
        ItemStack gear = context.gear();
        byte stage = (Byte)gear.getOrDefault(SgDataComponents.OXIDATION_STAGE, (Object)0);
        if (stage >= context.trait().getMaxLevel() && this.nextOxidationTrait.isEmpty()) {
            return;
        }
        int counter = (Integer)gear.getOrDefault(SgDataComponents.OXIDATION_COUNTER, (Object)0);
        if (++counter >= this.getStageTime(context.trait(), context.traitLevel())) {
            counter = 0;
            if (stage < context.trait().getMaxLevel()) {
                stage = (byte)(stage + 1);
            }
            gear.set(SgDataComponents.OXIDATION_STAGE, (Object)stage);
            gear.set(SgDataComponents.RECALCULATE_FLAG, (Object)Unit.INSTANCE);
        }
        gear.set(SgDataComponents.OXIDATION_COUNTER, (Object)counter);
    }

    @Override
    public void onBlockBreak(TraitActionContext context, BlockEvent.BreakEvent event) {
        int reductionAmount = this.getStageTime(context.trait(), context.traitLevel()) / 5 + 1;
        this.reduceOxidationCounter(reductionAmount, context.gear(), context.trait(), context.traitLevel());
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        int reductionAmount = this.getStageTime(context.trait(), context.traitLevel()) / 5 + 1;
        this.reduceOxidationCounter(reductionAmount, context.gear(), context.trait(), context.traitLevel());
        return super.onAttackEntity(context, target, baseValue);
    }

    protected boolean canOxidize(TraitActionContext context, Level level) {
        return !GearData.hasPartOfType(context.gear(), (PartType)PartTypes.COATING.get());
    }

    private int getStageTime(Trait trait, int traitLevel) {
        return this.counterTimesPerLevel.get(Mth.clamp((int)(traitLevel - 1), (int)0, (int)this.counterTimesPerLevel.size()));
    }

    private void reduceOxidationCounter(int amount, ItemStack gear, Trait trait, int traitLevel) {
        byte stage = (Byte)gear.getOrDefault(SgDataComponents.OXIDATION_STAGE, (Object)0);
        int counter = (Integer)gear.getOrDefault(SgDataComponents.OXIDATION_COUNTER, (Object)0);
        if ((counter -= amount) < 0 && stage > 1) {
            stage = (byte)(stage - 1);
            gear.set(SgDataComponents.OXIDATION_STAGE, (Object)stage);
            counter += this.getStageTime(trait, stage);
        }
        int clamped = Mth.clamp((int)counter, (int)0, (int)this.getStageTime(trait, stage));
        gear.set(SgDataComponents.OXIDATION_COUNTER, (Object)clamped);
    }

    @EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onGearNamePrefixes(GearNamePrefixesEvent event) {
        }
    }
}

