/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait.effect;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearArmor;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitEffect;
import net.silentchaos512.gear.api.traits.TraitEffectType;
import net.silentchaos512.gear.setup.gear.GearTypes;
import net.silentchaos512.gear.setup.gear.TraitEffectTypes;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.util.TimeUtils;

public class WielderEffectTraitEffect
extends TraitEffect {
    public static final MapCodec<WielderEffectTraitEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(GearType.CODEC, (Codec)Codec.list(PotionData.CODEC)).fieldOf("potion_effects").forGetter(e -> e.potions)).apply((Applicative)instance, WielderEffectTraitEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, WielderEffectTraitEffect> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, GearType.STREAM_CODEC, (StreamCodec)PotionData.STREAM_CODEC.apply(ByteBufCodecs.list())), e -> e.potions, WielderEffectTraitEffect::new);
    private final Map<GearType, List<PotionData>> potions;

    public WielderEffectTraitEffect(Map<GearType, List<PotionData>> potions) {
        this.potions = ImmutableMap.copyOf(potions);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public TraitEffectType<?> type() {
        return TraitEffectTypes.WIELDER_EFFECT.get();
    }

    @Override
    public void inventoryTick(TraitActionContext context, Level level, Entity entity, boolean isEquipped) {
        if (!isEquipped || context.player() == null || context.player().tickCount % 10 != 0) {
            return;
        }
        GearType gearType = ((GearItem)context.gear().getItem()).getGearType();
        this.potions.forEach((type, list) -> this.applyEffects(context, gearType, (GearType)type, (Iterable<PotionData>)list));
    }

    private void applyEffects(TraitActionContext context, GearType gearType, GearType entryType, Iterable<PotionData> effects) {
        Player player = context.player();
        assert (player != null);
        if (gearType.matches(entryType, true)) {
            int setPieceCount = this.getSetPieceCount(context, entryType, player);
            boolean hasFullSet = !entryType.matches((GearType)GearTypes.ARMOR.get()) || setPieceCount >= 4;
            for (PotionData potionData : effects) {
                MobEffectInstance effect = potionData.getEffect(context.traitLevel(), setPieceCount, hasFullSet);
                if (effect == null) continue;
                player.addEffect(effect);
            }
        }
    }

    private int getSetPieceCount(TraitActionContext context, GearType type, Player player) {
        if (!type.matches((GearType)GearTypes.ARMOR.get())) {
            return 1;
        }
        int count = 0;
        for (EquipmentSlot slot : EquipmentSlotGroup.ARMOR) {
            ItemStack stack = player.getItemBySlot(slot);
            if (!(stack.getItem() instanceof GearArmor) || !TraitHelper.hasTrait(stack, context.trait())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        ArrayList<String> ret = new ArrayList<String>();
        this.potions.forEach((type, list) -> {
            ret.add("  - " + String.valueOf(type));
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class Builder {
        private final Map<GearType, List<PotionData>> effects = new LinkedHashMap<GearType, List<PotionData>>();

        public Builder add(Supplier<GearType> gearType, PotionData effect) {
            this.effects.computeIfAbsent(gearType.get(), gt -> new ArrayList()).add(effect);
            return this;
        }

        public Builder add(Supplier<GearType> gearType, LevelType levelType, Holder<MobEffect> effect, int ... levels) {
            PotionData potionData = PotionData.of(levelType, effect, levels);
            this.effects.computeIfAbsent(gearType.get(), gt -> new ArrayList()).add(potionData);
            return this;
        }

        public WielderEffectTraitEffect build() {
            return new WielderEffectTraitEffect(this.effects);
        }
    }

    public static class PotionData {
        public static final Codec<PotionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LevelType.CODEC.fieldOf("type").forGetter(d -> d.type), (App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("effect").forGetter(d -> d.effect), (App)Codec.INT.fieldOf("duration").forGetter(d -> d.duration), (App)Codec.list((Codec)ExtraCodecs.NON_NEGATIVE_INT).fieldOf("levels").forGetter(d -> d.levels)).apply((Applicative)instance, PotionData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PotionData> STREAM_CODEC = StreamCodec.composite(LevelType.STREAM_CODEC, d -> d.type, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT), d -> d.effect, (StreamCodec)ByteBufCodecs.VAR_INT, d -> d.duration, (StreamCodec)ByteBufCodecs.VAR_INT.apply(ByteBufCodecs.list()), d -> d.levels, PotionData::new);
        private final LevelType type;
        private final Holder<MobEffect> effect;
        private final int duration;
        private final List<Integer> levels;

        public PotionData(LevelType type, Holder<MobEffect> effect, int duration, List<Integer> levels) {
            this.type = type;
            this.effect = effect;
            this.duration = duration;
            this.levels = levels;
        }

        @Deprecated
        public static PotionData of(boolean requiresFullSet, Holder<MobEffect> effect, int ... levels) {
            return PotionData.of(requiresFullSet ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT, effect, levels);
        }

        public static PotionData of(LevelType type, Holder<MobEffect> effect, int ... levels) {
            int duration = TimeUtils.ticksFromSeconds((float)PotionData.getDefaultDuration(effect));
            return new PotionData(type, effect, duration, Arrays.stream(levels).boxed().toList());
        }

        private static float getDefaultDuration(Holder<MobEffect> effect) {
            Identifier nightVision = Identifier.withDefaultNamespace((String)"night_vision");
            return effect.is(nightVision) ? 15.9f : 1.9f;
        }

        @Nullable
        MobEffectInstance getEffect(int traitLevel, int pieceCount, boolean hasFullSet) {
            if (this.type == LevelType.FULL_SET_ONLY && !hasFullSet) {
                return null;
            }
            int effectLevel = this.getEffectLevel(traitLevel, pieceCount, hasFullSet);
            if (effectLevel < 1) {
                return null;
            }
            return new MobEffectInstance(this.effect, this.duration, effectLevel - 1, true, false);
        }

        int getEffectLevel(int traitLevel, int pieceCount, boolean hasFullSet) {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.levels.get(Mth.clamp((int)(traitLevel - 1), (int)0, (int)(this.levels.size() - 1)));
                case 1 -> this.levels.get(Mth.clamp((int)(pieceCount - 1), (int)0, (int)(this.levels.size() - 1)));
                case 2 -> this.levels.getFirst();
            };
        }

        public String getWikiLine() {
            CharSequence[] levelsText = new String[this.levels.size()];
            for (int i = 0; i < this.levels.size(); ++i) {
                levelsText[i] = Integer.toString(this.levels.get(i));
            }
            String effectName = ((MobEffect)this.effect.value()).getDisplayName().getString();
            return String.format("%s: [%s] (%s)", effectName, String.join((CharSequence)", ", levelsText), this.type.wikiText);
        }
    }

    public static enum LevelType {
        TRAIT_LEVEL("by trait level"),
        PIECE_COUNT("by armor piece count"),
        FULL_SET_ONLY("requires full set of armor");

        final String wikiText;
        public static final Codec<LevelType> CODEC;
        public static final StreamCodec<FriendlyByteBuf, LevelType> STREAM_CODEC;

        private LevelType(String wikiText) {
            this.wikiText = wikiText;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        @Nullable
        public static LevelType byName(String name) {
            for (LevelType type : LevelType.values()) {
                if (!type.name().equalsIgnoreCase(name)) continue;
                return type;
            }
            return null;
        }

        static {
            CODEC = Codec.STRING.comapFlatMap(s -> {
                LevelType type = LevelType.byName(s);
                return type != null ? DataResult.success((Object)((Object)type)) : DataResult.error(() -> "Unknown WielderEffectTraitEffect.LevelType: " + s);
            }, type -> type.name().toLowerCase(Locale.ROOT));
            STREAM_CODEC = StreamCodec.of((buf, type) -> buf.writeVarInt(type.ordinal()), buf -> LevelType.values()[buf.readVarInt()]);
        }
    }
}

